/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.EncodingSettings;
import de.fzi.sensidl.design.sensidl.Endianness;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Method;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.extensions.todo.SensIDLTodoTaskCustomizer;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaDTOGenerator
implements IDTOGenerator {
    private static final Logger logger = Logger.getLogger(JavaDTOGenerator.class);
    private static final String LONG_FORMATTED = "l";
    private static final String FLOAT_FORMATTED = "f";
    private static final String DOUBLE_FORMATTED = ".0";
    private final String packagePrefix;
    private final List<DataSet> dataSet;
    private boolean bigEndian;

    public JavaDTOGenerator(List<DataSet> newDataSet, String newPackagePrefix) {
        this.dataSet = newDataSet;
        this.packagePrefix = newPackagePrefix;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        boolean _isBigEndian;
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a java data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        this.bigEndian = _isBigEndian = this.isBigEndian();
        for (DataSet d : this.dataSet) {
            String _nameUpper = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
            String _nameUpper_1 = GenerationUtil.toNameUpper(d);
            CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
            filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
            String _nameUpper_2 = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
            String _plus = "File: " + _addFileExtensionTo_1;
            String _plus_1 = String.valueOf(_plus) + " was generated in ";
            String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
            logger.info((Object)_plus_2);
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    private boolean isBigEndian() {
        DataSet _get = this.dataSet.get(0);
        EObject _eContainer = _get.eContainer();
        SensorInterface _sensorInterface = GenerationUtil.getSensorInterface(_eContainer);
        EncodingSettings _encodingSettings = _sensorInterface.getEncodingSettings();
        Endianness _endianness = _encodingSettings.getEndianness();
        return Objects.equal((Object)_endianness, (Object)Endianness.BIG_ENDIAN);
    }

    public CharSequence generateClassBody(String className, DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)this.packagePrefix, "");
        DataSet _get = this.dataSet.get(0);
        EObject _eContainer = _get.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.newLine();
        if (!this.bigEndian) {
            _builder.append((Object)"import java.nio.ByteBuffer;");
            _builder.newLine();
            _builder.append((Object)"import java.nio.ByteOrder;");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data transfer object for ");
        _builder.append((Object)className, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final long serialVersionUID = 1L;");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateDataFieldsIncludeusedDataSets = this.generateDataFieldsIncludeusedDataSets(d);
        _builder.append((Object)_generateDataFieldsIncludeusedDataSets, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateConstructorIncludeusedDataSets = this.generateConstructorIncludeusedDataSets(d, className);
        _builder.append((Object)_generateConstructorIncludeusedDataSets, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* empty constructor for the Data transfer object");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)className, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateMethods = this.generateMethods(d);
        _builder.append((Object)_generateMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateDataMethodsIncludeusedDataSets = this.generateDataMethodsIncludeusedDataSets(d);
        _builder.append((Object)_generateDataMethodsIncludeusedDataSets, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (!this.bigEndian) {
            _builder.append((Object)"\t");
            CharSequence _generateConverterMethods = this.generateConverterMethods(d);
            _builder.append((Object)_generateConverterMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMethods(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Method.class);
        for (Method method : _filter) {
            boolean _not;
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Method for ");
            String _name = method.getName();
            _builder.append((Object)_name, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            String _description = method.getDescription();
            _builder.append((Object)_description, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            String _methodVisibility = this.getMethodVisibility(method);
            _builder.append((Object)_methodVisibility, "");
            _builder.append((Object)" ");
            String _methodReturnType = this.getMethodReturnType(method);
            _builder.append((Object)_methodReturnType, "");
            _builder.append((Object)" ");
            String _name_1 = method.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"(");
            String _methodParameter = this.getMethodParameter(method);
            _builder.append((Object)_methodParameter, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"//");
            String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
            _builder.append((Object)_sensIDLTodoTag, "\t");
            _builder.append((Object)": Auto Generated method stub");
            _builder.newLineIfNotEmpty();
            String _methodReturnType_1 = this.getMethodReturnType(method);
            boolean _equals = _methodReturnType_1.equals("void");
            boolean bl = _not = !_equals;
            if (_not) {
                _builder.append((Object)"\t");
                _builder.append((Object)"return null;");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public String getMethodVisibility(Method method) {
        boolean _notEquals;
        String _xifexpression = null;
        String _visibility = method.getVisibility();
        boolean bl = _notEquals = !Objects.equal((Object)_visibility, null);
        if (_notEquals) {
            String _visibility_1 = method.getVisibility();
            _xifexpression = SensIDLConstants.getVisibilityOf(_visibility_1);
        } else {
            _xifexpression = SensIDLConstants.getDefaultVisibility();
        }
        return _xifexpression;
    }

    public String getMethodReturnType(Method method) {
        boolean _notEquals_1;
        boolean _notEquals;
        DataType _returnType = method.getReturnType();
        boolean bl = _notEquals = !Objects.equal((Object)_returnType, (Object)DataType.UNDEFINED);
        if (_notEquals) {
            DataType _returnType_1 = method.getReturnType();
            return this.toTypeName(_returnType_1);
        }
        DataSet _returnTypeDataSet = method.getReturnTypeDataSet();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_returnTypeDataSet, null);
        if (_notEquals_1) {
            DataSet _returnTypeDataSet_1 = method.getReturnTypeDataSet();
            return _returnTypeDataSet_1.getName();
        }
        return "void";
    }

    public String getMethodParameter(Method method) {
        boolean _greaterThan;
        String str = "";
        EList _parameter = method.getParameter();
        int _size = _parameter.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _notEquals;
            EList _parameter_1 = method.getParameter();
            MethodParameter _head = (MethodParameter)IterableExtensions.head((Iterable)_parameter_1);
            DataType _dataType = _head.getDataType();
            boolean bl2 = _notEquals = !Objects.equal((Object)_dataType, (Object)DataType.UNDEFINED);
            if (_notEquals) {
                String _plus_1;
                EList _parameter_2 = method.getParameter();
                MethodParameter _head_1 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_2);
                DataType _dataType_1 = _head_1.getDataType();
                String _typeName = this.toTypeName(_dataType_1);
                String _plus = String.valueOf(_typeName) + " ";
                EList _parameter_3 = method.getParameter();
                MethodParameter _head_2 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_3);
                String _name = _head_2.getName();
                str = _plus_1 = String.valueOf(_plus) + _name;
            } else {
                boolean _notEquals_1;
                EList _parameter_4 = method.getParameter();
                MethodParameter _head_3 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_4);
                DataSet _dataTypeDataSet = _head_3.getDataTypeDataSet();
                boolean bl3 = _notEquals_1 = !Objects.equal((Object)_dataTypeDataSet, null);
                if (_notEquals_1) {
                    String _plus_3;
                    EList _parameter_5 = method.getParameter();
                    MethodParameter _head_4 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_5);
                    DataSet _dataTypeDataSet_1 = _head_4.getDataTypeDataSet();
                    String _name_1 = _dataTypeDataSet_1.getName();
                    String _plus_2 = String.valueOf(_name_1) + " ";
                    EList _parameter_6 = method.getParameter();
                    MethodParameter _head_5 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_6);
                    String _name_2 = _head_5.getName();
                    str = _plus_3 = String.valueOf(_plus_2) + _name_2;
                }
            }
            EList _parameter_7 = method.getParameter();
            Iterable _tail = IterableExtensions.tail((Iterable)_parameter_7);
            for (MethodParameter p : _tail) {
                boolean _notEquals_3;
                boolean _notEquals_2;
                DataType _dataType_2 = p.getDataType();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_dataType_2, (Object)DataType.UNDEFINED);
                if (_notEquals_2) {
                    String _str = str;
                    DataType _dataType_3 = p.getDataType();
                    String _typeName_1 = this.toTypeName(_dataType_3);
                    String _plus_4 = ", " + _typeName_1;
                    String _plus_5 = String.valueOf(_plus_4) + " ";
                    String _name_3 = p.getName();
                    String _plus_6 = String.valueOf(_plus_5) + _name_3;
                    str = String.valueOf(_str) + _plus_6;
                    continue;
                }
                DataSet _dataTypeDataSet_2 = p.getDataTypeDataSet();
                boolean bl5 = _notEquals_3 = !Objects.equal((Object)_dataTypeDataSet_2, null);
                if (!_notEquals_3) continue;
                String _str_1 = str;
                DataSet _dataTypeDataSet_3 = p.getDataTypeDataSet();
                String _name_4 = _dataTypeDataSet_3.getName();
                String _plus_7 = ", " + _name_4;
                String _plus_8 = String.valueOf(_plus_7) + " ";
                String _name_5 = p.getName();
                String _plus_9 = String.valueOf(_plus_8) + _name_5;
                str = String.valueOf(_str_1) + _plus_9;
            }
        }
        return str;
    }

    public String toTypeName(String s) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)s, (Object)"INT8")) {
            _matched = true;
            _switchResult = Byte.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"UINT8")) {
            _matched = true;
            _switchResult = Byte.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"INT16")) {
            _matched = true;
            _switchResult = Short.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"UINT16")) {
            _matched = true;
            _switchResult = Short.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"INT32")) {
            _matched = true;
            _switchResult = Integer.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"UINT32")) {
            _matched = true;
            _switchResult = Integer.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"INT64")) {
            _matched = true;
            _switchResult = Long.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"UINT64")) {
            _matched = true;
            _switchResult = Long.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"FLOAT")) {
            _matched = true;
            _switchResult = Float.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"DOUBLE")) {
            _matched = true;
            _switchResult = Double.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"BOOLEAN")) {
            _matched = true;
            _switchResult = Boolean.class.getName();
        }
        if (!_matched && Objects.equal((Object)s, (Object)"STRING")) {
            _matched = true;
            _switchResult = String.class.getName();
        }
        return _switchResult;
    }

    public CharSequence generateDataFieldsIncludeusedDataSets(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
        for (NonMeasurementData data : _filter) {
            _builder.newLine();
            CharSequence _generateDataFields = this.generateDataFields(data);
            _builder.append((Object)_generateDataFields, "");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_1 = d.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
        for (MeasurementData data_1 : _filter_1) {
            CharSequence _generateDataFields_1 = this.generateDataFields(data_1);
            _builder.append((Object)_generateDataFields_1, "");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_2 = d.eContents();
        Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, ListData.class);
        for (ListData data_2 : _filter_2) {
            CharSequence _generateDataFields_2 = this.generateDataFields(data_2);
            _builder.append((Object)_generateDataFields_2, "");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet dataSet : _usedDataSets) {
            CharSequence _generateDataFields_3 = this.generateDataFields(dataSet);
            _builder.append((Object)_generateDataFields_3, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateDataFields(DataSet dataSet) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*\t");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        String _description = dataSet.getDescription();
        _builder.append((Object)_description, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private ");
        String _nameUpper = GenerationUtil.toNameUpper(dataSet);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower(dataSet);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateDataFields(ListData data) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _description = data.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)"/* ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/ ");
            _builder.newLine();
        }
        _builder.append((Object)"private List<");
        String _listType = this.getListType(data);
        _builder.append((Object)_listType, "");
        _builder.append((Object)"> ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = new ArrayList<");
        String _listType_1 = this.getListType(data);
        _builder.append((Object)_listType_1, "");
        _builder.append((Object)">();");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateDataFields(MeasurementData d) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        String _description = d.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            String _description_1 = d.getDescription();
            _builder.append((Object)_description_1, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* Unit: ");
        Unit _unit = d.getUnit();
        _builder.append((Object)_unit, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasLinearDataConversionWithInterval = this.hasLinearDataConversionWithInterval(d);
        if (_hasLinearDataConversionWithInterval) {
            boolean _notEquals_1;
            _builder.append((Object)"/*");
            _builder.newLine();
            String _description_2 = d.getDescription();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                _builder.append((Object)" * ");
                String _description_3 = d.getDescription();
                _builder.append((Object)_description_3, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                _builder.newLine();
            }
            _builder.append((Object)" ");
            _builder.append((Object)"* Unit: ");
            Unit _unit_1 = d.getUnit();
            _builder.append((Object)_unit_1, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* Adjusted");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"private ");
            DataType _dataConversionType = this.getDataConversionType(d);
            String _typeName_1 = this.toTypeName(_dataConversionType);
            _builder.append((Object)_typeName_1, "");
            _builder.append((Object)" ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, "");
            _builder.append((Object)"Adjusted;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateDataFields(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            boolean _notEquals;
            StringConcatenation _builder = new StringConcatenation();
            String _description = d.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                _builder.append((Object)"/*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                String _description_1 = d.getDescription();
                _builder.append((Object)_description_1, " ");
                _builder.newLineIfNotEmpty();
                DataType _dataType = d.getDataType();
                boolean _isUnsigned = this.isUnsigned(_dataType);
                if (_isUnsigned) {
                    _builder.append((Object)" ");
                    _builder.append((Object)"*");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* Java has no option for unsigned data types, so if the data has an ");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* unsigned data type the value is calculated by subtracting the maximum ");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* value from the signed data type and adding it again, if it is used.");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*");
                    _builder.newLine();
                }
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
            }
            _builder.append((Object)"private ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = ");
            DataType _dataType_1 = d.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder.append((Object)_simpleTypeName, "");
                _builder.append((Object)") (");
                String _value = d.getValue();
                _builder.append((Object)_value, "");
                _builder.append((Object)" - ");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)".MAX_VALUE)");
            } else {
                DataType _dataType_2 = d.getDataType();
                boolean _equals = Objects.equal((Object)_dataType_2, (Object)DataType.STRING);
                if (_equals) {
                    _builder.append((Object)"\"");
                    String _value_1 = d.getValue();
                    _builder.append((Object)_value_1, "");
                    _builder.append((Object)"\"");
                } else {
                    String _formatedValue = this.getFormatedValue(d);
                    _builder.append((Object)_formatedValue, "");
                }
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            boolean _not;
            boolean _notEquals_1;
            StringConcatenation _builder_1 = new StringConcatenation();
            String _description_2 = d.getDescription();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                _builder_1.append((Object)"/*");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*");
                String _description_3 = d.getDescription();
                _builder_1.append((Object)_description_3, " ");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*/");
                _builder_1.newLine();
            }
            _builder_1.append((Object)"private ");
            String _typeName_2 = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName_2, "");
            _builder_1.append((Object)" ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, "");
            String _value_2 = d.getValue();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_value_2);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                _builder_1.append((Object)" = ");
                DataType _dataType_3 = d.getDataType();
                boolean _equals_1 = Objects.equal((Object)_dataType_3, (Object)DataType.STRING);
                if (_equals_1) {
                    _builder_1.append((Object)"\"");
                    String _value_3 = d.getValue();
                    _builder_1.append((Object)_value_3, "");
                    _builder_1.append((Object)"\"");
                } else {
                    String _formatedValue_1 = this.getFormatedValue(d);
                    _builder_1.append((Object)_formatedValue_1, "");
                }
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private String getFormatedValue(NonMeasurementData data) {
        String _name_2;
        String _typeName_2;
        boolean _equals_2;
        String _name_1;
        String _typeName_1;
        boolean _equals_1;
        String _name;
        String _xblockexpression = null;
        String value = data.getValue();
        String _typeName = this.toTypeName((Data)data);
        boolean _equals = _typeName.equals(_name = Long.class.getName());
        if (_equals) {
            String _value = value;
            value = String.valueOf(_value) + LONG_FORMATTED;
        }
        if (_equals_1 = (_typeName_1 = this.toTypeName((Data)data)).equals(_name_1 = Float.class.getName())) {
            String _value_1 = value;
            value = String.valueOf(_value_1) + FLOAT_FORMATTED;
        }
        if (_equals_2 = (_typeName_2 = this.toTypeName((Data)data)).equals(_name_2 = Double.class.getName())) {
            String _value_2 = value;
            value = String.valueOf(_value_2) + DOUBLE_FORMATTED;
        }
        _xblockexpression = value;
        return _xblockexpression;
    }

    public CharSequence generateConstructorIncludeusedDataSets(DataSet d, String className) {
        boolean _greaterThan;
        StringConcatenation _xifexpression = null;
        ArrayList<Data> _nonConstantData = this.getNonConstantData(d);
        int _size = _nonConstantData.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Constructor for the Data transfer object");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public ");
            _builder.append((Object)className, "");
            _builder.append((Object)"(");
            CharSequence _generateConstructorArgumentsIncludeusedDataSetss = this.generateConstructorArgumentsIncludeusedDataSetss(d);
            _builder.append((Object)_generateConstructorArgumentsIncludeusedDataSetss, "");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            EList _eContents = d.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
            for (MeasurementData data : _filter) {
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _nameLower = GenerationUtil.toNameLower((Data)data);
                _builder.append((Object)_nameLower, "\t");
                _builder.append((Object)" = ");
                DataType _dataType = data.getDataType();
                boolean _isUnsigned = this.isUnsigned(_dataType);
                if (_isUnsigned) {
                    _builder.append((Object)"(");
                    String _simpleTypeName = this.toSimpleTypeName((Data)data);
                    _builder.append((Object)_simpleTypeName, "\t");
                    _builder.append((Object)") (");
                    String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
                    _builder.append((Object)_nameLower_1, "\t");
                    _builder.append((Object)" - ");
                    String _typeName = this.toTypeName((Data)data);
                    _builder.append((Object)_typeName, "\t");
                    _builder.append((Object)".MAX_VALUE)");
                } else {
                    String _nameLower_2 = GenerationUtil.toNameLower((Data)data);
                    _builder.append((Object)_nameLower_2, "\t");
                }
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            EList _eContents_1 = d.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
            for (NonMeasurementData data_1 : _filter_1) {
                boolean _not;
                boolean _isConstant = data_1.isConstant();
                boolean bl2 = _not = !_isConstant;
                if (!_not) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _nameLower_3 = GenerationUtil.toNameLower((Data)data_1);
                _builder.append((Object)_nameLower_3, "\t");
                _builder.append((Object)" = ");
                DataType _dataType_1 = data_1.getDataType();
                boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
                if (_isUnsigned_1) {
                    _builder.append((Object)"(");
                    String _simpleTypeName_1 = this.toSimpleTypeName((Data)data_1);
                    _builder.append((Object)_simpleTypeName_1, "\t");
                    _builder.append((Object)") (");
                    String _nameLower_4 = GenerationUtil.toNameLower((Data)data_1);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" - ");
                    String _typeName_1 = this.toTypeName((Data)data_1);
                    _builder.append((Object)_typeName_1, "\t");
                    _builder.append((Object)".MAX_VALUE)");
                } else {
                    String _nameLower_5 = GenerationUtil.toNameLower((Data)data_1);
                    _builder.append((Object)_nameLower_5, "\t");
                }
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            EList _usedDataSets = d.getUsedDataSets();
            for (DataSet pdataSet : _usedDataSets) {
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _nameLower_6 = GenerationUtil.toNameLower(pdataSet);
                _builder.append((Object)_nameLower_6, "\t");
                _builder.append((Object)" = ");
                String _nameLower_7 = GenerationUtil.toNameLower(pdataSet);
                _builder.append((Object)_nameLower_7, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1;
            _xifexpression = _builder_1 = new StringConcatenation();
        }
        return _xifexpression;
    }

    public CharSequence generateConstructorArgumentsIncludeusedDataSetss(DataSet d) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        ArrayList<Data> dataList = this.getNonConstantData(d);
        StringConcatenation _xifexpression = null;
        int _size = dataList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _greaterThan_1;
            StringConcatenation _xblockexpression_1 = null;
            Data _get = dataList.get(0);
            String _typeName = this.toTypeName(_get);
            String _plus = String.valueOf(_typeName) + " ";
            Data _get_1 = dataList.get(0);
            String _nameLower = GenerationUtil.toNameLower(_get_1);
            String firstElement = String.valueOf(_plus) + _nameLower;
            dataList.remove(0);
            StringConcatenation _xifexpression_1 = null;
            EList _usedDataSets = d.getUsedDataSets();
            int _size_1 = _usedDataSets.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)firstElement, "");
                for (Data data : dataList) {
                    _builder.append((Object)", ");
                    String _typeName_1 = this.toTypeName(data);
                    _builder.append((Object)_typeName_1, "");
                    _builder.append((Object)" ");
                    String _nameLower_1 = GenerationUtil.toNameLower(data);
                    _builder.append((Object)_nameLower_1, "");
                }
                EList _usedDataSets_1 = d.getUsedDataSets();
                for (DataSet pdataSet : _usedDataSets_1) {
                    _builder.append((Object)", ");
                    String _nameUpper = GenerationUtil.toNameUpper(pdataSet);
                    _builder.append((Object)_nameUpper, "");
                    _builder.append((Object)" ");
                    String _nameLower_2 = GenerationUtil.toNameLower(pdataSet);
                    _builder.append((Object)_nameLower_2, "");
                }
                _xifexpression_1 = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)firstElement, "");
                for (Data data_1 : dataList) {
                    _builder_1.append((Object)", ");
                    String _typeName_2 = this.toTypeName(data_1);
                    _builder_1.append((Object)_typeName_2, "");
                    _builder_1.append((Object)" ");
                    String _nameLower_3 = GenerationUtil.toNameLower(data_1);
                    _builder_1.append((Object)_nameLower_3, "");
                }
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            StringConcatenation _builder;
            _xifexpression = _builder = new StringConcatenation();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ArrayList<Data> getNonConstantData(DataSet d) {
        ArrayList<Data> dataList = new ArrayList<Data>();
        DataSet dataSet = d;
        EList _eContents = dataSet.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            if (data instanceof NonMeasurementData) {
                boolean _not;
                NonMeasurementData nmdata = (NonMeasurementData)data;
                boolean _isConstant = nmdata.isConstant();
                boolean bl = _not = !_isConstant;
                if (!_not) continue;
                dataList.add(data);
                continue;
            }
            if (data instanceof ListData) continue;
            dataList.add(data);
        }
        return dataList;
    }

    public CharSequence generateDataMethodsIncludeusedDataSets(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        for (MeasurementData data : _filter) {
            EList _excludedMethods_1;
            boolean _contains_1;
            boolean _not_1;
            boolean _not;
            EList _excludedMethods = data.getExcludedMethods();
            boolean _contains = _excludedMethods.contains((Object)"getter");
            boolean bl = _not = !_contains;
            if (_not) {
                CharSequence _generateGetter = this.generateGetter(data);
                _builder.append((Object)_generateGetter, "");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _not_1 = !(_contains_1 = (_excludedMethods_1 = data.getExcludedMethods()).contains((Object)"setter"));
            if (!_not_1) continue;
            CharSequence _generateSetter = this.generateSetter(data);
            _builder.append((Object)_generateSetter, "");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_1 = d.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        for (NonMeasurementData data_1 : _filter_1) {
            EList _excludedMethods_3;
            boolean _contains_3;
            boolean _not_3;
            boolean _not_2;
            EList _excludedMethods_2 = data_1.getExcludedMethods();
            boolean _contains_2 = _excludedMethods_2.contains((Object)"getter");
            boolean bl = _not_2 = !_contains_2;
            if (_not_2) {
                CharSequence _generateGetter_1 = this.generateGetter(data_1);
                _builder.append((Object)_generateGetter_1, "");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_3 = !(_contains_3 = (_excludedMethods_3 = data_1.getExcludedMethods()).contains((Object)"setter"));
            if (!_not_3) continue;
            CharSequence _generateSetter_1 = this.generateSetter(data_1);
            _builder.append((Object)_generateSetter_1, "");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_2 = d.eContents();
        Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, ListData.class);
        for (ListData data_2 : _filter_2) {
            CharSequence _generateAddMethod = this.generateAddMethod(data_2);
            _builder.append((Object)_generateAddMethod, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            CharSequence _generateGetter_2 = this.generateGetter(data_2);
            _builder.append((Object)_generateGetter_2, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            CharSequence _generateSetter_2 = this.generateSetter(data_2);
            _builder.append((Object)_generateSetter_2, "");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            _builder.newLine();
            CharSequence _generateGetter_3 = this.generateGetter(pdataSet);
            _builder.append((Object)_generateGetter_3, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            CharSequence _generateSetter_3 = this.generateSetter(pdataSet);
            _builder.append((Object)_generateSetter_3, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String getListType(ListData data) {
        boolean _notEquals_1;
        boolean _notEquals;
        DataType _dataType = data.getDataType();
        boolean bl = _notEquals = !Objects.equal((Object)_dataType, (Object)DataType.UNDEFINED);
        if (_notEquals) {
            DataType _dataType_1 = data.getDataType();
            return this.toTypeName(_dataType_1);
        }
        DataSet _dataTypeDataSet = data.getDataTypeDataSet();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dataTypeDataSet, null);
        if (_notEquals_1) {
            DataSet _dataTypeDataSet_1 = data.getDataTypeDataSet();
            return _dataTypeDataSet_1.getName();
        }
        return null;
    }

    public CharSequence toGetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence toSetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateGetter(ListData data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Get the ");
        String _name = data.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" list");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public List<");
        String _listType = this.getListType(data);
        _builder.append((Object)_listType, "");
        _builder.append((Object)"> ");
        CharSequence _getterName = this.toGetterName((Data)data);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Get the a specific element from the ");
        String _name_1 = data.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" list or null if not found");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _listType_1 = this.getListType(data);
        _builder.append((Object)_listType_1, "");
        _builder.append((Object)" ");
        CharSequence _getterName_1 = this.toGetterName((Data)data);
        _builder.append((Object)_getterName_1, "");
        _builder.append((Object)"(");
        String _listType_2 = this.getListType(data);
        _builder.append((Object)_listType_2, "");
        _builder.append((Object)" obj){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if(this.");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)".indexOf(obj) == -1){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        String _nameLower_2 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_2, "\t");
        _builder.append((Object)".get(this.");
        String _nameLower_3 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_3, "\t");
        _builder.append((Object)".indexOf(obj));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetter(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _nameUpper = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" get");
        String _nameUpper_1 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        String _nameLower_1 = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetter(MeasurementData d) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasLinearDataConversionWithInterval = this.hasLinearDataConversionWithInterval(d);
        boolean bl = _not = !_hasLinearDataConversionWithInterval;
        if (_not) {
            _builder.append((Object)"/**");
            _builder.newLine();
            DataType _dataType = d.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
                _builder.append((Object)" ");
                _builder.append((Object)"* Java has no option for unsigned data types, so if the data has an ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* unsigned data type the value is calculated by subtracting the maximum ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* value from the signed data type and adding it again, if it is used.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                _builder.newLine();
            }
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            CharSequence _getterName = this.toGetterName((Data)d);
            _builder.append((Object)_getterName, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            DataType _dataType_1 = d.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder.append((Object)_simpleTypeName, "\t");
                _builder.append((Object)") (this.");
                String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_1, "\t");
                _builder.append((Object)" + ");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "\t");
                _builder.append((Object)".MAX_VALUE)");
            } else {
                _builder.append((Object)"this.");
                String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_2, "\t");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the ");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_3, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public ");
            DataType _dataConversionType = this.getDataConversionType(d);
            String _typeName_2 = this.toTypeName(_dataConversionType);
            _builder.append((Object)_typeName_2, "");
            _builder.append((Object)" ");
            CharSequence _getterName_1 = this.toGetterName((Data)d);
            _builder.append((Object)_getterName_1, "");
            _builder.append((Object)"(){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return this.");
            String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_4, "\t");
            _builder.append((Object)"Adjusted;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return the ");
            String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_5, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _typeName_3 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_3, "");
            _builder.append((Object)" ");
            CharSequence _getterName_2 = this.toGetterName((Data)d);
            _builder.append((Object)_getterName_2, "");
            _builder.append((Object)"NotAdjusted(){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            DataType _dataType_2 = d.getDataType();
            boolean _isUnsigned_2 = this.isUnsigned(_dataType_2);
            if (_isUnsigned_2) {
                _builder.append((Object)"(");
                String _simpleTypeName_1 = this.toSimpleTypeName((Data)d);
                _builder.append((Object)_simpleTypeName_1, "\t");
                _builder.append((Object)") (this.");
                String _nameLower_6 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_6, "\t");
                _builder.append((Object)" + ");
                String _typeName_4 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_4, "\t");
                _builder.append((Object)".MAX_VALUE)");
            } else {
                _builder.append((Object)"this.");
                String _nameLower_7 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_7, "\t");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateGetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        DataType _dataType = d.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType);
        if (_isUnsigned) {
            _builder.append((Object)" ");
            _builder.append((Object)"* Java has no option for unsigned data types, so if the data has an ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* unsigned data type the value is calculated by subtracting the maximum ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* value from the signed data type and adding it again, if it is used.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        DataType _dataType_1 = d.getDataType();
        boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
        if (_isUnsigned_1) {
            _builder.append((Object)"(");
            String _simpleTypeName = this.toSimpleTypeName((Data)d);
            _builder.append((Object)_simpleTypeName, "\t");
            _builder.append((Object)") (");
            boolean _isConstant = d.isConstant();
            if (_isConstant) {
                String _name = d.getName();
                String _upperCase = _name.toUpperCase();
                _builder.append((Object)_upperCase, "\t");
            } else {
                _builder.append((Object)"this.");
                String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_1, "\t");
            }
            _builder.append((Object)" + ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)".MAX_VALUE)");
        } else {
            _builder.append((Object)"this.");
            boolean _isConstant_1 = d.isConstant();
            if (_isConstant_1) {
                String _name_1 = d.getName();
                String _upperCase_1 = _name_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "\t");
            } else {
                String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_2, "\t");
            }
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateAddMethod(ListData data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Add Data to the ");
        String _name = data.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" list");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        String _name_1 = data.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, " ");
        _builder.append((Object)"Element ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t\t\t\tthe object to add to the list");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public void add");
        String _name_2 = data.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(");
        String _listType = this.getListType(data);
        _builder.append((Object)_listType, "");
        _builder.append((Object)" ");
        String _name_3 = data.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_1, "");
        _builder.append((Object)"Element){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "\t");
        _builder.append((Object)".add(");
        String _name_4 = data.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)"Element);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSetter(ListData data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Set the ");
        String _name = data.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" list");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        String _name_1 = data.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* \t\t\t\tthe list to set");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public void ");
        CharSequence _setterName = this.toSetterName((Data)data);
        _builder.append((Object)_setterName, "");
        _builder.append((Object)"(List<");
        String _listType = this.getListType(data);
        _builder.append((Object)_listType, "");
        _builder.append((Object)"> ");
        String _name_2 = data.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower_1, "");
        _builder.append((Object)"){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "\t");
        _builder.append((Object)" = ");
        String _name_3 = data.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_3);
        _builder.append((Object)_firstLower_2, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSetter(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param info");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the ");
        String _nameLower = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower, " ");
        _builder.append((Object)" to set");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public void set");
        String _nameUpper = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)"(");
        String _nameUpper_1 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)" ");
        String _nameLower_1 = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.");
        String _nameLower_2 = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower_2, "\t");
        _builder.append((Object)" = ");
        String _nameLower_3 = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower_3, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSetter(MeasurementData d) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*            the ");
                    String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.append((Object)"public void ");
                    CharSequence _setterName = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName, "");
                    _builder.append((Object)"WithRange(");
                    String _typeName = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName, "");
                    _builder.append((Object)" ");
                    String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this.");
                    String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "\t\t");
                    _builder.append((Object)" = ");
                    String _nameLower_6 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"throw new IllegalArgumentException(\"value is out of defined range\");\t");
                    _builder.newLine();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                    continue;
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param ");
                String _nameLower_7 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_7, " ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*            the ");
                String _nameLower_8 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_8, " ");
                _builder.append((Object)" to set");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"public void ");
                CharSequence _setterName_1 = this.toSetterName((Data)d);
                _builder.append((Object)_setterName_1, "");
                _builder.append((Object)"WithDataConversion(");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_9 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_9, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, (DataConversion)dataAdj);
                _builder.append((Object)_generateSetterBodyForMeasurementData, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"} catch (IllegalArgumentException e) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//Do something");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        String _nameLower_10 = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower_10, " ");
        _builder.append((Object)"  ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the ");
        String _nameLower_11 = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower_11, " ");
        _builder.append((Object)" to set");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public void ");
        CharSequence _setterName_2 = this.toSetterName((Data)d);
        _builder.append((Object)_setterName_2, "");
        _builder.append((Object)"(");
        String _typeName_2 = this.toTypeName((Data)d);
        _builder.append((Object)_typeName_2, "");
        _builder.append((Object)" ");
        String _nameLower_12 = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower_12, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.");
        String _nameLower_13 = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower_13, "\t");
        _builder.append((Object)" = ");
        DataType _dataType = d.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType);
        if (_isUnsigned) {
            _builder.append((Object)"(");
            String _simpleTypeName = this.toSimpleTypeName((Data)d);
            _builder.append((Object)_simpleTypeName, "\t");
            _builder.append((Object)") (");
            String _nameLower_14 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_14, "\t");
            _builder.append((Object)" - ");
            String _typeName_3 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_3, "\t");
            _builder.append((Object)".MAX_VALUE)");
        } else {
            String _nameLower_15 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_15, "\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"} ");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversion conversion) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"final double offset = ");
        double _offset = conversion.getOffset();
        _builder.append((Object)_offset, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"final double scalingFactor = ");
        double _scalingFactor = conversion.getScalingFactor();
        _builder.append((Object)_scalingFactor, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", scalingFactor, offset);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversionWithInterval conversion) {
        StringConcatenation _builder = new StringConcatenation();
        DataType _dataType = conversion.getDataType();
        String _typeName = this.toTypeName(_dataType);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" oldMin = (");
        DataType _dataType_1 = conversion.getDataType();
        String _simpleTypeName = this.toSimpleTypeName(_dataType_1);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        Interval _fromInterval = conversion.getFromInterval();
        double _lowerBound = _fromInterval.getLowerBound();
        _builder.append((Object)_lowerBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        DataType _dataType_2 = conversion.getDataType();
        String _typeName_1 = this.toTypeName(_dataType_2);
        _builder.append((Object)_typeName_1, "");
        _builder.append((Object)" oldMax = (");
        DataType _dataType_3 = conversion.getDataType();
        String _simpleTypeName_1 = this.toSimpleTypeName(_dataType_3);
        _builder.append((Object)_simpleTypeName_1, "");
        _builder.append((Object)") ");
        Interval _fromInterval_1 = conversion.getFromInterval();
        double _upperBound = _fromInterval_1.getUpperBound();
        _builder.append((Object)_upperBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        DataType _dataType_4 = conversion.getDataType();
        String _typeName_2 = this.toTypeName(_dataType_4);
        _builder.append((Object)_typeName_2, "");
        _builder.append((Object)" newMin = (");
        DataType _dataType_5 = conversion.getDataType();
        String _simpleTypeName_2 = this.toSimpleTypeName(_dataType_5);
        _builder.append((Object)_simpleTypeName_2, "");
        _builder.append((Object)") ");
        Interval _toInterval = conversion.getToInterval();
        double _lowerBound_1 = _toInterval.getLowerBound();
        _builder.append((Object)_lowerBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        DataType _dataType_6 = conversion.getDataType();
        String _typeName_3 = this.toTypeName(_dataType_6);
        _builder.append((Object)_typeName_3, "");
        _builder.append((Object)" newMax = (");
        DataType _dataType_7 = conversion.getDataType();
        String _simpleTypeName_3 = this.toSimpleTypeName(_dataType_7);
        _builder.append((Object)_simpleTypeName_3, "");
        _builder.append((Object)") ");
        Interval _toInterval_1 = conversion.getToInterval();
        double _upperBound_1 = _toInterval_1.getUpperBound();
        _builder.append((Object)_upperBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = ");
        DataType _dataType_8 = data.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType_8);
        if (_isUnsigned) {
            _builder.append((Object)"(");
            String _simpleTypeName_4 = this.toSimpleTypeName((Data)data);
            _builder.append((Object)_simpleTypeName_4, "");
            _builder.append((Object)") (");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_1, "");
            _builder.append((Object)" - ");
            String _typeName_4 = this.toTypeName((Data)data);
            _builder.append((Object)_typeName_4, "");
            _builder.append((Object)".MAX_VALUE)");
        } else {
            String _nameLower_2 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_2, "");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"this.");
        String _nameLower_3 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_3, "");
        _builder.append((Object)"Adjusted = (");
        DataType _dataType_9 = conversion.getDataType();
        String _simpleTypeName_5 = this.toSimpleTypeName(_dataType_9);
        _builder.append((Object)_simpleTypeName_5, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(");
        String _nameLower_4 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_4, "");
        _builder.append((Object)", oldMin, oldMax, newMin, newMax);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateSetter(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"/**");
            _builder_1.newLine();
            DataType _dataType = d.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"* Java has no option for unsigned data types, so if the data has an ");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"* unsigned data type the value is calculated by subtracting the maximum ");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"* value from the signed data type and adding it again, if it is used.");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*");
                _builder_1.newLine();
            }
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"* @param ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, " ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*            the ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_1, " ");
            _builder_1.append((Object)" to set");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*/");
            _builder_1.newLine();
            _builder_1.append((Object)"public void ");
            CharSequence _setterName = this.toSetterName((Data)d);
            _builder_1.append((Object)_setterName, "");
            _builder_1.append((Object)"(");
            String _typeName = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)" ");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_2, "");
            _builder_1.append((Object)"){");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            _builder_1.append((Object)"this.");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_3, "\t");
            _builder_1.append((Object)" = ");
            DataType _dataType_1 = d.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder_1.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder_1.append((Object)_simpleTypeName, "\t");
                _builder_1.append((Object)") (");
                String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                _builder_1.append((Object)_nameLower_4, "\t");
                _builder_1.append((Object)" - ");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder_1.append((Object)_typeName_1, "\t");
                _builder_1.append((Object)".MAX_VALUE)");
            } else {
                String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                _builder_1.append((Object)_nameLower_5, "\t");
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"} ");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    @Override
    public String toTypeName(Data d) {
        DataType _dataType = d.getDataType();
        return this.toTypeName(_dataType);
    }

    public String toTypeName(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case UINT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case INT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case UINT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case INT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case INT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case UINT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class.getName();
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class.getName();
                    break;
                }
                case BOOLEAN: {
                    _switchResult = Boolean.class.getName();
                    break;
                }
                case STRING: {
                    _switchResult = String.class.getName();
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    public boolean isUnsigned(DataType d) {
        boolean _equals_3;
        boolean _equals_2;
        boolean _equals_1;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _equals = Objects.equal((Object)d, (Object)DataType.UINT8);
        _or_2 = _equals ? true : (_equals_1 = Objects.equal((Object)d, (Object)DataType.UINT16));
        _or_1 = _or_2 ? true : (_equals_2 = Objects.equal((Object)d, (Object)DataType.UINT32));
        _or = _or_1 ? true : (_equals_3 = Objects.equal((Object)d, (Object)DataType.UINT64));
        return _or;
    }

    public String toSimpleTypeName(Data d) {
        DataType _dataType = d.getDataType();
        return this.toSimpleTypeName(_dataType);
    }

    public String toSimpleTypeName(DataType d) {
        String _switchResult = null;
        if (d != null) {
            switch (d) {
                case INT8: {
                    _switchResult = "byte";
                    break;
                }
                case UINT8: {
                    _switchResult = "byte";
                    break;
                }
                case INT16: {
                    _switchResult = "short";
                    break;
                }
                case UINT16: {
                    _switchResult = "short";
                    break;
                }
                case INT32: {
                    _switchResult = "int";
                    break;
                }
                case UINT32: {
                    _switchResult = "int";
                    break;
                }
                case INT64: {
                    _switchResult = "long";
                    break;
                }
                case UINT64: {
                    _switchResult = "long";
                    break;
                }
                case FLOAT: {
                    _switchResult = "float";
                    break;
                }
                case DOUBLE: {
                    _switchResult = "double";
                    break;
                }
                case BOOLEAN: {
                    _switchResult = "boolean";
                    break;
                }
                case STRING: {
                    _switchResult = "String";
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    public DataType getDataConversionType(MeasurementData d) {
        boolean _equals;
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        if (_isEmpty) {
            return null;
        }
        EList _adjustments_1 = d.getAdjustments();
        Iterable conversion = Iterables.filter((Iterable)_adjustments_1, LinearDataConversionWithInterval.class);
        boolean _or = false;
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)conversion);
        _or = _isEmpty_1 ? true : (_equals = Objects.equal((Object)conversion, null));
        if (_or) {
            return null;
        }
        LinearDataConversionWithInterval _head = (LinearDataConversionWithInterval)IterableExtensions.head((Iterable)conversion);
        return _head.getDataType();
    }

    public boolean hasLinearDataConversionWithInterval(MeasurementData data) {
        EList _adjustments = data.getAdjustments();
        Iterable _filter = Iterables.filter((Iterable)_adjustments, LinearDataConversionWithInterval.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
        return !_isEmpty;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }

    public CharSequence generateConverterMethods(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Converts a big endian ");
            String _nameUpper = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper, " ");
            _builder.append((Object)" Object into a little endian ");
            String _nameUpper_1 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_1, " ");
            _builder.append((Object)" Object");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param the ");
            String _nameUpper_2 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_2, " ");
            _builder.append((Object)" Object to convert");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return ");
            String _nameUpper_3 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_3, " ");
            _builder.append((Object)" the converted ");
            String _nameUpper_4 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_4, " ");
            _builder.append((Object)" Object");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public ");
            String _nameUpper_5 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_5, "");
            _builder.append((Object)" convertToLittleEndian(");
            String _nameUpper_6 = GenerationUtil.toNameUpper(pdataSet);
            _builder.append((Object)_nameUpper_6, "");
            _builder.append((Object)" ");
            String _nameLower = GenerationUtil.toNameLower(pdataSet);
            _builder.append((Object)_nameLower, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"//");
            String _sensIDLTodoTag = SensIDLTodoTaskCustomizer.getSensIDLTodoTag();
            _builder.append((Object)_sensIDLTodoTag, "\t");
            _builder.append((Object)": implement Method");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return null;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        CharSequence _convertAllToTLitteEndian = this.convertAllToTLitteEndian(d);
        _builder.append((Object)_convertAllToTLitteEndian, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence convertAllToTLitteEndian(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public void ");
        _builder.append((Object)"convertAllToLittleEndian", "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
        for (MeasurementData data : _filter) {
            _builder.append((Object)"\t");
            String _nameLower = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower, "\t");
            _builder.append((Object)" = ");
            EObject _eContainer = data.eContainer();
            String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
            _builder.append((Object)_sensorInterfaceName, "\t");
            _builder.append((Object)"Utility", "\t");
            _builder.append((Object)".convertToLittleEndian(");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_1 = d.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        for (NonMeasurementData data_1 : _filter_1) {
            boolean _isConstant = data_1.isConstant();
            if (_isConstant) {
                _builder.append((Object)"\t");
                String _name = data_1.getName();
                String _upperCase = _name.toUpperCase();
                _builder.append((Object)_upperCase, "\t");
                _builder.append((Object)" = ");
                EObject _eContainer_1 = data_1.eContainer();
                String _sensorInterfaceName_1 = GenerationUtil.getSensorInterfaceName(_eContainer_1);
                _builder.append((Object)_sensorInterfaceName_1, "\t");
                _builder.append((Object)"Utility", "\t");
                _builder.append((Object)".convertToLittleEndian(");
                String _name_1 = data_1.getName();
                String _upperCase_1 = _name_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)data_1);
            _builder.append((Object)_nameLower_2, "\t");
            _builder.append((Object)" = ");
            EObject _eContainer_2 = data_1.eContainer();
            String _sensorInterfaceName_2 = GenerationUtil.getSensorInterfaceName(_eContainer_2);
            _builder.append((Object)_sensorInterfaceName_2, "\t");
            _builder.append((Object)"Utility", "\t");
            _builder.append((Object)".convertToLittleEndian(");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)data_1);
            _builder.append((Object)_nameLower_3, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        EList _usedDataSets = d.getUsedDataSets();
        for (DataSet pdataSet : _usedDataSets) {
            _builder.append((Object)"\t");
            String _nameLower_4 = GenerationUtil.toNameLower(pdataSet);
            _builder.append((Object)_nameLower_4, "\t");
            _builder.append((Object)" = convertToLittleEndian(");
            String _nameLower_5 = GenerationUtil.toNameLower(pdataSet);
            _builder.append((Object)_nameLower_5, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSetterBodyForMeasurementData(MeasurementData data, DataConversion conversion) {
        if (conversion instanceof LinearDataConversion) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
        }
        if (conversion instanceof LinearDataConversionWithInterval) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data, conversion).toString());
    }
}

