/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.c;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Method;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MethodParameter;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.c.CDTOGenerator;
import de.fzi.sensidl.language.generator.factory.c.DataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HeaderDTOGenerator
extends CDTOGenerator {
    private static Logger logger = Logger.getLogger(HeaderDTOGenerator.class);

    public HeaderDTOGenerator(List<DataSet> newDataSet) {
        super(newDataSet);
    }

    public CharSequence compile(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
        _builder.append((Object)_generateStruct, "");
        return _builder;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the data transfer object header-file.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet dataset : this.dataSets) {
            String _nameUpper = GenerationUtil.toNameUpper(dataset);
            String fileName = this.addFileExtensionTo(_nameUpper);
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
            filesToGenerate.put(fileName, _generateStruct);
            logger.info((Object)("File: " + fileName + " was generated in " + "./src-gen"));
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateStruct(String structName, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**\\brief\t\t");
        String _description = dataset.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.append((Object)"  ");
        _builder.newLineIfNotEmpty();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            if (data instanceof ListData) continue;
            CharSequence _generateDescription = this.generateDescription(data);
            _builder.append((Object)_generateDescription, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#ifndef ");
        String _upperCase = structName.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        String _upperCase_1 = structName.toUpperCase();
        _builder.append((Object)_upperCase_1, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include <stdint.h> ");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _utilityFileName = GenerationUtil.getUtilityFileName((EObject)dataset, ".h");
        _builder.append((Object)_utilityFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"typedef struct");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _generateDataFieldsIncludeUsedDataSets = this.generateDataFieldsIncludeUsedDataSets(dataset);
        _builder.append((Object)_generateDataFieldsIncludeUsedDataSets, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"} ");
        String _nameUpper = GenerationUtil.toNameUpper(dataset);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateInitDatasetPrototype = this.generateInitDatasetPrototype(dataset);
        _builder.append((Object)_generateInitDatasetPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateMethodsPrototypes = this.generateMethodsPrototypes(dataset);
        _builder.append((Object)_generateMethodsPrototypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateDataMethodsPrototypesIncludeUsedDataSets = this.generateDataMethodsPrototypesIncludeUsedDataSets(dataset);
        _builder.append((Object)_generateDataMethodsPrototypesIncludeUsedDataSets, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        CharSequence _generateEndiannessMethodsPrototypes = this.generateEndiannessMethodsPrototypes(dataset);
        _builder.append((Object)_generateEndiannessMethodsPrototypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateMarshalingJSONMethods = this.generateMarshalingJSONMethods(dataset);
        _builder.append((Object)_generateMarshalingJSONMethods, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateEndiannessMethodsPrototypes(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateAdjustAllEndiannessPrototype = this.generateAdjustAllEndiannessPrototype(d);
        _builder.append((Object)_generateAdjustAllEndiannessPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        CharSequence _generateSwapEndiannessOnDemandPrototype = this.generateSwapEndiannessOnDemandPrototype(d);
        _builder.append((Object)_generateSwapEndiannessOnDemandPrototype, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String generateDataFieldsIncludeUsedDataSets(final DataSet d) {
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        String dataFieldsString = _builder.toString();
        for (DataSet dataSet : dataSets) {
            EList _data = dataSet.getData();
            for (Data data : _data) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateVariable = this.generateVariable(data);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateVariable;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
        }
        return dataFieldsString.replaceAll("(?m)^[ \t]*\r?\n", "");
    }

    public CharSequence generateInitDatasetPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @Initialization of the ");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" dataset (to give the initial values to const fields)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void init_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"(");
        String _name_2 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateMethodsPrototypes(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Method.class);
        for (Method method : _filter) {
            boolean _not;
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Method for ");
            String _name = method.getName();
            _builder.append((Object)_name, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            String _description = method.getDescription();
            boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                String _description_1 = method.getDescription();
                _builder.append((Object)_description_1, " ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @generated");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/\t");
            _builder.newLine();
            String _methodReturnType = this.getMethodReturnType(method);
            _builder.append((Object)_methodReturnType, "");
            _builder.append((Object)" ");
            String _name_1 = method.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"(");
            String _methodParameter = this.getMethodParameter(method);
            _builder.append((Object)_methodParameter, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String getMethodReturnType(Method method) {
        boolean _notEquals_1;
        boolean _notEquals;
        DataType _returnType = method.getReturnType();
        boolean bl = _notEquals = !Objects.equal((Object)_returnType, (Object)DataType.UNDEFINED);
        if (_notEquals) {
            DataType _returnType_1 = method.getReturnType();
            return this.toTypeName(_returnType_1);
        }
        DataSet _returnTypeDataSet = method.getReturnTypeDataSet();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_returnTypeDataSet, null);
        if (_notEquals_1) {
            DataSet _returnTypeDataSet_1 = method.getReturnTypeDataSet();
            return _returnTypeDataSet_1.getName();
        }
        return "void";
    }

    public String getMethodParameter(Method method) {
        boolean _greaterThan;
        String str = "";
        EList _parameter = method.getParameter();
        int _size = _parameter.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _notEquals;
            EList _parameter_1 = method.getParameter();
            MethodParameter _head = (MethodParameter)IterableExtensions.head((Iterable)_parameter_1);
            DataType _dataType = _head.getDataType();
            boolean bl2 = _notEquals = !Objects.equal((Object)_dataType, (Object)DataType.UNDEFINED);
            if (_notEquals) {
                String _plus_1;
                EList _parameter_2 = method.getParameter();
                MethodParameter _head_1 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_2);
                DataType _dataType_1 = _head_1.getDataType();
                String _typeName = this.toTypeName(_dataType_1);
                String _plus = String.valueOf(_typeName) + " ";
                EList _parameter_3 = method.getParameter();
                MethodParameter _head_2 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_3);
                String _name = _head_2.getName();
                str = _plus_1 = String.valueOf(_plus) + _name;
            } else {
                boolean _notEquals_1;
                EList _parameter_4 = method.getParameter();
                MethodParameter _head_3 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_4);
                DataSet _dataTypeDataSet = _head_3.getDataTypeDataSet();
                boolean bl3 = _notEquals_1 = !Objects.equal((Object)_dataTypeDataSet, null);
                if (_notEquals_1) {
                    String _plus_3;
                    EList _parameter_5 = method.getParameter();
                    MethodParameter _head_4 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_5);
                    DataSet _dataTypeDataSet_1 = _head_4.getDataTypeDataSet();
                    String _name_1 = _dataTypeDataSet_1.getName();
                    String _plus_2 = String.valueOf(_name_1) + " ";
                    EList _parameter_6 = method.getParameter();
                    MethodParameter _head_5 = (MethodParameter)IterableExtensions.head((Iterable)_parameter_6);
                    String _name_2 = _head_5.getName();
                    str = _plus_3 = String.valueOf(_plus_2) + _name_2;
                }
            }
            EList _parameter_7 = method.getParameter();
            Iterable _tail = IterableExtensions.tail((Iterable)_parameter_7);
            for (MethodParameter p : _tail) {
                boolean _notEquals_3;
                boolean _notEquals_2;
                DataType _dataType_2 = p.getDataType();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_dataType_2, (Object)DataType.UNDEFINED);
                if (_notEquals_2) {
                    String _str = str;
                    DataType _dataType_3 = p.getDataType();
                    String _typeName_1 = this.toTypeName(_dataType_3);
                    String _plus_4 = ", " + _typeName_1;
                    String _plus_5 = String.valueOf(_plus_4) + " ";
                    String _name_3 = p.getName();
                    String _plus_6 = String.valueOf(_plus_5) + _name_3;
                    str = String.valueOf(_str) + _plus_6;
                    continue;
                }
                DataSet _dataTypeDataSet_2 = p.getDataTypeDataSet();
                boolean bl5 = _notEquals_3 = !Objects.equal((Object)_dataTypeDataSet_2, null);
                if (!_notEquals_3) continue;
                String _str_1 = str;
                DataSet _dataTypeDataSet_3 = p.getDataTypeDataSet();
                String _name_4 = _dataTypeDataSet_3.getName();
                String _plus_7 = ", " + _name_4;
                String _plus_8 = String.valueOf(_plus_7) + " ";
                String _name_5 = p.getName();
                String _plus_9 = String.valueOf(_plus_8) + _name_5;
                str = String.valueOf(_str_1) + _plus_9;
            }
        }
        return str;
    }

    public String generateDataMethodsPrototypesIncludeUsedDataSets(final DataSet d) {
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<DataSet>> _function = new Procedures.Procedure1<ArrayList<DataSet>>(){

            public void apply(ArrayList<DataSet> it) {
                it.add(d);
                EList _usedDataSets = d.getUsedDataSets();
                it.addAll((Collection<DataSet>)_usedDataSets);
            }
        };
        ArrayList dataSets = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        DataSet usedDataSets = d;
        for (DataSet dataSet : dataSets) {
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
            for (NonMeasurementData data : _filter) {
                EList _excludedMethods_1;
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                EList _excludedMethods = data.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl = _not = !_contains;
                if (_not) {
                    String _methodsString = methodsString;
                    CharSequence _generateGetterPrototype = this.generateGetterPrototype((Data)data, usedDataSets);
                    String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterPrototype;
                    String _property = System.getProperty("line.separator");
                    methodsString = String.valueOf(_methodsString_1) + _property;
                }
                boolean bl2 = _not_1 = !(_contains_1 = (_excludedMethods_1 = data.getExcludedMethods()).contains((Object)"setter"));
                if (!_not_1) continue;
                String _methodsString_2 = methodsString;
                CharSequence _generateSetterPrototype = this.generateSetterPrototype((Data)data, usedDataSets);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterPrototype;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
            for (MeasurementData data_1 : _filter_1) {
                EList _excludedMethods_1;
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                EList _excludedMethods = data_1.getExcludedMethods();
                boolean _contains = _excludedMethods.contains((Object)"getter");
                boolean bl = _not = !_contains;
                if (_not) {
                    String _methodsString = methodsString;
                    CharSequence _generateGetterPrototype = this.generateGetterPrototype((Data)data_1, usedDataSets);
                    String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterPrototype;
                    String _property = System.getProperty("line.separator");
                    methodsString = String.valueOf(_methodsString_1) + _property;
                }
                boolean bl3 = _not_1 = !(_contains_1 = (_excludedMethods_1 = data_1.getExcludedMethods()).contains((Object)"setter"));
                if (!_not_1) continue;
                String _methodsString_2 = methodsString;
                CharSequence _generateSetterPrototype = this.generateSetterPrototype((Data)data_1, usedDataSets);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterPrototype;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
        }
        return methodsString;
    }

    protected CharSequence _generateGetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String dataType = this.getReturnDataType(d);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isAdjustedByLinearConversionWithInterval = this.isAdjustedByLinearConversionWithInterval(d);
        if (_isAdjustedByLinearConversionWithInterval) {
            CharSequence _generatedAdjustedGetterPrototypes = this.generatedAdjustedGetterPrototypes(d, dataset);
            _builder.append((Object)_generatedAdjustedGetterPrototypes, "");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"* @return the ");
            String _name = d.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _builder.append((Object)_firstUpper, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)dataType, "");
            _builder.append((Object)" get_");
            String _name_1 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"_");
            String _name_2 = d.getName();
            String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_3 = dataset.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper_2, "");
            _builder.append((Object)"* p);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generatedAdjustedGetterPrototypes(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the adjusted ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _returnDataType = this.getReturnDataType(d);
        _builder.append((Object)_returnDataType, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the not adjusted ");
        String _name_4 = d.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_5 = dataset.getName();
        String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_5);
        _builder.append((Object)_firstUpper_4, "");
        _builder.append((Object)"_");
        String _name_6 = d.getName();
        String _replaceAll_1 = _name_6.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll_1, "");
        _builder.append((Object)"NotAdjusted(");
        String _name_7 = dataset.getName();
        String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_7);
        _builder.append((Object)_firstUpper_5, "");
        _builder.append((Object)"* p); \t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public String getReturnDataType(MeasurementData d) {
        String _xblockexpression = null;
        boolean _isAdjustedByLinearConversionWithInterval = this.isAdjustedByLinearConversionWithInterval(d);
        if (_isAdjustedByLinearConversionWithInterval) {
            DataType _dataTypeOfDataConversionAdjustment = GenerationUtil.getDataTypeOfDataConversionAdjustment(d);
            return DataTypes.getDataTypeBy(_dataTypeOfDataConversionAdjustment);
        }
        _xblockexpression = this.toTypeName((Data)d);
        return _xblockexpression;
    }

    public boolean isAdjustedByLinearConversionWithInterval(MeasurementData data) {
        boolean _greaterThan;
        boolean _and = false;
        EList _adjustments = data.getAdjustments();
        int _size = _adjustments.size();
        boolean bl = _greaterThan = _size > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            EList _adjustments_1 = data.getAdjustments();
            DataAdjustment _get = (DataAdjustment)_adjustments_1.get(0);
            _and = _get instanceof LinearDataConversionWithInterval;
        }
        return _and;
    }

    protected CharSequence _generateSetterPrototype(MeasurementData d, DataSet dataset) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (!(dataAdj instanceof DataConversion) || !(dataAdj instanceof LinearDataConversion)) continue;
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param pointer to dataset, adjust");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*\t\t\tthe adjust to set");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"void set_");
                String _name = dataset.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name);
                _builder.append((Object)_firstUpper, "");
                _builder.append((Object)"_");
                String _name_1 = d.getName();
                String _replaceAll = _name_1.replaceAll("[^a-zA-Z0-9]", "");
                _builder.append((Object)_replaceAll, "");
                _builder.append((Object)"_WithDataConversion(");
                String _name_2 = dataset.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                _builder.append((Object)_firstUpper_1, "");
                _builder.append((Object)"* p, ");
                String _typeName = this.toTypeName((Data)d);
                _builder.append((Object)_typeName, "");
                _builder.append((Object)" ");
                String _name_3 = d.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name_3);
                _builder.append((Object)_firstLower, "");
                _builder.append((Object)" );\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param pointer to dataset, ");
        String _name_4 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_4);
        _builder.append((Object)_firstLower_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t\t\tthe ");
        String _name_5 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, " ");
        _builder.append((Object)" to set");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void set_");
        String _name_6 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_6);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"_");
        String _name_7 = d.getName();
        String _replaceAll_1 = _name_7.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll_1, "");
        _builder.append((Object)"(");
        String _name_8 = dataset.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_8);
        _builder.append((Object)_firstUpper_3, "");
        _builder.append((Object)"* p, ");
        String _typeName_1 = this.toTypeName((Data)d);
        _builder.append((Object)_typeName_1, "");
        _builder.append((Object)" ");
        String _name_9 = d.getName();
        String _firstLower_3 = StringExtensions.toFirstLower((String)_name_9);
        _builder.append((Object)_firstLower_3, "");
        _builder.append((Object)" );");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateGetterPrototype(NonMeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterPrototype(NonMeasurementData d, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = d.isConstant();
        boolean bl = _not = !_isConstant;
        if (_not) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param pointer to dataset, ");
            String _name = d.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name);
            _builder.append((Object)_firstLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _name_1 = d.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_1);
            _builder.append((Object)_firstLower_1, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"void set_");
            String _name_2 = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"_");
            String _name_3 = d.getName();
            String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_4 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"* p, ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name_5 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_2, "");
            _builder.append((Object)" );");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateDescription(MeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*\t\t\t\tMeasured in unit: ");
        Unit _unit = data.getUnit();
        _builder.append((Object)_unit, "");
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateDescription(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateVariable(MeasurementData data) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";  // Unit: ");
        Unit _unit = data.getUnit();
        _builder.append((Object)_unit, "");
        _builder.append((Object)", ");
        String _description = data.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        boolean _isAdjustedByLinearConversionWithInterval = this.isAdjustedByLinearConversionWithInterval(data);
        if (_isAdjustedByLinearConversionWithInterval) {
            boolean _notEquals_1;
            String _returnDataType = this.getReturnDataType(data);
            _builder.append((Object)_returnDataType, "");
            _builder.append((Object)" ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_1, "");
            _builder.append((Object)"Adjusted;  // Unit: ");
            Unit _unit_1 = data.getUnit();
            _builder.append((Object)_unit_1, "");
            _builder.append((Object)", ");
            String _description_2 = data.getDescription();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                String _description_3 = data.getDescription();
                _builder.append((Object)_description_3, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateVariable(NonMeasurementData data) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";  ");
        String _description = data.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)"// ");
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        return _builder;
    }

    protected CharSequence _generateVariable(ListData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _listType = this.getListType(data);
        _builder.append((Object)_listType, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)"[10]; // static list of length 10 (does a dynamic list fit the requierements?)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String getListType(ListData data) {
        boolean _notEquals_1;
        boolean _notEquals;
        DataType _dataType = data.getDataType();
        boolean bl = _notEquals = !Objects.equal((Object)_dataType, (Object)DataType.UNDEFINED);
        if (_notEquals) {
            DataType _dataType_1 = data.getDataType();
            return this.toTypeName(_dataType_1);
        }
        DataSet _dataTypeDataSet = data.getDataTypeDataSet();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dataTypeDataSet, null);
        if (_notEquals_1) {
            DataSet _dataTypeDataSet_1 = data.getDataTypeDataSet();
            return _dataTypeDataSet_1.getName();
        }
        return null;
    }

    public CharSequence generateAdjustAllEndiannessPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* Adjusts all data atributes of a struct to given endianness depending on the machine architecture");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void adjust_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_allEndianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSwapEndiannessOnDemandPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* Swaps Endianness between little endian and big endian");
        _builder.newLine();
        _builder.append((Object)"*/\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"void swap_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_all_endianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMarshalingJSONMethods(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateMarshalJSON = this.generateMarshalJSON(dataset);
        _builder.append((Object)_generateMarshalJSON, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateUnmarshalJSON = this.generateUnmarshalJSON(dataset);
        _builder.append((Object)_generateUnmarshalJSON, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateMarshalJSON(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the JSON String of ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"char * marshalJSON_");
        String _name_1 = d.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"(");
        String _name_2 = d.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateUnmarshalJSON(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* fill the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" struct based on its JSON String");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void unmarshalJSON_");
        String _name_1 = d.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"(");
        String _name_2 = d.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p, const char *json);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String className) {
        return String.valueOf(className) + ".h";
    }

    public CharSequence generateGetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateGetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateGetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateSetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateSetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateSetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateDescription(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateDescription((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateDescription((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    public CharSequence generateVariable(Data data) {
        if (data instanceof ListData) {
            return this._generateVariable((ListData)data);
        }
        if (data instanceof MeasurementData) {
            return this._generateVariable((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateVariable((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }
}

