/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.converters.BooleanValidator;
import de.fzi.sensidl.language.converters.ConvertionValidator;
import de.fzi.sensidl.language.converters.NumericalValidator;
import de.fzi.sensidl.language.converters.StringValidator;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class StringConverter
implements IValueConverter<String> {
    private static final String ERROR_MESSAGE = "Data type not supported";
    private static final String EMPTY_STRING = "";
    private static final String HEX_INDICATOR = "0x";
    private static final String QUOTATION_MARK = "\"";
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int MAX_8_BIT_VALUE = 255;
    private static final int MAX_16_BIT_VALUE = 65535;

    public String toValue(String string, INode node) throws ValueConverterException {
        int base = 10;
        if (!this.needToBeConverted(node)) {
            return string;
        }
        String stringToConvert = this.removeQuotationMarksFrom(string);
        ConvertionValidator validatorPipeline = this.initValidationPipeline(node);
        stringToConvert = validatorPipeline.validate(stringToConvert);
        if (NumericalValidator.isHex(stringToConvert).booleanValue()) {
            base = 16;
            stringToConvert = this.parseToStringRepresentation(stringToConvert);
        }
        return this.getCorrespondingValue(node, stringToConvert, base);
    }

    private ConvertionValidator initValidationPipeline(INode newNode) {
        ConvertionValidator.setUpValidator(newNode);
        return new StringValidator(new BooleanValidator(new NumericalValidator(null)));
    }

    private String getCorrespondingValue(INode node, String stringToConvert, int base) {
        Object value;
        NonMeasurementData data = (NonMeasurementData)node.getSemanticElement();
        switch (data.getDataType().getValue()) {
            case 0: {
                value = Byte.parseByte(stringToConvert, base);
                break;
            }
            case 1: {
                value = Integer.parseUnsignedInt(stringToConvert, base) & 0xFF;
                break;
            }
            case 2: {
                value = Short.parseShort(stringToConvert, base);
                break;
            }
            case 3: {
                value = Integer.parseUnsignedInt(stringToConvert, base) & 0xFFFF;
                break;
            }
            case 4: {
                value = Integer.parseInt(stringToConvert, base);
                break;
            }
            case 5: {
                value = Integer.parseUnsignedInt(stringToConvert, base);
                break;
            }
            case 6: {
                value = Long.parseLong(stringToConvert, base);
                break;
            }
            case 7: {
                value = Long.parseUnsignedLong(stringToConvert, base);
                break;
            }
            case 8: {
                value = Integer.parseInt(stringToConvert, base);
                break;
            }
            case 9: {
                value = Long.parseLong(stringToConvert, base);
                break;
            }
            case 10: {
                value = stringToConvert;
                break;
            }
            default: {
                throw new ValueConverterException(ERROR_MESSAGE, node, null);
            }
        }
        return value.toString();
    }

    private String parseToStringRepresentation(String string) {
        return string.replaceAll(HEX_INDICATOR, EMPTY_STRING);
    }

    private String removeQuotationMarksFrom(String stringWithQuotationMarks) {
        return stringWithQuotationMarks.replaceAll(QUOTATION_MARK, EMPTY_STRING);
    }

    private boolean needToBeConverted(INode node) {
        boolean needToBeConverted = false;
        if (node.getSemanticElement() instanceof NonMeasurementData) {
            needToBeConverted = ((NonMeasurementData)node.getSemanticElement()).getDataType().getValue() != 11;
        }
        return needToBeConverted;
    }

    public String toString(String value) throws ValueConverterException {
        return value;
    }
}

