package de.fzi.sensidl.language.generator.job;

import de.fzi.sensidl.language.generator.GenerationParameter;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.elementfilter.DataSetFilter;
import de.fzi.sensidl.language.generator.elementfilter.ElementFilter;
import de.fzi.sensidl.language.generator.elementfilter.SensorInterfaceFilter;
import de.fzi.sensidl.language.generator.elementfilter.UtilityDataFilter;
import de.fzi.sensidl.language.generator.generationstep.DTOGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.FileGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import de.fzi.sensidl.language.generator.generationstep.ProjectGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.UtilityGenerationStep;
import de.fzi.sensidl.language.generator.job.GenerationJob;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GenerationJobFactory {
  public static GenerationJob getGenerationJobBy(final GenerationParameter parameter) {
    GenerationJob _switchResult = null;
    SensIDLConstants.GenerationLanguage _generationLanguage = parameter.getGenerationLanguage();
    if (_generationLanguage != null) {
      switch (_generationLanguage) {
        case JAVA_PLUGIN_PROJECT:
          return GenerationJobFactory.getJavaPlugInGenerationJobBy(parameter);
        case OPCUA:
          return GenerationJobFactory.getOpcUaGenerationJobBy(parameter);
        default:
          _switchResult = GenerationJobFactory.getDTOGenerationJobBy(parameter);
          break;
      }
    } else {
      _switchResult = GenerationJobFactory.getDTOGenerationJobBy(parameter);
    }
    return _switchResult;
  }
  
  public static GenerationJob getOpcUaGenerationJobBy(final GenerationParameter parameter) {
    GenerationJob _xblockexpression = null;
    {
      GenerationJobFactory.makeGlobalSettings(parameter);
      LinkedHashSet<GenerationStep> _linkedHashSet = new LinkedHashSet<GenerationStep>();
      final Procedure1<LinkedHashSet<GenerationStep>> _function = new Procedure1<LinkedHashSet<GenerationStep>>() {
        public void apply(final LinkedHashSet<GenerationStep> it) {
          SensorInterfaceFilter _sensorInterfaceFilter = new SensorInterfaceFilter();
          IFileSystemAccess _fileSystemAccess = parameter.getFileSystemAccess();
          ProjectGenerationStep _projectGenerationStep = new ProjectGenerationStep(_sensorInterfaceFilter, _fileSystemAccess);
          it.add(_projectGenerationStep);
          DataSetFilter _dataSetFilter = new DataSetFilter();
          DTOGenerationStep _dTOGenerationStep = new DTOGenerationStep(_dataSetFilter);
          it.add(_dTOGenerationStep);
          IFileSystemAccess _fileSystemAccess_1 = parameter.getFileSystemAccess();
          FileGenerationStep _fileGenerationStep = new FileGenerationStep(_fileSystemAccess_1);
          it.add(_fileGenerationStep);
        }
      };
      final LinkedHashSet<GenerationStep> generationChain = ObjectExtensions.<LinkedHashSet<GenerationStep>>operator_doubleArrow(_linkedHashSet, _function);
      _xblockexpression = new GenerationJob(generationChain);
    }
    return _xblockexpression;
  }
  
  private static GenerationJob getJavaPlugInGenerationJobBy(final GenerationParameter parameter) {
    GenerationJob _xblockexpression = null;
    {
      GenerationJobFactory.makeGlobalSettings(parameter);
      LinkedHashSet<GenerationStep> _linkedHashSet = new LinkedHashSet<GenerationStep>();
      final Procedure1<LinkedHashSet<GenerationStep>> _function = new Procedure1<LinkedHashSet<GenerationStep>>() {
        public void apply(final LinkedHashSet<GenerationStep> it) {
          SensorInterfaceFilter _sensorInterfaceFilter = new SensorInterfaceFilter();
          IFileSystemAccess _fileSystemAccess = parameter.getFileSystemAccess();
          ProjectGenerationStep _projectGenerationStep = new ProjectGenerationStep(_sensorInterfaceFilter, _fileSystemAccess);
          it.add(_projectGenerationStep);
          DataSetFilter _dataSetFilter = new DataSetFilter();
          DTOGenerationStep _dTOGenerationStep = new DTOGenerationStep(_dataSetFilter);
          it.add(_dTOGenerationStep);
          UtilityDataFilter _utilityDataFilter = new UtilityDataFilter();
          UtilityGenerationStep _utilityGenerationStep = new UtilityGenerationStep(_utilityDataFilter);
          it.add(_utilityGenerationStep);
          IFileSystemAccess _fileSystemAccess_1 = parameter.getFileSystemAccess();
          FileGenerationStep _fileGenerationStep = new FileGenerationStep(_fileSystemAccess_1);
          it.add(_fileGenerationStep);
        }
      };
      final LinkedHashSet<GenerationStep> generationChain = ObjectExtensions.<LinkedHashSet<GenerationStep>>operator_doubleArrow(_linkedHashSet, _function);
      _xblockexpression = new GenerationJob(generationChain);
    }
    return _xblockexpression;
  }
  
  private static GenerationJob getDTOGenerationJobBy(final GenerationParameter parameter) {
    GenerationJob _xblockexpression = null;
    {
      GenerationJobFactory.makeGlobalSettings(parameter);
      LinkedHashSet<GenerationStep> _linkedHashSet = new LinkedHashSet<GenerationStep>();
      final Procedure1<LinkedHashSet<GenerationStep>> _function = new Procedure1<LinkedHashSet<GenerationStep>>() {
        public void apply(final LinkedHashSet<GenerationStep> it) {
          DataSetFilter _dataSetFilter = new DataSetFilter();
          DTOGenerationStep _dTOGenerationStep = new DTOGenerationStep(_dataSetFilter);
          it.add(_dTOGenerationStep);
          UtilityDataFilter _utilityDataFilter = new UtilityDataFilter();
          UtilityGenerationStep _utilityGenerationStep = new UtilityGenerationStep(_utilityDataFilter);
          it.add(_utilityGenerationStep);
          IFileSystemAccess _fileSystemAccess = parameter.getFileSystemAccess();
          FileGenerationStep _fileGenerationStep = new FileGenerationStep(_fileSystemAccess);
          it.add(_fileGenerationStep);
        }
      };
      final LinkedHashSet<GenerationStep> generationChain = ObjectExtensions.<LinkedHashSet<GenerationStep>>operator_doubleArrow(_linkedHashSet, _function);
      _xblockexpression = new GenerationJob(generationChain);
    }
    return _xblockexpression;
  }
  
  private static void makeGlobalSettings(final GenerationParameter parameter) {
    SensIDLConstants.GenerationLanguage _generationLanguage = parameter.getGenerationLanguage();
    GenerationStep.setGlobalSettings(_generationLanguage);
    Resource _resource = parameter.getResource();
    ElementFilter.init(_resource);
  }
}
