package de.fzi.sensidl.language.generator.factory.sidl;

import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.language.generator.factory.ICodeGenerator;
import de.fzi.sensidl.language.generator.factory.sidl.SidlDTOGenerator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/**
 * The SidlGenerator represents a concrete implementation of The ICodeGenerator and implements the
 * code-generator for the sidl file.
 * @author Sven Eckhardt
 */
@SuppressWarnings("all")
public class SidlGenerator implements ICodeGenerator {
  /**
   * @see ICodeGenerator#generateDTO()
   */
  public HashMap<String, CharSequence> generateDTO(final List<DataSet> dataSet) {
    SidlDTOGenerator _sidlDTOGenerator = new SidlDTOGenerator(dataSet);
    return _sidlDTOGenerator.generate();
  }
  
  /**
   * @see ICodeGenerator#generateUtilityClass()
   */
  public HashMap<String, CharSequence> generateUtilityClass(final List<EObject> data) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  /**
   * @see ICodeGenerator#generateOpcUa(List<MeasurementData>)
   */
  public HashMap<String, CharSequence> generateOpcUa(final List<DataSet> dataSet) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
}
