/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.plaintext;

import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.IdentifiableElement;
import de.fzi.sensidl.design.sensidl.NamedElement;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PlaintextDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(PlaintextDTOGenerator.class);
    private static final String TEXT_EXTENSION = ".txt";
    private List<DataSet> dataSet;

    public PlaintextDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        logger.info((Object)"Start with text generation.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        SensorInterface sensorInterface = GenerationUtil.getSensorInterface(this.dataSet.get(0).eContainer());
        filesToGenerate.put(this.addFileExtensionTo(StringExtensions.toFirstUpper((String)sensorInterface.getName())), this.generateDocumentation(sensorInterface));
        logger.info((Object)("File: " + this.addFileExtensionTo(StringExtensions.toFirstUpper((String)sensorInterface.getName())) + " was generated in " + "./src-gen"));
        return filesToGenerate;
    }

    public CharSequence generateDocumentation(SensorInterface sensorInterface) {
        StringConcatenation _builder = new StringConcatenation();
        TreeIterator _eAllContents = sensorInterface.eAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, DataSet.class);
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>();
        String dataSetsString = "";
        Calendar cal = Calendar.getInstance();
        for (DataSet dataSet : _filter) {
            dataSetList.add(dataSet);
        }
        _builder.append((Object)"----------------------------------------");
        _builder.newLine();
        _builder.append((Object)("name: " + sensorInterface.getName()));
        _builder.newLine();
        _builder.append((Object)("time: " + cal.getTime()));
        _builder.newLine();
        _builder.append((Object)"----------------------------------------");
        _builder.newLine();
        _builder.append((Object)("This is the documentation for the sensor interface \"" + sensorInterface.getName()));
        this.addID((IdentifiableElement)sensorInterface, _builder);
        _builder.append((Object)"\".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"The encoding");
        this.addID((IdentifiableElement)sensorInterface.getEncodingSettings(), _builder);
        _builder.append((Object)(" is " + sensorInterface.getEncodingSettings().getCoding().getName().toLowerCase().replace("_", " ") + " and "));
        _builder.append((Object)("the endianness is " + sensorInterface.getEncodingSettings().getEndianness().getName().toLowerCase().replace("_", " ") + ". "));
        _builder.append((Object)("It is aligned by " + sensorInterface.getEncodingSettings().getAlignment() + (sensorInterface.getEncodingSettings().getAlignment() > 1 ? " bits" : " bit") + "."));
        _builder.newLineIfNotEmpty();
        this.addDescription((NamedElement)sensorInterface, _builder);
        _builder.append((Object)"The sensor data");
        this.addID((IdentifiableElement)sensorInterface.getDataDescription(), _builder);
        _builder.append((Object)(" of \"" + sensorInterface.getName() + "\" consists of " + dataSetList.size() + " data sets: "));
        int i = 0;
        while (i < dataSetList.size()) {
            dataSetsString = String.valueOf(dataSetsString) + "\"" + ((DataSet)dataSetList.get(i)).getName() + "\"";
            if (i < dataSetList.size() - 2) {
                dataSetsString = String.valueOf(dataSetsString) + ", ";
            } else if (i == dataSetList.size() - 2) {
                dataSetsString = String.valueOf(dataSetsString) + " and ";
            }
            ++i;
        }
        _builder.append((Object)(String.valueOf(dataSetsString) + "."));
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"====================================================================================================");
        _builder.newLine();
        _builder.newLine();
        for (DataSet dataSet : dataSetList) {
            _builder.append((Object)("The data set \"" + dataSet.getName() + "\""));
            this.addID((IdentifiableElement)dataSet, _builder);
            _builder.append((Object)(" contains " + dataSet.getData().size() + (dataSet.getData().size() > 1 ? " datas: " : (dataSet.getData().size() == 0 ? " data. " : " data: "))));
            String dataString = "";
            int i2 = 0;
            while (i2 < dataSet.getData().size()) {
                dataString = String.valueOf(dataString) + "\"" + ((Data)dataSet.getData().get(i2)).getName() + "\"";
                if (i2 < dataSet.getData().size() - 2) {
                    dataString = String.valueOf(dataString) + ", ";
                } else if (i2 == dataSet.getData().size() - 2) {
                    dataString = String.valueOf(dataString) + " and ";
                }
                ++i2;
            }
            _builder.append((Object)(String.valueOf(dataString) + "."));
            _builder.newLine();
            if (dataSet.getParentDataSet() != null) {
                _builder.append((Object)("This data set uses the data set \"" + dataSet.getParentDataSet().getName() + "\"."));
                _builder.newLine();
            }
            this.addDescription((NamedElement)dataSet, _builder);
            for (Data data : dataSet.getData()) {
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                if (data instanceof MeasurementData) {
                    _builder.append((Object)("The measurement data \"" + data.getName() + "\""));
                    this.addID((IdentifiableElement)data, _builder);
                } else if (data instanceof NonMeasurementData) {
                    _builder.append((Object)("The non measurement data \"" + data.getName() + "\""));
                    this.addID((IdentifiableElement)data, _builder);
                    if (((NonMeasurementData)data).isConstant()) {
                        _builder.append((Object)" is constant and");
                    }
                    if (((NonMeasurementData)data).getValue() != null) {
                        _builder.append((Object)(" has the value: \"" + ((NonMeasurementData)data).getValue() + "\"."));
                        _builder.newLine();
                        _builder.append((Object)"It");
                    }
                }
                _builder.append((Object)(" has the data type " + data.getDataType().getName() + "."));
                _builder.newLineIfNotEmpty();
                if (data instanceof MeasurementData) {
                    if (!((MeasurementData)data).getUnit().toString().isEmpty()) {
                        _builder.append((Object)("It has the unit " + ((MeasurementData)data).getUnit()));
                    } else {
                        _builder.append((Object)"It is dimensionless");
                    }
                    for (DataAdjustment dataAdjustment : ((MeasurementData)data).getAdjustments()) {
                        if (((MeasurementData)data).getAdjustments().indexOf((Object)dataAdjustment) == 0) {
                            _builder.append((Object)" and it is adjusted ");
                        } else {
                            _builder.append((Object)"Additionally it is adjusted ");
                        }
                        if (dataAdjustment instanceof DataRange) {
                            if (((DataRange)dataAdjustment).getRange() != null) {
                                _builder.append((Object)"with data range");
                                this.addID((IdentifiableElement)dataAdjustment, _builder);
                                _builder.append((Object)" from ");
                                _builder.append((Object)(String.valueOf(((DataRange)dataAdjustment).getRange().getLowerBound()) + " to " + ((DataRange)dataAdjustment).getRange().getUpperBound()));
                            }
                        } else if (dataAdjustment instanceof DataConversion) {
                            _builder.append((Object)"by linear data conversion");
                            this.addID((IdentifiableElement)dataAdjustment, _builder);
                            if (dataAdjustment instanceof LinearDataConversion) {
                                if (((LinearDataConversion)dataAdjustment).getOffset() != 0.0) {
                                    _builder.append((Object)(" with offset: " + ((LinearDataConversion)dataAdjustment).getOffset()));
                                    if (((LinearDataConversion)dataAdjustment).getScalingFactor() != 0.0) {
                                        _builder.append((Object)" and");
                                    }
                                }
                                if (((LinearDataConversion)dataAdjustment).getScalingFactor() != 0.0) {
                                    _builder.append((Object)(" with scaling factor: " + ((LinearDataConversion)dataAdjustment).getScalingFactor()));
                                }
                            } else if (dataAdjustment instanceof LinearDataConversionWithInterval) {
                                _builder.append((Object)(" with interval from [" + ((LinearDataConversionWithInterval)dataAdjustment).getFromInterval().getLowerBound() + " , " + ((LinearDataConversionWithInterval)dataAdjustment).getFromInterval().getUpperBound() + "] to [" + ((LinearDataConversionWithInterval)dataAdjustment).getToInterval().getLowerBound() + " , " + ((LinearDataConversionWithInterval)dataAdjustment).getToInterval().getUpperBound() + "]"));
                            }
                        }
                        _builder.append((Object)".");
                        _builder.newLine();
                    }
                    if (((MeasurementData)data).getAdjustments().isEmpty()) {
                        _builder.append((Object)".");
                        _builder.newLine();
                    }
                } else {
                    boolean cfr_ignored_0 = data instanceof NonMeasurementData;
                }
                this.addDescription((NamedElement)data, _builder);
            }
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"----------------------------------------------------------------------------------------------------");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + TEXT_EXTENSION;
    }

    @Override
    public String toTypeName(Data data) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    private void addID(IdentifiableElement element, StringConcatenation _builder) {
        if (element.getID() != null) {
            _builder.append((Object)(" (ID: " + element.getID() + ")"));
        }
    }

    private void addDescription(NamedElement element, StringConcatenation _builder) {
        if (element.getDescription() != null) {
            _builder.append((Object)("The user added this description: \"" + element.getDescription() + "\"."));
            _builder.newLineIfNotEmpty();
        }
    }
}

