/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.c;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.c.CDTOGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HeaderDTOGenerator
extends CDTOGenerator {
    private static Logger logger = Logger.getLogger(HeaderDTOGenerator.class);

    public HeaderDTOGenerator(List<DataSet> newDataSet) {
        super(newDataSet);
    }

    public CharSequence compile(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
        _builder.append((Object)_generateStruct, "");
        return _builder;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the data transfer object header-file.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet dataset : this.dataSets) {
            String _nameUpper = GenerationUtil.toNameUpper(dataset);
            String fileName = this.addFileExtensionTo(_nameUpper);
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
            filesToGenerate.put(fileName, _generateStruct);
            logger.info((Object)("File: " + fileName + " was generated in " + "./src-gen"));
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateStruct(String structName, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**\\brief\t\t");
        String _description = dataset.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.append((Object)"  ");
        _builder.newLineIfNotEmpty();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            CharSequence _generateDescription = this.generateDescription(data);
            _builder.append((Object)_generateDescription, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#ifndef ");
        String _upperCase = structName.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        String _upperCase_1 = structName.toUpperCase();
        _builder.append((Object)_upperCase_1, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include <stdint.h> ");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _utilityFileName = GenerationUtil.getUtilityFileName((EObject)dataset, ".h");
        _builder.append((Object)_utilityFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"typedef struct");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _generateVariablesIncludeParentDataSet = this.generateVariablesIncludeParentDataSet(dataset);
        _builder.append((Object)_generateVariablesIncludeParentDataSet, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"} ");
        String _nameUpper = GenerationUtil.toNameUpper(dataset);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"extern ");
        String _nameUpper_1 = GenerationUtil.toNameUpper(dataset);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower(dataset);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateInitDatasetPrototype = this.generateInitDatasetPrototype(dataset);
        _builder.append((Object)_generateInitDatasetPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateDataMethodsPrototypesIncludeParentDataSet = this.generateDataMethodsPrototypesIncludeParentDataSet(dataset);
        _builder.append((Object)_generateDataMethodsPrototypesIncludeParentDataSet, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        CharSequence _generateEndiannessMethodsPrototypes = this.generateEndiannessMethodsPrototypes(dataset);
        _builder.append((Object)_generateEndiannessMethodsPrototypes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateEndiannessMethodsPrototypes(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateAdjustAllEndiannessPrototype = this.generateAdjustAllEndiannessPrototype(d);
        _builder.append((Object)_generateAdjustAllEndiannessPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateCheckLittleEndianPrototype = this.generateCheckLittleEndianPrototype();
        _builder.append((Object)_generateCheckLittleEndianPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateSwapEndiannessOnDemandPrototype = this.generateSwapEndiannessOnDemandPrototype(d);
        _builder.append((Object)_generateSwapEndiannessOnDemandPrototype, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String generateVariablesIncludeParentDataSet(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String dataFieldsString = _builder.toString();
        while (dataSet != null) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
            for (NonMeasurementData data : _filter) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateVariable = this.generateVariable((Data)data);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateVariable;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
            for (MeasurementData data_1 : _filter_1) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateVariable = this.generateVariable((Data)data_1);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateVariable;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        return dataFieldsString.replaceAll("(?m)^[ \t]*\r?\n", "");
    }

    public CharSequence generateInitDatasetPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @Initialization of the ");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" dataset");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void init");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"(");
        String _name_2 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String generateDataMethodsPrototypesIncludeParentDataSet(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        DataSet parentDataSet = dataSet;
        while (dataSet != null) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
            for (NonMeasurementData data : _filter) {
                String _methodsString = methodsString;
                CharSequence _generateGetterPrototype = this.generateGetterPrototype((Data)data, parentDataSet);
                String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterPrototype;
                String _property = System.getProperty("line.separator");
                String _methodsString_2 = methodsString = String.valueOf(_methodsString_1) + _property;
                CharSequence _generateSetterPrototype = this.generateSetterPrototype((Data)data, parentDataSet);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterPrototype;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
            for (MeasurementData data_1 : _filter_1) {
                String _methodsString = methodsString;
                CharSequence _generateGetterPrototype = this.generateGetterPrototype((Data)data_1, parentDataSet);
                String _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetterPrototype;
                String _property = System.getProperty("line.separator");
                String _methodsString_2 = methodsString = String.valueOf(_methodsString_1) + _property;
                CharSequence _generateSetterPrototype = this.generateSetterPrototype((Data)data_1, parentDataSet);
                String _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetterPrototype;
                String _property_1 = System.getProperty("line.separator");
                methodsString = String.valueOf(_methodsString_3) + _property_1;
            }
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        return methodsString;
    }

    protected CharSequence _generateGetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isAdjustedByLineareConversionWithInterval = this.isAdjustedByLineareConversionWithInterval(d);
        if (_isAdjustedByLineareConversionWithInterval) {
            CharSequence _generatedAdjustedGetterPrototype = this.generatedAdjustedGetterPrototype(d, dataset);
            _builder.append((Object)_generatedAdjustedGetterPrototype, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatedAdjustedGetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the adjusted ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _dataTypeOfDataConversionAdjustment = GenerationUtil.getDataTypeOfDataConversionAdjustment(d);
        _builder.append((Object)_dataTypeOfDataConversionAdjustment, "");
        _builder.append((Object)" get_Adjusted_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param pointer to dataset, ");
        String _name = d.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name);
        _builder.append((Object)_firstLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t\t\tthe ");
        String _name_1 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower_1, " ");
        _builder.append((Object)" to set");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void set_");
        String _name_2 = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_");
        String _name_3 = d.getName();
        String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_4 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p, ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name_5 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)" );");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateGetterPrototype(NonMeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterPrototype(NonMeasurementData d, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = d.isConstant();
        boolean bl = _not = !_isConstant;
        if (_not) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param pointer to dataset, ");
            String _name = d.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name);
            _builder.append((Object)_firstLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _name_1 = d.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_1);
            _builder.append((Object)_firstLower_1, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"void set_");
            String _name_2 = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"_");
            String _name_3 = d.getName();
            String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_4 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"* p, ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name_5 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_2, "");
            _builder.append((Object)" );");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateDescription(MeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*\t\t\t\tMeasured in unit: ");
        Unit _unit = data.getUnit();
        _builder.append((Object)_unit, "");
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateDescription(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateVariable(MeasurementData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        boolean _isAdjustedByLineareConversionWithInterval = this.isAdjustedByLineareConversionWithInterval(data);
        if (_isAdjustedByLineareConversionWithInterval) {
            String _dataTypeOfDataConversionAdjustment = GenerationUtil.getDataTypeOfDataConversionAdjustment(data);
            _builder.append((Object)_dataTypeOfDataConversionAdjustment, "");
            _builder.append((Object)" adjusted_");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
            _builder.append((Object)_nameLower_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateVariable(NonMeasurementData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        return _builder;
    }

    public CharSequence generateAdjustAllEndiannessPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* Adjusts all data atributes of a struct to given endianness depending on the machine architecture");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void adjust_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_allEndianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSwapEndiannessOnDemandPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* Swaps Endianness between little endian and big endian");
        _builder.newLine();
        _builder.append((Object)"*/\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"void swap_");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_all_endianness(");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCheckLittleEndianPrototype() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* Returns true if given architecture is little endian");
        _builder.newLine();
        _builder.append((Object)"*/\t\t");
        _builder.newLine();
        _builder.append((Object)"bool check_little_endian();\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String className) {
        return String.valueOf(className) + ".h";
    }

    public CharSequence generateGetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateGetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateGetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateSetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateSetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateSetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateDescription(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateDescription((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateDescription((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    public CharSequence generateVariable(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateVariable((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateVariable((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }
}

