/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.language.generator.EcorePersistenceHelper;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensidlCodeGenerationExecutor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SensidlGenerator
implements IGenerator {
    @Inject
    private SensidlCodeGenerationExecutor codeGenerator;
    private static Logger logger = Logger.getLogger(SensidlGenerator.class);
    private static String EXTENSION = "sensidl";
    private SensIDLConstants.GenerationLanguage generationLanguage = SensIDLConstants.GenerationLanguage.ALL;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        this.setUpLogger();
        this.codeGenerator.setGenerationLanguage(this.generationLanguage);
        this.codeGenerator.doGenerate(resource, fsa);
        logger.info((Object)"Code was generated");
        EList _contents = resource.getContents();
        Iterable _filter = Iterables.filter((Iterable)_contents, SensorInterface.class);
        SensorInterface dataModel = (SensorInterface)IterableExtensions.head((Iterable)_filter);
        boolean _equals = Objects.equal((Object)dataModel, null);
        if (_equals) {
            return;
        }
        URI _uRI = resource.getURI();
        URI _trimQuery = _uRI.trimQuery();
        URI _trimFragment = _trimQuery.trimFragment();
        URI _trimFileExtension = _trimFragment.trimFileExtension();
        String fileNameBase = _trimFileExtension.lastSegment();
        String fileName = String.valueOf(fileNameBase) + "." + EXTENSION;
        URI _createURI = URI.createURI((String)fileName);
        EcorePersistenceHelper.persistEcoreModel((EObject)dataModel, _createURI, fsa);
        logger.info((Object)"Model was successfully persisted.");
    }

    public SensIDLConstants.GenerationLanguage setGenerationLanguage(SensIDLConstants.GenerationLanguage generationLanguage) {
        this.generationLanguage = generationLanguage;
        return this.generationLanguage;
    }

    public void setUpLogger() {
        Package _package = SensidlGenerator.class.getPackage();
        String _name = _package.getName();
        Logger logger = Logger.getLogger((String)_name);
        logger.setLevel(Level.ALL);
    }
}

