/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator;

import de.fzi.sensidl.language.generator.ISensidlCodeGenerator;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.elementfilter.DataSetFilter;
import de.fzi.sensidl.language.generator.elementfilter.ElementFilter;
import de.fzi.sensidl.language.generator.elementfilter.UtilityDataFilter;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import de.fzi.sensidl.language.generator.generationstep.filegenerationstep.FileGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.skeletongenerationstep.SkeletonGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.utilitygenerationstep.UtilityGenerationStep;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SensidlCodeGenerationExecutor
implements ISensidlCodeGenerator {
    private static Logger logger = Logger.getLogger(SensidlCodeGenerationExecutor.class);
    private SensIDLConstants.GenerationLanguage generationLanguage;

    @Override
    public void doGenerate(Resource input, final IFileSystemAccess fsa) {
        GenerationStep.init(this.generationLanguage);
        ElementFilter.init(input);
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1<ArrayList<GenerationStep>> _function = new Procedures.Procedure1<ArrayList<GenerationStep>>(){

            public void apply(ArrayList<GenerationStep> it) {
                DataSetFilter _dataSetFilter = new DataSetFilter();
                SkeletonGenerationStep _skeletonGenerationStep = new SkeletonGenerationStep(_dataSetFilter);
                it.add(_skeletonGenerationStep);
                UtilityDataFilter _utilityDataFilter = new UtilityDataFilter();
                UtilityGenerationStep _utilityGenerationStep = new UtilityGenerationStep(_utilityDataFilter);
                it.add(_utilityGenerationStep);
                FileGenerationStep _fileGenerationStep = new FileGenerationStep(fsa);
                it.add(_fileGenerationStep);
            }
        };
        ArrayList generationChain = (ArrayList)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
        try {
            logger.info((Object)"Start with code-generation.");
            Consumer<GenerationStep> _function_1 = new Consumer<GenerationStep>(){

                @Override
                public void accept(GenerationStep generationStep) {
                    generationStep.startGenerationTask();
                }
            };
            generationChain.forEach(_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof OperationNotSupportedException) {
                OperationNotSupportedException e = (OperationNotSupportedException)_t;
                logger.error((Object)"Start to generate code-templates which does not exist.", (Throwable)e);
            }
            if (_t instanceof Exception) {
                Exception e_1 = (Exception)_t;
                logger.error((Object)"A error occurred.", (Throwable)e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public SensIDLConstants.GenerationLanguage setGenerationLanguage(SensIDLConstants.GenerationLanguage generationLanguage) {
        this.generationLanguage = generationLanguage;
        return this.generationLanguage;
    }
}

