/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.ui.handler;

import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import de.fzi.sensidl.language.ui.handler.GenerationHandler;
import de.fzi.sensidl.language.ui.handler.SettingsHandler;
import de.fzi.sensidl.language.ui.wizard.ErrorDialogHandler;
import java.io.FileNotFoundException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class LastSettingsGenerationHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String modelPath = SettingsHandler.loadModelPathSettings();
        String path = SettingsHandler.loadPathSettings();
        String language = SettingsHandler.loadLanguageSettings();
        if (modelPath.startsWith("platform:/resource")) {
            modelPath = modelPath.replace("platform:/resource", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        }
        if (path.startsWith("platform:/resource")) {
            path = path.replace("platform:/resource", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        }
        ErrorDialogHandler errorHandler = new ErrorDialogHandler();
        try {
            GenerationHandler.generate(path, modelPath, language);
            MessageDialog.openInformation((Shell)new Shell(), (String)"Info", (String)"The code was successfully generated");
        }
        catch (FileNotFoundException ex) {
            errorHandler.execute(new Shell(), ex);
        }
        catch (NoSidlFileException ex) {
            errorHandler.execute(new Shell(), ex);
        }
        catch (Exception ex) {
            errorHandler.execute(new Shell(), ex);
        }
        return null;
    }
}

