/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.ui.handler;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.fzi.sensidl.language.SensidlStandaloneSetup;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensidlGenerator;
import de.fzi.sensidl.language.generator.factory.java.JavaPluginProjectGenerator;
import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.service.AbstractGenericModule;

public class GenerationHandler {
    private static SensidlGenerator generator;
    private static SensIDLConstants.GenerationLanguage generationLanguage;

    static {
        generationLanguage = SensIDLConstants.GenerationLanguage.NONE;
    }

    private GenerationHandler() {
    }

    public static boolean generate(String path, String modelPath, String language) throws NoSidlFileException, FileNotFoundException {
        GenerationHandler.setGenerationLanguage(language);
        Injector injector = new SensidlStandaloneSetup().createInjectorAndDoEMFRegistration();
        if (generationLanguage == SensIDLConstants.GenerationLanguage.JAVA_PLUGIN_PROJECT) {
            JavaPluginProjectGenerator.setProjectName((String)path.substring(path.lastIndexOf(47) + 1));
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = null;
        File file = new File(modelPath);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (!FilenameUtils.getExtension((String)modelPath).equals("sidl")) {
            throw new NoSidlFileException("No SIDL file found");
        }
        resource = rs.getResource(URI.createURI((String)file.toURI().toString()), true);
        JavaIoFileSystemAccess fsa = new JavaIoFileSystemAccess();
        fsa.setOutputPath(path);
        generator = (SensidlGenerator)injector.getInstance(SensidlGenerator.class);
        generator.setGenerationLanguage(generationLanguage);
        Guice.createInjector((Module[])new Module[]{new AbstractGenericModule(){

            public Class<? extends IEncodingProvider> bindIEncodingProvider() {
                return IEncodingProvider.Runtime.class;
            }
        }}).injectMembers((Object)fsa);
        generator.doGenerate(resource, (IFileSystemAccess)fsa);
        return true;
    }

    public static SensIDLConstants.GenerationLanguage getGenerationLanguage() {
        return generationLanguage;
    }

    private static void setGenerationLanguage(String language) {
        switch (language) {
            case "Java": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVA;
                break;
            }
            case "Java Plug-in Project": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVA_PLUGIN_PROJECT;
                break;
            }
            case "JavaScript": {
                generationLanguage = SensIDLConstants.GenerationLanguage.JAVASCRIPT;
                break;
            }
            case "C#": {
                generationLanguage = SensIDLConstants.GenerationLanguage.CSHARP;
                break;
            }
            case "C": {
                generationLanguage = SensIDLConstants.GenerationLanguage.C;
                break;
            }
            case "All": {
                generationLanguage = SensIDLConstants.GenerationLanguage.ALL;
                break;
            }
            default: {
                generationLanguage = SensIDLConstants.GenerationLanguage.NONE;
            }
        }
    }
}

