/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.tests.generator;

import de.fzi.sensidl.design.sensidl.dataRepresentation.impl.DataRepresentationPackageImpl;
import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import de.fzi.sensidl.language.ui.handler.GenerationHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileDeleteStrategy;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class FileGenerationTest {
    private static File generationDirectory;
    private static Map<String, Boolean> map;
    private static String[] dataSets;

    static {
        dataSets = new String[]{"Conductor", "NeutralConductor", "Energy"};
    }

    @BeforeClass
    public static void setUp() throws IOException {
        DataRepresentationPackageImpl.init();
        generationDirectory = new File("test-gen/generator");
        if (!generationDirectory.exists()) {
            generationDirectory.mkdir();
        } else {
            FileGenerationTest.deleteGen();
        }
        map = new HashMap<String, Boolean>();
    }

    @Before
    public void addFiles() {
        map.put("sidlTestCode.sensidl", false);
        map.put("EMeter.txt", false);
    }

    @Test
    public void javaFilesGenerationTest() throws IOException, NoSidlFileException {
        int i = 0;
        while (i < dataSets.length) {
            map.put(String.valueOf(dataSets[i]) + ".java", false);
            ++i;
        }
        map.put("eMeterUtility.java", false);
        GenerationHandler.generate((String)generationDirectory.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"Java");
        this.checkGeneratedFiles();
    }

    @Test
    public void javascriptFilesGenerationTest() throws IOException, NoSidlFileException {
        int i = 0;
        while (i < dataSets.length) {
            map.put(String.valueOf(dataSets[i]) + ".js", false);
            ++i;
        }
        GenerationHandler.generate((String)generationDirectory.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"JavaScript");
        this.checkGeneratedFiles();
    }

    @Test
    public void CFilesGenerationTest() throws IOException, NoSidlFileException {
        int i = 0;
        while (i < dataSets.length) {
            map.put(String.valueOf(dataSets[i]) + ".c", false);
            map.put(String.valueOf(dataSets[i]) + ".h", false);
            ++i;
        }
        map.put("DTOs.h", false);
        map.put("eMeterUtility.h", false);
        GenerationHandler.generate((String)generationDirectory.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"C");
        this.checkGeneratedFiles();
    }

    @Test
    @Ignore
    public void CSharpFilesGenerationTest() throws IOException {
    }

    @After
    public void tearDown() throws IOException {
        FileGenerationTest.deleteGen();
        map.clear();
    }

    private void checkGeneratedFiles() {
        String[] stringArray = generationDirectory.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (!map.containsKey(file)) {
                throw new AssertionError((Object)(String.valueOf(file) + " should not get generated"));
            }
            map.put(file, true);
            ++n2;
        }
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (!entry.getValue().booleanValue()) {
                throw new AssertionError((Object)(String.valueOf(entry.getKey()) + " is missing"));
            }
        }
    }

    private static void deleteGen() throws IOException {
        File[] fileArray = generationDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            FileDeleteStrategy.FORCE.delete(file);
            ++n2;
        }
    }
}

