package de.fzi.sensidl.language.generator.factory.csharp;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensIDLOutputConfigurationProvider;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * CSharp code generator for the SensIDL Model.
 * Code will be generated by running the {@code generate()}-Method
 * 
 * @author Nathalie Hipp
 */
@SuppressWarnings("all")
public class CSharpDTOGenerator implements IDTOGenerator {
  private static Logger logger = Logger.getLogger(CSharpDTOGenerator.class);
  
  private boolean createEmptyConstructor = true;
  
  private List<DataSet> dataSet;
  
  private boolean createProject = false;
  
  /**
   * The constructor calls the constructor of the superclass to set a
   * list of DataSet-elements.
   * @param newDataSet - represents the list of DataSet-elements.
   */
  public CSharpDTOGenerator(final List<DataSet> newDataSet) {
    this.dataSet = newDataSet;
  }
  
  /**
   * The constructor calls the constructor of the superclass to set a list of DataSet-elements and a member-variable.
   * @param newDataSet Represents the list of DataSet-elements.
   * @param createProject Indicates if a project should be created.
   */
  public CSharpDTOGenerator(final List<DataSet> newDataSet, final boolean createProject) {
    this.dataSet = newDataSet;
    this.createProject = createProject;
  }
  
  /**
   * Generates the .cs file for each data transfer object.
   * @see IDTOGenerator#generate()
   */
  public HashMap<String, CharSequence> generate() {
    HashMap<String, CharSequence> _xblockexpression = null;
    {
      CSharpDTOGenerator.logger.info("Start with code-generation of a java data transfer object.");
      final HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
      if (this.createProject) {
        for (final DataSet d : this.dataSet) {
          {
            DataSet _get = this.dataSet.get(0);
            EList<EObject> _eContents = _get.eContents();
            Iterable<Data> _filter = Iterables.<Data>filter(_eContents, Data.class);
            Data _get_1 = ((Data[])Conversions.unwrapArray(_filter, Data.class))[0];
            EObject _eContainer = _get_1.eContainer();
            String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
            String _plus = ("src/de/fzi/sensidl/" + _sensorInterfaceName);
            String _plus_1 = (_plus + "/");
            String _nameUpper = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
            String _plus_2 = (_plus_1 + _addFileExtensionTo);
            String _nameUpper_1 = GenerationUtil.toNameUpper(d);
            CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
            filesToGenerate.put(_plus_2, _generateClassBody);
            String _nameUpper_2 = GenerationUtil.toNameUpper(d);
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
            String _plus_3 = ("File: " + _addFileExtensionTo_1);
            String _plus_4 = (_plus_3 + " was generated in ");
            String _plus_5 = (_plus_4 + SensIDLOutputConfigurationProvider.SENSIDL_GEN);
            CSharpDTOGenerator.logger.info(_plus_5);
          }
        }
      } else {
        for (final DataSet d_1 : this.dataSet) {
          {
            String _nameUpper = GenerationUtil.toNameUpper(d_1);
            String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
            String _nameUpper_1 = GenerationUtil.toNameUpper(d_1);
            CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d_1);
            filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
            String _nameUpper_2 = GenerationUtil.toNameUpper(d_1);
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
            String _plus = ("File: " + _addFileExtensionTo_1);
            String _plus_1 = (_plus + " was generated in ");
            String _plus_2 = (_plus_1 + SensIDLOutputConfigurationProvider.SENSIDL_GEN);
            CSharpDTOGenerator.logger.info(_plus_2);
          }
        }
      }
      _xblockexpression = filesToGenerate;
    }
    return _xblockexpression;
  }
  
  /**
   * Generates the Classes
   */
  public CharSequence generateClassBody(final String className, final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("using Gson;");
    _builder.newLine();
    _builder.append("using System;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/// <summary>");
    _builder.newLine();
    _builder.append("/// Data transfer object for ");
    _builder.append(className, "");
    _builder.newLineIfNotEmpty();
    _builder.append("/// ");
    _builder.newLine();
    _builder.append("/// </summary>");
    _builder.newLine();
    _builder.append("class ");
    _builder.append(className, "");
    _builder.append(" ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private long SerialVersionUid = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private GeneratedCodeAttribute generatedCodeAttribute = new GeneratedCodeAttribute(\"SensIDLCodeGenerator\", SerialVersionUid);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    String _generateDataFieldsIncludeParentDataSet = this.generateDataFieldsIncludeParentDataSet(d);
    _builder.append(_generateDataFieldsIncludeParentDataSet, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("/// <summary>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// Constructor for the Data transfer object");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// </summary>");
    _builder.newLine();
    _builder.append("\t");
    String _generateConstructorIncludeParentDataSet = this.generateConstructorIncludeParentDataSet(d, className);
    _builder.append(_generateConstructorIncludeParentDataSet, "\t");
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      if (this.createEmptyConstructor) {
        _builder.append("\t");
        _builder.append("/// <summary>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/// empty constructor for the Data transfer object");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/// </summary>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        _builder.append(className, "\t");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    String _generateDataMethodsIncludeParentDataSet = this.generateDataMethodsIncludeParentDataSet(d);
    _builder.append(_generateDataMethodsIncludeParentDataSet, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates the data fields for this data set including used data sets.
   */
  public String generateDataFieldsIncludeParentDataSet(final DataSet d) {
    DataSet dataSet = d;
    StringConcatenation _builder = new StringConcatenation();
    String dataFieldsString = _builder.toString();
    while ((dataSet != null)) {
      {
        EList<EObject> _eContents = dataSet.eContents();
        Iterable<NonMeasurementData> _filter = Iterables.<NonMeasurementData>filter(_eContents, NonMeasurementData.class);
        for (final NonMeasurementData data : _filter) {
          {
            String _dataFieldsString = dataFieldsString;
            CharSequence _generateDataFields = this.generateDataFields(data);
            dataFieldsString = (_dataFieldsString + _generateDataFields);
            String _dataFieldsString_1 = dataFieldsString;
            String _property = System.getProperty("line.separator");
            dataFieldsString = (_dataFieldsString_1 + _property);
          }
        }
        EList<EObject> _eContents_1 = dataSet.eContents();
        Iterable<MeasurementData> _filter_1 = Iterables.<MeasurementData>filter(_eContents_1, MeasurementData.class);
        for (final MeasurementData data_1 : _filter_1) {
          {
            String _dataFieldsString = dataFieldsString;
            CharSequence _generateDataFields = this.generateDataFields(data_1);
            dataFieldsString = (_dataFieldsString + _generateDataFields);
            String _dataFieldsString_1 = dataFieldsString;
            String _property = System.getProperty("line.separator");
            dataFieldsString = (_dataFieldsString_1 + _property);
          }
        }
        DataSet _parentDataSet = dataSet.getParentDataSet();
        dataSet = _parentDataSet;
      }
    }
    return dataFieldsString;
  }
  
  /**
   * Generates the constructor for this data set including used data sets.
   */
  public String generateConstructorIncludeParentDataSet(final DataSet d, final String className) {
    DataSet dataSet = d;
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public ");
    _builder.append(className, "");
    _builder.append(" (");
    CharSequence _generateConstructorArgumentsIncludeParentDataSets = this.generateConstructorArgumentsIncludeParentDataSets(d);
    _builder.append(_generateConstructorArgumentsIncludeParentDataSets, "");
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    String constructorString = _builder.toString();
    String _constructorString = constructorString;
    String _property = System.getProperty("line.separator");
    constructorString = (_constructorString + _property);
    ArrayList<MeasurementData> measurementDataList = new ArrayList<MeasurementData>();
    ArrayList<NonMeasurementData> nonMeasurementDataList = new ArrayList<NonMeasurementData>();
    while ((dataSet != null)) {
      {
        EList<EObject> _eContents = dataSet.eContents();
        Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_eContents, MeasurementData.class);
        Iterables.<MeasurementData>addAll(measurementDataList, _filter);
        EList<EObject> _eContents_1 = dataSet.eContents();
        Iterable<NonMeasurementData> _filter_1 = Iterables.<NonMeasurementData>filter(_eContents_1, NonMeasurementData.class);
        Iterables.<NonMeasurementData>addAll(nonMeasurementDataList, _filter_1);
        DataSet _parentDataSet = dataSet.getParentDataSet();
        dataSet = _parentDataSet;
      }
    }
    for (final MeasurementData data : measurementDataList) {
      String _constructorString_1 = constructorString;
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("\t");
      _builder_1.append("this.");
      String _nameLower = GenerationUtil.toNameLower(data);
      _builder_1.append(_nameLower, "\t");
      _builder_1.append(" = ");
      String _nameLower_1 = GenerationUtil.toNameLower(data);
      _builder_1.append(_nameLower_1, "\t");
      _builder_1.append(";");
      _builder_1.newLineIfNotEmpty();
      constructorString = (_constructorString_1 + _builder_1);
    }
    for (final NonMeasurementData data_1 : nonMeasurementDataList) {
      boolean _isConstant = data_1.isConstant();
      boolean _not = (!_isConstant);
      if (_not) {
        String _constructorString_2 = constructorString;
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("\t");
        _builder_2.append("this.");
        String _nameLower_2 = GenerationUtil.toNameLower(data_1);
        _builder_2.append(_nameLower_2, "\t");
        _builder_2.append(" = ");
        String _nameLower_3 = GenerationUtil.toNameLower(data_1);
        _builder_2.append(_nameLower_3, "\t");
        _builder_2.append(";");
        _builder_2.newLineIfNotEmpty();
        constructorString = (_constructorString_2 + _builder_2);
      }
    }
    return constructorString;
  }
  
  /**
   * Generates the getter and setter methods for the data of this data set including used data sets.
   */
  public String generateDataMethodsIncludeParentDataSet(final DataSet d) {
    DataSet dataSet = d;
    StringConcatenation _builder = new StringConcatenation();
    String methodsString = _builder.toString();
    ArrayList<MeasurementData> measurementDataList = new ArrayList<MeasurementData>();
    ArrayList<NonMeasurementData> nonMeasurementDataList = new ArrayList<NonMeasurementData>();
    while ((dataSet != null)) {
      {
        EList<EObject> _eContents = dataSet.eContents();
        Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_eContents, MeasurementData.class);
        Iterables.<MeasurementData>addAll(measurementDataList, _filter);
        EList<EObject> _eContents_1 = dataSet.eContents();
        Iterable<NonMeasurementData> _filter_1 = Iterables.<NonMeasurementData>filter(_eContents_1, NonMeasurementData.class);
        Iterables.<NonMeasurementData>addAll(nonMeasurementDataList, _filter_1);
        DataSet _parentDataSet = dataSet.getParentDataSet();
        dataSet = _parentDataSet;
      }
    }
    for (final MeasurementData data : measurementDataList) {
      {
        String _methodsString = methodsString;
        CharSequence _generateProperties = this.generateProperties(data);
        methodsString = (_methodsString + _generateProperties);
        String _methodsString_1 = methodsString;
        String _property = System.getProperty("line.separator");
        methodsString = (_methodsString_1 + _property);
      }
    }
    for (final NonMeasurementData data_1 : nonMeasurementDataList) {
      {
        String _methodsString = methodsString;
        CharSequence _generateProperties = this.generateProperties(data_1);
        methodsString = (_methodsString + _generateProperties);
        String _methodsString_1 = methodsString;
        String _property = System.getProperty("line.separator");
        methodsString = (_methodsString_1 + _property);
      }
    }
    return methodsString;
  }
  
  /**
   * Generates the fields for the measurement data
   */
  public CharSequence generateDataFields(final MeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/// <summary>");
    _builder.newLine();
    {
      String _description = d.getDescription();
      boolean _notEquals = (!Objects.equal(_description, null));
      if (_notEquals) {
        _builder.append(" /// ");
        String _description_1 = d.getDescription();
        _builder.append(_description_1, "");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("/// Unit: ");
    Unit<?> _unit = d.getUnit();
    _builder.append(_unit, "");
    _builder.newLineIfNotEmpty();
    _builder.append("/// </summary>");
    _builder.newLine();
    _builder.append("private ");
    String _typeName = this.toTypeName(d);
    _builder.append(_typeName, "");
    _builder.append(" ");
    String _nameLower = GenerationUtil.toNameLower(d);
    _builder.append(_nameLower, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Generates the fields for the non measurement data
   */
  public CharSequence generateDataFields(final NonMeasurementData d) {
    CharSequence _xifexpression = null;
    boolean _isConstant = d.isConstant();
    if (_isConstant) {
      StringConcatenation _builder = new StringConcatenation();
      {
        String _description = d.getDescription();
        boolean _notEquals = (!Objects.equal(_description, null));
        if (_notEquals) {
          _builder.append("/// <summary> ");
          _builder.newLine();
          _builder.append("/// ");
          String _description_1 = d.getDescription();
          _builder.append(_description_1, "");
          _builder.newLineIfNotEmpty();
          _builder.append("/// </summary>");
          _builder.newLine();
        }
      }
      _builder.append("private ");
      String _typeName = this.toTypeName(d);
      _builder.append(_typeName, "");
      _builder.append(" ");
      CharSequence _propertyName = this.toPropertyName(d);
      _builder.append(_propertyName, "");
      _builder.append(" = ");
      {
        DataType _dataType = d.getDataType();
        boolean _equals = Objects.equal(_dataType, DataType.STRING);
        if (_equals) {
          _builder.append("\"");
          String _value = d.getValue();
          _builder.append(_value, "");
          _builder.append("\"");
        } else {
          String _value_1 = d.getValue();
          _builder.append(_value_1, "");
        }
      }
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _xifexpression = _builder;
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        String _description_2 = d.getDescription();
        boolean _notEquals_1 = (!Objects.equal(_description_2, null));
        if (_notEquals_1) {
          _builder_1.append("/// <summary>");
          _builder_1.newLine();
          _builder_1.append("/// ");
          String _description_3 = d.getDescription();
          _builder_1.append(_description_3, "");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("/// </summary>");
          _builder_1.newLine();
        }
      }
      _builder_1.append("private ");
      String _typeName_1 = this.toTypeName(d);
      _builder_1.append(_typeName_1, "");
      _builder_1.append(" ");
      String _nameLower = GenerationUtil.toNameLower(d);
      _builder_1.append(_nameLower, "");
      {
        String _value_2 = d.getValue();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_2);
        boolean _not = (!_isNullOrEmpty);
        if (_not) {
          _builder_1.append(" = ");
          {
            DataType _dataType_1 = d.getDataType();
            boolean _equals_1 = Objects.equal(_dataType_1, DataType.STRING);
            if (_equals_1) {
              _builder_1.append("\"");
              String _value_3 = d.getValue();
              _builder_1.append(_value_3, "");
              _builder_1.append("\"");
            } else {
              String _value_4 = d.getValue();
              _builder_1.append(_value_4, "");
            }
          }
        }
      }
      _builder_1.append(";");
      _builder_1.newLineIfNotEmpty();
      _xifexpression = _builder_1;
    }
    return _xifexpression;
  }
  
  /**
   * Maps to the corresponding language data type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  public String toTypeName(final Data d) {
    String _switchResult = null;
    DataType _dataType = d.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case INT8:
          _switchResult = "byte";
          break;
        case UINT8:
          _switchResult = "byte";
          break;
        case INT16:
          _switchResult = "short";
          break;
        case UINT16:
          _switchResult = "ushort";
          break;
        case INT32:
          _switchResult = "int";
          break;
        case UINT32:
          _switchResult = "uint";
          break;
        case INT64:
          _switchResult = "long";
          break;
        case UINT64:
          _switchResult = "ulong";
          break;
        case FLOAT:
          _switchResult = "float";
          break;
        case DOUBLE:
          _switchResult = "double";
          break;
        case BOOLEAN:
          _switchResult = "bool";
          break;
        case STRING:
          _switchResult = "string";
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  /**
   * returns the appropriate simple type name suitable for casting
   */
  public String toSimpleTypeName(final Data d) {
    String _typeName = this.toTypeName(d);
    String _typeName_1 = this.toTypeName(d);
    int _lastIndexOf = _typeName_1.lastIndexOf(".");
    int _plus = (_lastIndexOf + 1);
    String _substring = _typeName.substring(_plus);
    return _substring.toLowerCase();
  }
  
  /**
   * Generates the Constructor arguments
   */
  public CharSequence generateConstructorArgumentsIncludeParentDataSets(final DataSet d) {
    CharSequence _xblockexpression = null;
    {
      ArrayList<Data> dataList = new ArrayList<Data>();
      DataSet dataSet = d;
      while ((!Objects.equal(dataSet, null))) {
        {
          EList<EObject> _eContents = dataSet.eContents();
          Iterable<Data> _filter = Iterables.<Data>filter(_eContents, Data.class);
          for (final Data data : _filter) {
            if ((data instanceof NonMeasurementData)) {
              NonMeasurementData nmdata = ((NonMeasurementData) data);
              boolean _isConstant = nmdata.isConstant();
              boolean _not = (!_isConstant);
              if (_not) {
                dataList.add(data);
              }
            } else {
              dataList.add(data);
            }
          }
          DataSet _parentDataSet = dataSet.getParentDataSet();
          dataSet = _parentDataSet;
        }
      }
      CharSequence _xifexpression = null;
      int _size = dataList.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _xblockexpression_1 = null;
        {
          Data _get = dataList.get(0);
          String _typeName = this.toTypeName(_get);
          String _plus = (_typeName + " ");
          Data _get_1 = dataList.get(0);
          String _nameLower = GenerationUtil.toNameLower(_get_1);
          String firstElement = (_plus + _nameLower);
          dataList.remove(0);
          StringConcatenation _builder = new StringConcatenation();
          _builder.append(firstElement, "");
          {
            for(final Data data : dataList) {
              _builder.append(", ");
              String _typeName_1 = this.toTypeName(data);
              _builder.append(_typeName_1, "");
              _builder.append(" ");
              String _nameLower_1 = GenerationUtil.toNameLower(data);
              _builder.append(_nameLower_1, "");
            }
          }
          _xblockexpression_1 = _builder;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        CharSequence _xblockexpression_2 = null;
        {
          this.createEmptyConstructor = false;
          StringConcatenation _builder = new StringConcatenation();
          _xblockexpression_2 = _builder;
        }
        _xifexpression = _xblockexpression_2;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  /**
   * Generates the Getter Method for the measurement data
   */
  public CharSequence generateProperties(final MeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<DataAdjustment> _adjustments = d.getAdjustments();
      boolean _isEmpty = _adjustments.isEmpty();
      boolean _equals = (_isEmpty == false);
      if (_equals) {
        {
          EList<DataAdjustment> _adjustments_1 = d.getAdjustments();
          for(final DataAdjustment dataAdj : _adjustments_1) {
            {
              if ((dataAdj instanceof DataRange)) {
                _builder.append("///");
                _builder.newLine();
                _builder.append("/// <param name=\"");
                String _nameLower = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower, "");
                _builder.append("\"> </param>");
                _builder.newLineIfNotEmpty();
                _builder.append("///\t<returns>");
                String _nameLower_1 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_1, "");
                _builder.append("</returns>");
                _builder.newLineIfNotEmpty();
                _builder.append("///");
                _builder.newLine();
                _builder.append("public ");
                String _typeName = this.toTypeName(d);
                _builder.append(_typeName, "");
                _builder.append(" ");
                CharSequence _propertyName = this.toPropertyName(d);
                _builder.append(_propertyName, "");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("get { return ");
                String _nameLower_2 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_2, "\t");
                _builder.append("; }");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("set {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("if (value >= ");
                Interval _range = ((DataRange)dataAdj).getRange();
                double _lowerBound = _range.getLowerBound();
                _builder.append(_lowerBound, "\t\t");
                _builder.append(" && value <= ");
                Interval _range_1 = ((DataRange)dataAdj).getRange();
                double _upperBound = _range_1.getUpperBound();
                _builder.append(_upperBound, "\t\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                String _nameLower_3 = GenerationUtil.toNameLower(d);
                _builder.append(_nameLower_3, "\t\t\t");
                _builder.append(" = value;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("else");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("throw new IllegalArgumentException(\"value is out of defined range\");\t");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("} \t\t");
                _builder.newLine();
              }
            }
            {
              if ((dataAdj instanceof DataConversion)) {
                {
                  if ((dataAdj instanceof LinearDataConversion)) {
                    _builder.append("///");
                    _builder.newLine();
                    _builder.append("/// <param name=\"");
                    String _nameLower_4 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_4, "");
                    _builder.append("\"> </param>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("///\t<returns>");
                    String _nameLower_5 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_5, "");
                    _builder.append("</returns>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("///");
                    _builder.newLine();
                    _builder.append("public ");
                    String _typeName_1 = this.toTypeName(d);
                    _builder.append(_typeName_1, "");
                    _builder.append(" ");
                    CharSequence _propertyName_1 = this.toPropertyName(d);
                    _builder.append(_propertyName_1, "");
                    _builder.append("(){");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("get { return ");
                    String _nameLower_6 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_6, "\t");
                    _builder.append("; }");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("set { ");
                    String _nameLower_7 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_7, "\t");
                    _builder.append(" = value *  ");
                    double _scalingFactor = ((LinearDataConversion)dataAdj).getScalingFactor();
                    _builder.append(_scalingFactor, "\t");
                    _builder.append(" +  ");
                    double _offset = ((LinearDataConversion)dataAdj).getOffset();
                    _builder.append(_offset, "\t");
                    _builder.append(";}\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
                {
                  if ((dataAdj instanceof LinearDataConversionWithInterval)) {
                    _builder.append("///");
                    _builder.newLine();
                    _builder.append("/// <param name=\"");
                    String _nameLower_8 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_8, "");
                    _builder.append("\"> </param>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("///\t<returns>");
                    String _nameLower_9 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_9, "");
                    _builder.append("</returns>");
                    _builder.newLineIfNotEmpty();
                    _builder.append("///");
                    _builder.newLine();
                    _builder.append("public ");
                    CharSequence _propertyName_2 = this.toPropertyName(d);
                    _builder.append(_propertyName_2, "");
                    _builder.append("() ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("get { return ");
                    String _nameLower_10 = GenerationUtil.toNameLower(d);
                    _builder.append(_nameLower_10, "\t");
                    _builder.append("; }");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("set {");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("try {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, ((DataConversion) dataAdj));
                    _builder.append(_generateSetterBodyForMeasurementData, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("} catch (IllegalArgumentException e) {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("//Do something");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      } else {
        _builder.append("///");
        _builder.newLine();
        _builder.append("/// <param name=\"");
        String _nameLower_11 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_11, "");
        _builder.append("\"> </param>");
        _builder.newLineIfNotEmpty();
        _builder.append("///\t<returns>");
        String _nameLower_12 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_12, "");
        _builder.append("</returns>");
        _builder.newLineIfNotEmpty();
        _builder.append("///");
        _builder.newLine();
        _builder.append("public ");
        String _typeName_2 = this.toTypeName(d);
        _builder.append(_typeName_2, "");
        _builder.append(" ");
        CharSequence _propertyName_3 = this.toPropertyName(d);
        _builder.append(_propertyName_3, "");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("get { return ");
        String _nameLower_13 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_13, "\t");
        _builder.append("; }");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("set { ");
        String _nameLower_14 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_14, "\t");
        _builder.append(" = value; }");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * Generates the Getter Method for the non measurement data
   */
  public CharSequence generateProperties(final NonMeasurementData d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isConstant = d.isConstant();
      if (_isConstant) {
        _builder.append("///");
        _builder.newLine();
        _builder.append("///\t<returns>");
        String _nameLower = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower, "");
        _builder.append("</returns>");
        _builder.newLineIfNotEmpty();
        _builder.append("///");
        _builder.newLine();
        _builder.append("public ");
        String _typeName = this.toTypeName(d);
        _builder.append(_typeName, "");
        _builder.append(" ");
        CharSequence _propertyName = this.toPropertyName(d);
        _builder.append(_propertyName, "");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("get { return ");
        {
          boolean _isConstant_1 = d.isConstant();
          if (_isConstant_1) {
            CharSequence _propertyName_1 = this.toPropertyName(d);
            _builder.append(_propertyName_1, "\t");
          } else {
            String _nameLower_1 = GenerationUtil.toNameLower(d);
            _builder.append(_nameLower_1, "\t");
          }
        }
        _builder.append("; }");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append("///");
        _builder.newLine();
        _builder.append("/// <param name=\"");
        String _nameLower_2 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_2, "");
        _builder.append("\"> </param>");
        _builder.newLineIfNotEmpty();
        _builder.append("///\t<returns>");
        String _nameLower_3 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_3, "");
        _builder.append("</returns>");
        _builder.newLineIfNotEmpty();
        _builder.append("///");
        _builder.newLine();
        _builder.append("public ");
        String _typeName_1 = this.toTypeName(d);
        _builder.append(_typeName_1, "");
        _builder.append(" ");
        CharSequence _propertyName_2 = this.toPropertyName(d);
        _builder.append(_propertyName_2, "");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("get { return ");
        String _nameLower_4 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_4, "\t");
        _builder.append("; }");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("set { ");
        String _nameLower_5 = GenerationUtil.toNameLower(d);
        _builder.append(_nameLower_5, "\t");
        _builder.append(" = value; }");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence toPropertyName(final Data d) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = d.getName();
    String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
    String _firstUpper = StringExtensions.toFirstUpper(_replaceAll);
    _builder.append(_firstUpper, "");
    return _builder;
  }
  
  protected CharSequence _generateSetterBodyForMeasurementData(final MeasurementData data, final LinearDataConversion conversion) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("double offset = ");
    double _offset = conversion.getOffset();
    _builder.append(_offset, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("double scalingFactor = ");
    double _scalingFactor = conversion.getScalingFactor();
    _builder.append(_scalingFactor, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "");
    _builder.append(" = (");
    String _simpleTypeName = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName, "");
    _builder.append(") ");
    EObject _eContainer = data.eContainer();
    String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
    _builder.append(_sensorInterfaceName, "");
    _builder.append(SensIDLConstants.UTILITY_CLASS_NAME, "");
    _builder.append(".");
    _builder.append(SensIDLConstants.LINEAR_CONVERSION_METHOD_NAME, "");
    _builder.append("(");
    String _nameLower_1 = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower_1, "");
    _builder.append(", scalingFactor, offset);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _generateSetterBodyForMeasurementData(final MeasurementData data, final LinearDataConversionWithInterval conversion) {
    StringConcatenation _builder = new StringConcatenation();
    String _typeName = this.toTypeName(data);
    _builder.append(_typeName, "");
    _builder.append(" oldMin = (");
    String _simpleTypeName = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName, "");
    _builder.append(") ");
    Interval _fromInterval = conversion.getFromInterval();
    double _lowerBound = _fromInterval.getLowerBound();
    _builder.append(_lowerBound, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _typeName_1 = this.toTypeName(data);
    _builder.append(_typeName_1, "");
    _builder.append(" oldMax = (");
    String _simpleTypeName_1 = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName_1, "");
    _builder.append(") ");
    Interval _fromInterval_1 = conversion.getFromInterval();
    double _upperBound = _fromInterval_1.getUpperBound();
    _builder.append(_upperBound, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _typeName_2 = this.toTypeName(data);
    _builder.append(_typeName_2, "");
    _builder.append(" newMin = (");
    String _simpleTypeName_2 = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName_2, "");
    _builder.append(") ");
    Interval _toInterval = conversion.getToInterval();
    double _lowerBound_1 = _toInterval.getLowerBound();
    _builder.append(_lowerBound_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _typeName_3 = this.toTypeName(data);
    _builder.append(_typeName_3, "");
    _builder.append(" newMax = (");
    String _simpleTypeName_3 = this.toSimpleTypeName(data);
    _builder.append(_simpleTypeName_3, "");
    _builder.append(") ");
    Interval _toInterval_1 = conversion.getToInterval();
    double _upperBound_1 = _toInterval_1.getUpperBound();
    _builder.append(_upperBound_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    String _nameLower = GenerationUtil.toNameLower(data);
    _builder.append(_nameLower, "");
    _builder.append(" = ((((value - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Adds the file extension.
   * @see IDTOGenerator#addFileExtensionTo(String)
   */
  public String addFileExtensionTo(final String ClassName) {
    return (ClassName + SensIDLConstants.CSharp_EXTENSION);
  }
  
  public CharSequence generateSetterBodyForMeasurementData(final MeasurementData data, final DataConversion conversion) {
    if (conversion instanceof LinearDataConversion) {
      return _generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
    } else if (conversion instanceof LinearDataConversionWithInterval) {
      return _generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(data, conversion).toString());
    }
  }
}
