package de.fzi.sensidl.language.generator.factory.c

import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet
import de.fzi.sensidl.language.generator.factory.ICodeGenerator
import java.util.ArrayList
import java.util.HashMap
import java.util.List
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData
import org.eclipse.emf.ecore.EObject

/**
* The CGenerator represents a concrete implementation of The ICodeGenerator and 
* implements the code-generator for the language C.
*/
class CGenerator implements ICodeGenerator {
	
	/**
 	*@see ICodeGenerator#generateDTO()
 	*/
	override generateDTO(List<DataSet> dataSet) {
		val generators = new ArrayList<CDTOGenerator>()
		generators += new HeaderDTOGenerator(dataSet)
		generators += new MainDTOHeaderFileGenerator(dataSet)
		generators += new CDTOFileGenerator(dataSet)
		
		val HashMap<String, CharSequence> filesToGenerate = new HashMap
		generators.forEach[generator | filesToGenerate.putAll(generator.generate)]
		
		filesToGenerate
	}
	
	/**
 	*@see ICodeGenerator#generateEncoder()
 	*/
	override generateEncoder() {
		//TODO has to be implemented
		throw new UnsupportedOperationException("TODO: auto-generated method stub")
	}
	
	/**
 	*@see ICodeGenerator#generateDecoder()
 	*/
	override generateDecoder() {
		//TODO has to be implemented
		throw new UnsupportedOperationException("TODO: auto-generated method stub")
	}
	
	/**
	 * @see ICodeGenerator#generateUtilityClass(List<MeasurementData>)
	 */
	override generateUtilityClass(List<EObject> data) {
		new CUtilityGenerator(data).generate
	}
}