package de.fzi.sensidl.language.generator.factory.c;

import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import de.fzi.sensidl.language.generator.factory.c.DataTypes;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/**
 * C code generator for the SensIDL Model.
 * Code will be generated by running the {@code generate()}-Method
 */
@SuppressWarnings("all")
public abstract class CDTOGenerator implements IDTOGenerator {
  protected List<DataSet> dataSets;
  
  /**
   * The constructor calls the constructor of the superclass to set a list of DataSet-elements.
   * @param newDataSet Represents the list of DataSet-elements.
   */
  public CDTOGenerator(final List<DataSet> newDataSet) {
    this.dataSets = newDataSet;
  }
  
  /**
   * Maps to the corresponding language type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  public String toTypeName(final Data data) {
    DataType _dataType = data.getDataType();
    return DataTypes.getDataTypeBy(_dataType);
  }
  
  public String toTypeName(final DataType dataType) {
    return DataTypes.getDataTypeBy(dataType);
  }
  
  /**
   * Checks, if the given MeasurementData-element was specified to be adjusted as linear conversion
   * with interval.
   */
  protected boolean isAdjustedByLineareConversionWithInterval(final MeasurementData data) {
    boolean _and = false;
    EList<DataAdjustment> _adjustments = data.getAdjustments();
    int _size = _adjustments.size();
    boolean _greaterThan = (_size > 0);
    if (!_greaterThan) {
      _and = false;
    } else {
      EList<DataAdjustment> _adjustments_1 = data.getAdjustments();
      DataAdjustment _get = _adjustments_1.get(0);
      _and = (_get instanceof LinearDataConversionWithInterval);
    }
    return _and;
  }
}
