package de.fzi.sensidl.language.generator;

import de.fzi.sensidl.language.generator.ISensidlCodeGenerator;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.elementfilter.DataSetFilter;
import de.fzi.sensidl.language.generator.elementfilter.ElementFilter;
import de.fzi.sensidl.language.generator.elementfilter.UtilityDataFilter;
import de.fzi.sensidl.language.generator.generationstep.GenerationStep;
import de.fzi.sensidl.language.generator.generationstep.filegenerationstep.FileGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.skeletongenerationstep.SkeletonGenerationStep;
import de.fzi.sensidl.language.generator.generationstep.utilitygenerationstep.UtilityGenerationStep;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Code generator für die SensIDL Sprache.
 * 
 * @author Dominik Werle - Base implementation
 * @author Max Scheerer	- refinement of the base implementation
 * @author Emre Taspolatoglu
 */
@SuppressWarnings("all")
public class SensidlCodeGenerationExecutor implements ISensidlCodeGenerator {
  private static Logger logger = Logger.getLogger(SensidlCodeGenerationExecutor.class);
  
  private SensIDLConstants.GenerationLanguage generationLanguage;
  
  /**
   * The entry point to the generation.
   * @param input Corresponds to the resource file which includes all specified sensidl elements.
   * @param fsa   Corresponds to the IFileSystemAccess-object which is used for the file-generation.
   */
  public void doGenerate(final Resource input, final IFileSystemAccess fsa) {
    GenerationStep.init(this.generationLanguage);
    ElementFilter.init(input);
    ArrayList<GenerationStep> _arrayList = new ArrayList<GenerationStep>();
    final Procedure1<ArrayList<GenerationStep>> _function = new Procedure1<ArrayList<GenerationStep>>() {
      public void apply(final ArrayList<GenerationStep> it) {
        DataSetFilter _dataSetFilter = new DataSetFilter();
        SkeletonGenerationStep _skeletonGenerationStep = new SkeletonGenerationStep(_dataSetFilter);
        it.add(_skeletonGenerationStep);
        UtilityDataFilter _utilityDataFilter = new UtilityDataFilter();
        UtilityGenerationStep _utilityGenerationStep = new UtilityGenerationStep(_utilityDataFilter);
        it.add(_utilityGenerationStep);
        FileGenerationStep _fileGenerationStep = new FileGenerationStep(fsa);
        it.add(_fileGenerationStep);
      }
    };
    final ArrayList<GenerationStep> generationChain = ObjectExtensions.<ArrayList<GenerationStep>>operator_doubleArrow(_arrayList, _function);
    try {
      SensidlCodeGenerationExecutor.logger.info("Start with code-generation.");
      final Consumer<GenerationStep> _function_1 = new Consumer<GenerationStep>() {
        public void accept(final GenerationStep generationStep) {
          generationStep.startGenerationTask();
        }
      };
      generationChain.forEach(_function_1);
    } catch (final Throwable _t) {
      if (_t instanceof OperationNotSupportedException) {
        final OperationNotSupportedException e = (OperationNotSupportedException)_t;
        SensidlCodeGenerationExecutor.logger.error("Start to generate code-templates which does not exist.", e);
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        SensidlCodeGenerationExecutor.logger.error("A error occurred.", e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  /**
   * Set the language to generate the code in.
   * @param generationLanguage Represents the new generation language value.
   */
  public SensIDLConstants.GenerationLanguage setGenerationLanguage(final SensIDLConstants.GenerationLanguage generationLanguage) {
    return this.generationLanguage = generationLanguage;
  }
}
