/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(JavaDTOGenerator.class);
    private boolean createEmptyConstructor = true;
    private List<DataSet> dataSet;
    private boolean createProject = false;

    public JavaDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    public JavaDTOGenerator(List<DataSet> newDataSet, boolean createProject) {
        this.dataSet = newDataSet;
        this.createProject = createProject;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a java data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        if (this.createProject) {
            for (DataSet d : this.dataSet) {
                DataSet _get = this.dataSet.get(0);
                EList _eContents = _get.eContents();
                Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
                Data _get_1 = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
                EObject _eContainer = _get_1.eContainer();
                String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
                String _plus = "src/de/fzi/sensidl/" + _sensorInterfaceName;
                String _plus_1 = String.valueOf(_plus) + "/";
                String _nameUpper = GenerationUtil.toNameUpper(d);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _plus_2 = String.valueOf(_plus_1) + _addFileExtensionTo;
                String _nameUpper_1 = GenerationUtil.toNameUpper(d);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
                filesToGenerate.put(_plus_2, _generateClassBody);
                String _nameUpper_2 = GenerationUtil.toNameUpper(d);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus_3 = "File: " + _addFileExtensionTo_1;
                String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
                String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
                logger.info((Object)_plus_5);
            }
        } else {
            for (DataSet d_1 : this.dataSet) {
                String _nameUpper = GenerationUtil.toNameUpper(d_1);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _nameUpper_1 = GenerationUtil.toNameUpper(d_1);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d_1);
                filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
                String _nameUpper_2 = GenerationUtil.toNameUpper(d_1);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus = "File: " + _addFileExtensionTo_1;
                String _plus_1 = String.valueOf(_plus) + " was generated in ";
                String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
                logger.info((Object)_plus_2);
            }
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className, DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        if (this.createProject) {
            _builder.append((Object)"package de.fzi.sensidl.");
            EList _eContents = d.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
            Data _get = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
            EObject _eContainer = _get.eContainer();
            String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
            _builder.append((Object)_sensorInterfaceName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.newLine();
        }
        _builder.append((Object)"import java.io.BufferedReader;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ByteArrayInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ObjectInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.Serializable;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data transfer object for ");
        _builder.append((Object)className, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final long serialVersionUID = 1L;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateDataFieldsIncludeParentDataSet = this.generateDataFieldsIncludeParentDataSet(d);
        _builder.append((Object)_generateDataFieldsIncludeParentDataSet, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Constructor for the Data transfer object");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateConstructorIncludeParentDataSet = this.generateConstructorIncludeParentDataSet(d, className);
        _builder.append((Object)_generateConstructorIncludeParentDataSet, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (this.createEmptyConstructor) {
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* empty constructor for the Data transfer object");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            _builder.append((Object)className, "\t");
            _builder.append((Object)"(){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _generateDataMethodsIncludeParentDataSet = this.generateDataMethodsIncludeParentDataSet(d);
        _builder.append((Object)_generateDataMethodsIncludeParentDataSet, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateJsonUnmarshal = this.generateJsonUnmarshal(d);
        _builder.append((Object)_generateJsonUnmarshal, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateByteArrayUnmarshal = this.generateByteArrayUnmarshal(d);
        _builder.append((Object)_generateByteArrayUnmarshal, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public String generateDataFieldsIncludeParentDataSet(DataSet d) {
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String dataFieldsString = _builder.toString();
        while (dataSet != null) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, NonMeasurementData.class);
            for (NonMeasurementData data : _filter) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateDataFields = this.generateDataFields(data);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, MeasurementData.class);
            for (MeasurementData data_1 : _filter_1) {
                String _dataFieldsString = dataFieldsString;
                CharSequence _generateDataFields = this.generateDataFields(data_1);
                String _dataFieldsString_1 = dataFieldsString = String.valueOf(_dataFieldsString) + _generateDataFields;
                String _property = System.getProperty("line.separator");
                dataFieldsString = String.valueOf(_dataFieldsString_1) + _property;
            }
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        return dataFieldsString;
    }

    public String generateConstructorIncludeParentDataSet(DataSet d, String className) {
        String constructorString;
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public ");
        _builder.append((Object)className, "");
        _builder.append((Object)" (");
        CharSequence _generateConstructorArgumentsIncludeParentDataSets = this.generateConstructorArgumentsIncludeParentDataSets(d);
        _builder.append((Object)_generateConstructorArgumentsIncludeParentDataSets, "");
        _builder.append((Object)"){");
        String _constructorString = constructorString = _builder.toString();
        String _property = System.getProperty("line.separator");
        constructorString = String.valueOf(_constructorString) + _property;
        ArrayList measurementDataList = new ArrayList();
        ArrayList nonMeasurementDataList = new ArrayList();
        while (dataSet != null) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
            Iterables.addAll(measurementDataList, (Iterable)_filter);
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
            Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_1);
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        for (MeasurementData data : measurementDataList) {
            String _constructorString_1 = constructorString;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\t");
            _builder_1.append((Object)"this.");
            String _nameLower = GenerationUtil.toNameLower((Data)data);
            _builder_1.append((Object)_nameLower, "\t");
            _builder_1.append((Object)" = ");
            DataType _dataType = data.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
                _builder_1.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)data);
                _builder_1.append((Object)_simpleTypeName, "\t");
                _builder_1.append((Object)") (");
                String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
                _builder_1.append((Object)_nameLower_1, "\t");
                _builder_1.append((Object)" - ");
                String _typeName = this.toTypeName((Data)data);
                _builder_1.append((Object)_typeName, "\t");
                _builder_1.append((Object)".MAX_VALUE)");
            } else {
                String _nameLower_2 = GenerationUtil.toNameLower((Data)data);
                _builder_1.append((Object)_nameLower_2, "\t");
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            constructorString = String.valueOf(_constructorString_1) + _builder_1;
        }
        for (NonMeasurementData data_1 : nonMeasurementDataList) {
            boolean _not;
            boolean _isConstant = data_1.isConstant();
            boolean bl = _not = !_isConstant;
            if (!_not) continue;
            String _constructorString_2 = constructorString;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"\t");
            _builder_2.append((Object)"this.");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)data_1);
            _builder_2.append((Object)_nameLower_3, "\t");
            _builder_2.append((Object)" = ");
            DataType _dataType_1 = data_1.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder_2.append((Object)"(");
                String _simpleTypeName_1 = this.toSimpleTypeName((Data)data_1);
                _builder_2.append((Object)_simpleTypeName_1, "\t");
                _builder_2.append((Object)") (");
                String _nameLower_4 = GenerationUtil.toNameLower((Data)data_1);
                _builder_2.append((Object)_nameLower_4, "\t");
                _builder_2.append((Object)" - ");
                String _typeName_1 = this.toTypeName((Data)data_1);
                _builder_2.append((Object)_typeName_1, "\t");
                _builder_2.append((Object)".MAX_VALUE)");
            } else {
                String _nameLower_5 = GenerationUtil.toNameLower((Data)data_1);
                _builder_2.append((Object)_nameLower_5, "\t");
            }
            _builder_2.append((Object)";");
            _builder_2.newLineIfNotEmpty();
            constructorString = String.valueOf(_constructorString_2) + _builder_2;
        }
        return constructorString;
    }

    public String generateDataMethodsIncludeParentDataSet(DataSet d) {
        String _property_1;
        String _methodsString_3;
        CharSequence _generateSetter;
        String _methodsString_2;
        String _property;
        String _methodsString_1;
        CharSequence _generateGetter;
        String _methodsString;
        DataSet dataSet = d;
        StringConcatenation _builder = new StringConcatenation();
        String methodsString = _builder.toString();
        ArrayList measurementDataList = new ArrayList();
        ArrayList nonMeasurementDataList = new ArrayList();
        while (dataSet != null) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, MeasurementData.class);
            Iterables.addAll(measurementDataList, (Iterable)_filter);
            EList _eContents_1 = dataSet.eContents();
            Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
            Iterables.addAll(nonMeasurementDataList, (Iterable)_filter_1);
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        for (MeasurementData data : measurementDataList) {
            _methodsString = methodsString;
            _generateGetter = this.generateGetter(data);
            _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetter;
            _property = System.getProperty("line.separator");
            _methodsString_2 = methodsString = String.valueOf(_methodsString_1) + _property;
            _generateSetter = this.generateSetter(data);
            _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetter;
            _property_1 = System.getProperty("line.separator");
            methodsString = String.valueOf(_methodsString_3) + _property_1;
        }
        for (NonMeasurementData data_1 : nonMeasurementDataList) {
            _methodsString = methodsString;
            _generateGetter = this.generateGetter(data_1);
            _methodsString_1 = methodsString = String.valueOf(_methodsString) + _generateGetter;
            _property = System.getProperty("line.separator");
            _methodsString_2 = methodsString = String.valueOf(_methodsString_1) + _property;
            _generateSetter = this.generateSetter(data_1);
            _methodsString_3 = methodsString = String.valueOf(_methodsString_2) + _generateSetter;
            _property_1 = System.getProperty("line.separator");
            methodsString = String.valueOf(_methodsString_3) + _property_1;
        }
        return methodsString;
    }

    public CharSequence generateDataFields(MeasurementData d) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        String _description = d.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)" * ");
            String _description_1 = d.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* Unit: ");
        Unit _unit = d.getUnit();
        _builder.append((Object)_unit, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateDataFields(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            boolean _notEquals;
            StringConcatenation _builder = new StringConcatenation();
            String _description = d.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                _builder.append((Object)" ");
                _builder.append((Object)"/*");
                _builder.newLine();
                _builder.append((Object)"  ");
                _builder.append((Object)"*");
                String _description_1 = d.getDescription();
                _builder.append((Object)_description_1, "  ");
                _builder.newLineIfNotEmpty();
                DataType _dataType = d.getDataType();
                boolean _isUnsigned = this.isUnsigned(_dataType);
                if (_isUnsigned) {
                    _builder.append((Object)" ");
                    _builder.append((Object)"* (Java has no option for unsigned data types, so if the data has an unsigned ");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* data type the value is calculated by subtracting the max value from the ");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* signed data type and adding it again, if it is used.) ");
                    _builder.newLine();
                }
                _builder.append((Object)"*/");
                _builder.newLine();
            }
            _builder.append((Object)"private static final ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = ");
            DataType _dataType_1 = d.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder.append((Object)_simpleTypeName, "");
                _builder.append((Object)") (");
                String _value = d.getValue();
                _builder.append((Object)_value, "");
                _builder.append((Object)" - ");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)".MAX_VALUE)");
            } else {
                String _value_1 = d.getValue();
                _builder.append((Object)_value_1, "");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            boolean _not;
            boolean _notEquals_1;
            StringConcatenation _builder_1 = new StringConcatenation();
            String _description_2 = d.getDescription();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                _builder_1.append((Object)"/*");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*");
                String _description_3 = d.getDescription();
                _builder_1.append((Object)_description_3, " ");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*/");
                _builder_1.newLine();
            }
            _builder_1.append((Object)"private ");
            String _typeName_2 = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName_2, "");
            _builder_1.append((Object)" ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, "");
            String _value_2 = d.getValue();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_value_2);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                _builder_1.append((Object)" = ");
                String _value_3 = d.getValue();
                _builder_1.append((Object)_value_3, "");
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    @Override
    public String toTypeName(Data d) {
        String _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case UINT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case INT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case UINT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case INT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case INT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case UINT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class.getName();
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class.getName();
                    break;
                }
                case BOOLEAN: {
                    _switchResult = Boolean.class.getName();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public boolean isUnsigned(DataType d) {
        boolean _equals_3;
        boolean _equals_2;
        boolean _equals_1;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _equals = Objects.equal((Object)d, (Object)DataType.UINT8);
        _or_2 = _equals ? true : (_equals_1 = Objects.equal((Object)d, (Object)DataType.UINT16));
        _or_1 = _or_2 ? true : (_equals_2 = Objects.equal((Object)d, (Object)DataType.UINT32));
        _or = _or_1 ? true : (_equals_3 = Objects.equal((Object)d, (Object)DataType.UINT64));
        return _or;
    }

    public String toSimpleTypeName(Data d) {
        String _typeName = this.toTypeName(d);
        String _typeName_1 = this.toTypeName(d);
        int _lastIndexOf = _typeName_1.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        String _substring = _typeName.substring(_plus);
        return _substring.toLowerCase();
    }

    public CharSequence generateConstructorArgumentsIncludeParentDataSets(DataSet d) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        ArrayList<Data> dataList = new ArrayList<Data>();
        DataSet dataSet = d;
        while (!Objects.equal((Object)dataSet, null)) {
            DataSet _parentDataSet;
            EList _eContents = dataSet.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
            for (Data data : _filter) {
                if (data instanceof NonMeasurementData) {
                    boolean _not;
                    NonMeasurementData nmdata = (NonMeasurementData)data;
                    boolean _isConstant = nmdata.isConstant();
                    boolean bl = _not = !_isConstant;
                    if (!_not) continue;
                    dataList.add(data);
                    continue;
                }
                dataList.add(data);
            }
            dataSet = _parentDataSet = dataSet.getParentDataSet();
        }
        StringConcatenation _xifexpression = null;
        int _size = dataList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            StringConcatenation _xblockexpression_1 = null;
            Data _get = (Data)dataList.get(0);
            String _typeName = this.toTypeName(_get);
            String _plus = String.valueOf(_typeName) + " ";
            Data _get_1 = (Data)dataList.get(0);
            String _nameLower = GenerationUtil.toNameLower(_get_1);
            String firstElement = String.valueOf(_plus) + _nameLower;
            dataList.remove(0);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)firstElement, "");
            for (Data data : dataList) {
                _builder.append((Object)", ");
                String _typeName_1 = this.toTypeName(data);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_1 = GenerationUtil.toNameLower(data);
                _builder.append((Object)_nameLower_1, "");
            }
            _xifexpression = _xblockexpression_1 = _builder;
        } else {
            StringConcatenation _builder;
            StringConcatenation _xblockexpression_2 = null;
            this.createEmptyConstructor = false;
            _xifexpression = _xblockexpression_2 = (_builder = new StringConcatenation());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence generateGetter(MeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        DataType _dataType = d.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType);
        if (_isUnsigned) {
            _builder.append((Object)"* (Java has no option for unsigned data types, so if the data has an unsigned ");
            _builder.newLine();
            _builder.append((Object)"* data type the value is calculated by subtracting the max value from the ");
            _builder.newLine();
            _builder.append((Object)"* signed data type and adding it again, if it is used.)");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        DataType _dataType_1 = d.getDataType();
        boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
        if (_isUnsigned_1) {
            _builder.append((Object)"(");
            String _simpleTypeName = this.toSimpleTypeName((Data)d);
            _builder.append((Object)_simpleTypeName, "\t");
            _builder.append((Object)") (this.");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, "\t");
            _builder.append((Object)" + ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)".MAX_VALUE)");
        } else {
            _builder.append((Object)"this.");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_2, "\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        DataType _dataType = d.getDataType();
        boolean _isUnsigned = this.isUnsigned(_dataType);
        if (_isUnsigned) {
            _builder.append((Object)"* (Java has no option for unsigned data types, so if the data has an unsigned ");
            _builder.newLine();
            _builder.append((Object)"* data type the value is calculated by subtracting the max value from the ");
            _builder.newLine();
            _builder.append((Object)"* signed data type and adding it again, if it is used.)");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = GenerationUtil.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        DataType _dataType_1 = d.getDataType();
        boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
        if (_isUnsigned_1) {
            _builder.append((Object)"(");
            String _simpleTypeName = this.toSimpleTypeName((Data)d);
            _builder.append((Object)_simpleTypeName, "\t");
            _builder.append((Object)") (");
            boolean _isConstant = d.isConstant();
            if (_isConstant) {
                String _name = d.getName();
                String _upperCase = _name.toUpperCase();
                _builder.append((Object)_upperCase, "\t");
            } else {
                _builder.append((Object)"this.");
                String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_1, "\t");
            }
            _builder.append((Object)" + ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_1, "\t");
            _builder.append((Object)".MAX_VALUE)");
        } else {
            _builder.append((Object)"this.");
            boolean _isConstant_1 = d.isConstant();
            if (_isConstant_1) {
                String _name_1 = d.getName();
                String _upperCase_1 = _name_1.toUpperCase();
                _builder.append((Object)_upperCase_1, "\t");
            } else {
                String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_2, "\t");
            }
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence toGetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateSetter(MeasurementData d) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            _builder.newLine();
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.append((Object)"public void ");
                    CharSequence _setterName = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName, "");
                    _builder.append((Object)"(");
                    String _typeName = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName, "");
                    _builder.append((Object)" ");
                    String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this.");
                    String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "\t\t");
                    _builder.append((Object)" = ");
                    String _nameLower_6 = GenerationUtil.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"throw new IllegalArgumentException(\"value is out of defined range\");\t");
                    _builder.newLine();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                    continue;
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)"* @param ");
                String _nameLower_7 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_7, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"*\t\t\tthe ");
                String _nameLower_8 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_8, "");
                _builder.append((Object)" to set");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"public void ");
                CharSequence _setterName_1 = this.toSetterName((Data)d);
                _builder.append((Object)_setterName_1, "");
                _builder.append((Object)"(");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_9 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_9, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, (DataConversion)dataAdj);
                _builder.append((Object)_generateSetterBodyForMeasurementData, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"} catch (IllegalArgumentException e) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//Do something");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower_10 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_10, " ");
            _builder.append((Object)"  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_11 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_11, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public void ");
            CharSequence _setterName_2 = this.toSetterName((Data)d);
            _builder.append((Object)_setterName_2, "");
            _builder.append((Object)"(");
            String _typeName_2 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_2, "");
            _builder.append((Object)" ");
            String _nameLower_12 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_12, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _nameLower_13 = GenerationUtil.toNameLower((Data)d);
            _builder.append((Object)_nameLower_13, "\t");
            _builder.append((Object)" = ");
            DataType _dataType = d.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
                _builder.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder.append((Object)_simpleTypeName, "\t");
                _builder.append((Object)") (");
                String _nameLower_14 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_14, "\t");
                _builder.append((Object)" - ");
                String _typeName_3 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_3, "\t");
                _builder.append((Object)".MAX_VALUE)");
            } else {
                String _nameLower_15 = GenerationUtil.toNameLower((Data)d);
                _builder.append((Object)_nameLower_15, "\t");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"} ");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversion conversion) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"final double offset = ");
        double _offset = conversion.getOffset();
        _builder.append((Object)_offset, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"final double scalingFactor = ");
        double _scalingFactor = conversion.getScalingFactor();
        _builder.append((Object)_scalingFactor, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", scalingFactor, offset);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversionWithInterval conversion) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" oldMin = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        Interval _fromInterval = conversion.getFromInterval();
        double _lowerBound = _fromInterval.getLowerBound();
        _builder.append((Object)_lowerBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_1 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_1, "");
        _builder.append((Object)" oldMax = (");
        String _simpleTypeName_1 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_1, "");
        _builder.append((Object)") ");
        Interval _fromInterval_1 = conversion.getFromInterval();
        double _upperBound = _fromInterval_1.getUpperBound();
        _builder.append((Object)_upperBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_2 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_2, "");
        _builder.append((Object)" newMin = (");
        String _simpleTypeName_2 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_2, "");
        _builder.append((Object)") ");
        Interval _toInterval = conversion.getToInterval();
        double _lowerBound_1 = _toInterval.getLowerBound();
        _builder.append((Object)_lowerBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_3 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_3, "");
        _builder.append((Object)" newMax = (");
        String _simpleTypeName_3 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_3, "");
        _builder.append((Object)") ");
        Interval _toInterval_1 = conversion.getToInterval();
        double _upperBound_1 = _toInterval_1.getUpperBound();
        _builder.append((Object)_upperBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName_4 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_4, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(");
        String _nameLower_1 = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", oldMin, oldMax, newMin, newMax);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateSetter(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"/**");
            _builder_1.newLine();
            DataType _dataType = d.getDataType();
            boolean _isUnsigned = this.isUnsigned(_dataType);
            if (_isUnsigned) {
                _builder_1.append((Object)"* (Java has no option for unsigned data types, so if the data has an unsigned ");
                _builder_1.newLine();
                _builder_1.append((Object)"* data type the value is calculated by subtracting the max value from the ");
                _builder_1.newLine();
                _builder_1.append((Object)"* signed data type and adding it again, if it is used.)");
                _builder_1.newLine();
            }
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"* @param ");
            String _nameLower = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, " ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*\t\t\tthe ");
            String _nameLower_1 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_1, " ");
            _builder_1.append((Object)" to set");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*/");
            _builder_1.newLine();
            _builder_1.append((Object)"public void ");
            CharSequence _setterName = this.toSetterName((Data)d);
            _builder_1.append((Object)_setterName, "");
            _builder_1.append((Object)"(");
            String _typeName = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)" ");
            String _nameLower_2 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_2, "");
            _builder_1.append((Object)"){");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            _builder_1.append((Object)"this.");
            String _nameLower_3 = GenerationUtil.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_3, "\t");
            _builder_1.append((Object)" = ");
            DataType _dataType_1 = d.getDataType();
            boolean _isUnsigned_1 = this.isUnsigned(_dataType_1);
            if (_isUnsigned_1) {
                _builder_1.append((Object)"(");
                String _simpleTypeName = this.toSimpleTypeName((Data)d);
                _builder_1.append((Object)_simpleTypeName, "\t");
                _builder_1.append((Object)") (");
                String _nameLower_4 = GenerationUtil.toNameLower((Data)d);
                _builder_1.append((Object)_nameLower_4, "\t");
                _builder_1.append((Object)" - ");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder_1.append((Object)_typeName_1, "\t");
                _builder_1.append((Object)".MAX_VALUE)");
            } else {
                String _nameLower_5 = GenerationUtil.toNameLower((Data)d);
                _builder_1.append((Object)_nameLower_5, "\t");
            }
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"} ");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public CharSequence toSetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateJsonUnmarshal(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Alternative method responsible for deserializing the received");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* JSON-formatted L stage from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side in a JSON");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            format");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return L unmarshalled L structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _nameUpper = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" unmarshal");
        String _nameUpper_1 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)" (BufferedReader dataset) { ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Gson gson = new Gson();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"BufferedReader br = dataset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _nameUpper_2 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_2, "\t");
        _builder.append((Object)" obj = gson.fromJson(br, ");
        String _nameUpper_3 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_3, "\t");
        _builder.append((Object)".class);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return obj;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateByteArrayUnmarshal(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Method responsible for deserializing the received byte array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* representation of L from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side as a byte");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return L unmarshalled L structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws IOException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws ClassNotFoundException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _nameUpper = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" unmarshal");
        String _nameUpper_1 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)"(byte[] dataset) throws IOException, ClassNotFoundException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ByteArrayInputStream in = new ByteArrayInputStream(dataset);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ObjectInputStream ois = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ois = new ObjectInputStream(in);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Object o = ois.readObject();");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _nameUpper_2 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_2, "\t");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower, "\t");
        _builder.append((Object)" = (");
        String _nameUpper_3 = GenerationUtil.toNameUpper(d);
        _builder.append((Object)_nameUpper_3, "\t");
        _builder.append((Object)") o; // TODO: Ensure the type conversion is valid");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"in.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (in != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ois.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        String _nameLower_1 = GenerationUtil.toNameLower(d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }

    public CharSequence generateSetterBodyForMeasurementData(MeasurementData data, DataConversion conversion) {
        if (conversion instanceof LinearDataConversion) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
        }
        if (conversion instanceof LinearDataConversionWithInterval) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data, conversion).toString());
    }
}

