/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.c;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.factory.c.CDTOGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HeaderDTOGenerator
extends CDTOGenerator {
    private static Logger logger = Logger.getLogger(HeaderDTOGenerator.class);

    public HeaderDTOGenerator(List<DataSet> newDataSet) {
        super(newDataSet);
    }

    public CharSequence compile(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
        _builder.append((Object)_generateStruct, "");
        return _builder;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the data transfer object header-file.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet dataset : this.dataSets) {
            String _nameUpper = GenerationUtil.toNameUpper(dataset);
            String fileName = this.addFileExtensionTo(_nameUpper);
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
            filesToGenerate.put(fileName, _generateStruct);
            logger.info((Object)("File: " + fileName + " was generated in " + "./src-gen"));
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateStruct(String structName, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**\\brief\t\t");
        String _description = dataset.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.append((Object)"  ");
        _builder.newLineIfNotEmpty();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            CharSequence _generateDescription = this.generateDescription(data);
            _builder.append((Object)_generateDescription, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#ifndef ");
        String _upperCase = structName.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        String _upperCase_1 = structName.toUpperCase();
        _builder.append((Object)_upperCase_1, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include <stdint.h>");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _utilityFileName = GenerationUtil.getUtilityFileName((EObject)dataset, ".h");
        _builder.append((Object)_utilityFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _eContents_1 = dataset.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        for (NonMeasurementData data_1 : _filter_1) {
            boolean _and = false;
            boolean _isConstant = data_1.isConstant();
            if (!_isConstant) {
                _and = false;
            } else {
                boolean _equals;
                String _name = data_1.getName();
                _and = _equals = Objects.equal((Object)_name, (Object)"bDeviceType");
            }
            if (!_and) continue;
            _builder.append((Object)"#ifndef RADIO_DEVICE_TYPE_VALUE");
            _builder.newLine();
            _builder.append((Object)"#define RADIO_DEVICE_TYPE_VALUE ");
            String _value = data_1.getValue();
            _builder.append((Object)_value, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"#endif");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"#include \"bsp.h\"\t\t\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"typedef struct");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _eContents_2 = dataset.eContents();
        Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, Data.class);
        for (Data data_2 : _filter_2) {
            _builder.append((Object)"\t");
            CharSequence _generateVariable = this.generateVariable(data_2);
            _builder.append((Object)_generateVariable, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"} ");
        String _nameUpper = GenerationUtil.toNameUpper(dataset);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"extern ");
        String _nameUpper_1 = GenerationUtil.toNameUpper(dataset);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower(dataset);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateInitDatasetPrototype = this.generateInitDatasetPrototype(dataset);
        _builder.append((Object)_generateInitDatasetPrototype, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        EList _eContents_3 = dataset.eContents();
        Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, Data.class);
        for (Data data_3 : _filter_3) {
            CharSequence _generateGetterPrototype = this.generateGetterPrototype(data_3, dataset);
            _builder.append((Object)_generateGetterPrototype, "");
            _builder.newLineIfNotEmpty();
            CharSequence _generateSetterPrototype = this.generateSetterPrototype(data_3, dataset);
            _builder.append((Object)_generateSetterPrototype, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateInitDatasetPrototype(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @Initialization of the ");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" dataset");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void init");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"(");
        String _name_2 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateGetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterPrototype(MeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param pointer to dataset, ");
        String _name = d.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name);
        _builder.append((Object)_firstLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*\t\t\tthe ");
        String _name_1 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower((String)_name_1);
        _builder.append((Object)_firstLower_1, " ");
        _builder.append((Object)" to set");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"void set_");
        String _name_2 = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"_");
        String _name_3 = d.getName();
        String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_4 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"* p, ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name_5 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
        _builder.append((Object)_firstLower_2, "");
        _builder.append((Object)" );");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateGetterPrototype(NonMeasurementData d, DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* @return the ");
        String _name = d.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" get_");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"_");
        String _name_2 = d.getName();
        String _replaceAll = _name_2.replaceAll("[^a-zA-Z0-9]", "");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)"(");
        String _name_3 = dataset.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)"* p);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateSetterPrototype(NonMeasurementData d, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = d.isConstant();
        boolean bl = _not = !_isConstant;
        if (_not) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param pointer to dataset, ");
            String _name = d.getName();
            String _firstLower = StringExtensions.toFirstLower((String)_name);
            _builder.append((Object)_firstLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _name_1 = d.getName();
            String _firstLower_1 = StringExtensions.toFirstLower((String)_name_1);
            _builder.append((Object)_firstLower_1, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"void set_");
            String _name_2 = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper, "");
            _builder.append((Object)"_");
            String _name_3 = d.getName();
            String _replaceAll = _name_3.replaceAll("[^a-zA-Z0-9]", "");
            _builder.append((Object)_replaceAll, "");
            _builder.append((Object)"(");
            String _name_4 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_1, "");
            _builder.append((Object)"* p, ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name_5 = d.getName();
            String _firstLower_2 = StringExtensions.toFirstLower((String)_name_5);
            _builder.append((Object)_firstLower_2, "");
            _builder.append((Object)" );");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateDescription(MeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*\t\t\t\tMeasured in unit: ");
        Unit _unit = data.getUnit();
        _builder.append((Object)_unit, "");
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateDescription(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateVariable(MeasurementData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        return _builder;
    }

    protected CharSequence _generateVariable(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = data.isConstant();
        if (_isConstant) {
            _builder.append((Object)"const ");
        }
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = GenerationUtil.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        String _value = data.getValue();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_value);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)" = ");
            String _value_1 = data.getValue();
            _builder.append((Object)_value_1, "");
        }
        _builder.append((Object)";");
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String className) {
        return String.valueOf(className) + ".h";
    }

    public CharSequence generateGetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateGetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateGetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateSetterPrototype(Data d, DataSet dataset) {
        if (d instanceof MeasurementData) {
            return this._generateSetterPrototype((MeasurementData)d, dataset);
        }
        if (d instanceof NonMeasurementData) {
            return this._generateSetterPrototype((NonMeasurementData)d, dataset);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(d, dataset).toString());
    }

    public CharSequence generateDescription(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateDescription((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateDescription((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    public CharSequence generateVariable(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateVariable((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateVariable((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }
}

