/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.converters;

import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;

public class StringHexConverter
implements IValueConverter<String> {
    private static final String HEX_INDICATOR = "0x";
    private static final String QUOTATION_MARK = "\"";
    private static final int HEX_BASE = 16;
    private static final int MAX_8_BIT_VALUE = 255;
    private static final int MAX_16_BIT_VALUE = 65535;

    public String toValue(String string, INode node) throws ValueConverterException {
        if (string == null || string == "") {
            return null;
        }
        if (!(string = string.replaceAll(QUOTATION_MARK, "")).contains(HEX_INDICATOR) || !(node.getSemanticElement() instanceof NonMeasurementData)) {
            return string;
        }
        string = string.replaceAll(HEX_INDICATOR, "");
        NonMeasurementData data = (NonMeasurementData)node.getSemanticElement();
        switch (data.getDataType().getValue()) {
            case 0: {
                Byte value = Byte.parseByte(string, 16);
                return ((Object)value).toString();
            }
            case 1: {
                Integer value = Integer.parseUnsignedInt(string, 16) & 0xFF;
                return ((Object)value).toString();
            }
            case 2: {
                Short value = Short.parseShort(string, 16);
                return ((Object)value).toString();
            }
            case 3: {
                Integer value = Integer.parseUnsignedInt(string, 16) & 0xFFFF;
                return ((Object)value).toString();
            }
            case 4: {
                Integer value = Integer.parseInt(string, 16);
                return ((Object)value).toString();
            }
            case 5: {
                Integer value = Integer.parseUnsignedInt(string, 16);
                return ((Object)value).toString();
            }
            case 6: {
                Long value = Long.parseLong(string, 16);
                return ((Object)value).toString();
            }
            case 7: {
                Long value = Long.parseUnsignedLong(string, 16);
                return ((Object)value).toString();
            }
            case 8: {
                Integer value = Integer.parseInt(string, 16);
                return ((Object)value).toString();
            }
            case 9: {
                Long value = Long.parseLong(string, 16);
                return ((Object)value).toString();
            }
        }
        throw new ValueConverterException("Data type not supported", node, null);
    }

    public String toString(String value) throws ValueConverterException {
        return value;
    }
}

