package de.fzi.sensidl.language.generator.factory.java

import de.fzi.sensidl.design.sensidl.dataRepresentation.Data
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData
import de.fzi.sensidl.language.generator.SensIDLConstants
import de.fzi.sensidl.language.generator.SensIDLOutputConfigurationProvider
import de.fzi.sensidl.language.generator.factory.IDTOGenerator
import java.util.ArrayList
import java.util.HashMap
import java.util.List
import org.apache.log4j.Logger
import org.eclipse.emf.ecore.EObject
import de.fzi.sensidl.design.sensidl.SensorInterface

/**
 * Java code generator for the SensIDL Model. 
 * Code will be generated by running the {@code generate()}-Method
 * 
 * @author Sven Eckhardt
 * @author Pawel Bielski 
 * 
 */
 
class JavaDTOGenerator implements IDTOGenerator {
	private static Logger logger = Logger.getLogger(JavaDTOGenerator)
	
	private boolean createEmptyConstructor = true

	private List<DataSet> dataSet
	
	private boolean createProject = false
	
	new(List<DataSet> newDataSet) {
		this.dataSet = newDataSet
	}
	
	new(List<DataSet> newDataSet,boolean createProject) {
		this.dataSet = newDataSet
		this.createProject = createProject
	}

	/**
	 * Generates the .java Files
	 */
	override generate() {
		logger.info("Start with code-generation of a java data transfer object.")
		val filesToGenerate = new HashMap
		
		if (createProject) {
			for (d : this.dataSet) {
				filesToGenerate.put("src/de/fzi/sensidl/" + this.dataSet.get(0).eContents.filter(Data).get(0).eContainer.getSensorInterfaceName +"/" + addFileExtensionTo(d.toNameUpper), generateClassBody(d.toNameUpper, d))
				logger.info("File: " + addFileExtensionTo(d.toNameUpper) + " was generated in " + SensIDLOutputConfigurationProvider.SENSIDL_GEN)
			}
		
		} else{
			for (d : this.dataSet) {
				filesToGenerate.put(addFileExtensionTo(d.toNameUpper), generateClassBody(d.toNameUpper, d))
				logger.info("File: " + addFileExtensionTo(d.toNameUpper) + " was generated in " + SensIDLOutputConfigurationProvider.SENSIDL_GEN)
			}
		}
		
		filesToGenerate
	}

	/**
	 * Generates the Classes
	 */
	def generateClassBody(String className, DataSet d) {
		'''
			«IF createProject»
			package de.fzi.sensidl.«d.eContents.filter(Data).get(0).eContainer.getSensorInterfaceName»;
			 
			«ENDIF» 
			import java.io.BufferedReader;
			import java.io.ByteArrayInputStream;
			import java.io.IOException;
			import java.io.ObjectInputStream;
			import java.io.Serializable;
			import com.google.gson.Gson;
			 
			/**
			 * Data transfer object for «className»
			 *
			 * @generated
			 */
			class «className» {
				
				private static final long serialVersionUID = 1L;
				
				«FOR data : d.eContents.filter(NonMeasurementData)»
					«generateDataFields(data)»
				«ENDFOR»
				«FOR data : d.eContents.filter(MeasurementData)»
					«generateDataFields(data)»
				«ENDFOR»
				
				/**
				 * Constructor for the Data transfer object
				 */
				public «className» («d.generateConstructorArguments»){  
					«FOR data : d.eContents.filter(MeasurementData)»
						this.«data.toNameLower» = «data.toNameLower»;
					«ENDFOR»
					«FOR data : d.eContents.filter(NonMeasurementData)»
						«IF !data.constant»
							this.«data.toNameLower» = «data.toNameLower»;
						«ENDIF»
					«ENDFOR»
					
				}
				«IF createEmptyConstructor»
				/**
				 * empty constructor for the Data transfer object
				 */
				public «className»(){
				
				}
				«ENDIF»
				
				«FOR data : d.eContents.filter(MeasurementData)»
					«generateGetter(data)»
					
					«generateSetter(data)»
					
				«ENDFOR»
				
				«FOR data : d.eContents.filter(NonMeasurementData)»
					«generateGetter(data)»
					
					«generateSetter(data)»
					
				«ENDFOR»
					
				«d.generateJsonUnmarshal»	
				
				«d.generateByteArrayUnmarshal»	
			}
		 '''
	}

	/**
	 * Generates the fields for the measurement data
	 */
	def generateDataFields(MeasurementData d) {
		'''
			 
			/*
			«IF d.description != null» * «d.description»
			 * 
			«ENDIF» 
			 * Unit: «d.unit»
			 */
			private «d.toTypeName» «d.toNameLower»;
		'''
	}

	/**
	 * Generates the fields for the non measurement data
	 */
	def generateDataFields(NonMeasurementData d) {
		if (d.constant) {
			'''
				 
				«IF d.description != null»
				 /*
				  *«d.description»
				  */
				«ENDIF» 
				private static final «d.toTypeName» «d.name.toUpperCase» = «d.value»;
			'''
		} else {
			'''
				 
				«IF d.description != null»
				 /*
				  *«d.description»
				  */
				«ENDIF» 
				private «d.toTypeName» «d.toNameLower»;
			'''
		}

	}


	/**
	 * returns the appropriate type name 
	 */
	override toTypeName(Data d) {
		return switch (d.dataType) {
			case INT8: Byte.name
			case UINT8: Byte.name
			case INT16: Short.name
			case UINT16: Short.name
			case INT32: Integer.name
			case UINT32: Integer.name
			case INT64: Long.name
			case UINT64: Long.name
			case FLOAT: Float.name
			case DOUBLE: Double.name
		}
	}

	/**
	 * returns the appropriate simple type name suitable for casting
	 */
	def toSimpleTypeName(Data d){
		return d.toTypeName.substring(d.toTypeName.lastIndexOf('.')+1).toLowerCase();
	}

	/**
	 * Generates the Constructor arguments
	 */
	def generateConstructorArguments(DataSet d) {
		// create an ArrayList with all data that is not a constant NonMeasurementData (which will not be constructor arguments)
		var dataList = new ArrayList<Data>();

		for (data : d.eContents.filter(Data)) {
			if (data instanceof NonMeasurementData) {
				var nmdata = data as NonMeasurementData
				if (!nmdata.constant) {
					dataList.add(data)
				}
			} else {
				dataList.add(data)
			}
		}

		if (dataList.size > 0) {
			var firstElement = dataList.get(0).toTypeName + " " + dataList.get(0).toNameLower
			dataList.remove(0)
			'''«firstElement»«FOR data : dataList», «data.toTypeName» «data.toNameLower»«ENDFOR»'''
		} else {
			createEmptyConstructor = false;
			''''''
		}
	}

	/** 
	 * Generates the Getter Method for the measurement data
	 */
	def generateGetter(MeasurementData d) {
		'''
			/**
			 * @return the «d.toNameLower»
			 */
			public «d.toTypeName» «d.toGetterName»(){
				return this.«d.toNameLower»;
			}
		'''
	}

	/** 
	 * Generates the Getter Method for the non measurement data
	 */
	def generateGetter(NonMeasurementData d) {
		'''
			/**
			 * @return the «d.toNameLower»
			 */
			public «d.toTypeName» «d.toGetterName»(){
				return this.«IF d.constant»«d.name.toUpperCase»«ELSE»«d.toNameLower»«ENDIF»;
			}
		'''
	}

	def toGetterName(Data d) {
		'''get«d.name.replaceAll("[^a-zA-Z0-9]", "").toFirstUpper»'''
	}

	/** 
	 * Generates the Setter Method for the measurement data
	 */
	def generateSetter(MeasurementData d) {
			'''
				«IF d.adjustments.empty == false»
				
				«FOR dataAdj : d.adjustments»
				«IF dataAdj instanceof DataRange»
				/**
				 * @param «d.toNameLower»
				 *			the «d.toNameLower» to set
				 */
				public void «d.toSetterName»(«d.toTypeName» «d.toNameLower»){
					if («d.toNameLower» >= «dataAdj.range.lowerBound» && «d.toNameLower» <= «dataAdj.range.upperBound»)
						this.«d.toNameLower» = «d.toNameLower»;
					else
						throw new IllegalArgumentException("value is out of defined range");	
				} 
				«ELSEIF dataAdj instanceof DataConversion»	
				
				/**
				* @param «d.toNameLower»
				*			the «d.toNameLower» to set
				*/
				public void «d.toSetterName»(«d.toTypeName» «d.toNameLower») {
					try {
						«d.generateSetterBodyForMeasurementData(dataAdj as DataConversion)»
					} catch (IllegalArgumentException e) {
						//Do something
					}
				}
«««				«IF dataAdj instanceof DataConversion»						
«««					«IF dataAdj instanceof LinearDataConversion»
«««					/**
«««					 * @param «d.toNameLower»  
«««					 *			the «d.toNameLower» to set
«««					 */
«««					public void «d.toSetterName»(«d.toTypeName» «d.toNameLower»){
«««						
«««						this.«d.toNameLower» =  «d.toNameLower» * («d.toSimpleTypeName») «dataAdj.scalingFactor» + («d.toSimpleTypeName») «dataAdj.offset»;
«««					} 
«««					«ELSE»
«««						«IF dataAdj instanceof LinearDataConversionWithInterval»
«««						/**
«««						 * @param «d.toNameLower»  
«««						 *			the «d.toNameLower» to set
«««						 */
«««						public void «d.toSetterName»(«d.toTypeName» «d.toNameLower»){
«««							if («d.toNameLower» >= «dataAdj.fromInterval.lowerBound» && «d.toNameLower» <= «dataAdj.fromInterval.upperBound»){												
«««								
«««								«d.toTypeName» oldMin = («d.toSimpleTypeName») «dataAdj.fromInterval.lowerBound»;
«««								«d.toTypeName» oldMax = («d.toSimpleTypeName») «dataAdj.fromInterval.upperBound»;
«««								«d.toTypeName» newMin = («d.toSimpleTypeName») «dataAdj.toInterval.lowerBound»;
«««								«d.toTypeName» newMax = («d.toSimpleTypeName») «dataAdj.toInterval.upperBound»;
«««								
«««								this.«d.toNameLower» = («d.toSimpleTypeName») ((((«d.toNameLower» - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);
«««							}
«««							else
«««								throw new IllegalArgumentException("value is out of defined source Interval");
«««						} 		
«««						«ENDIF»
«««					«ENDIF»
				«ENDIF»				
				«ENDFOR»
					
				«ELSE»
					/**
					 * @param «d.toNameLower»  
					 *			the «d.toNameLower» to set
					 */
					public void «d.toSetterName»(«d.toTypeName» «d.toNameLower»){
						
						this.«d.toNameLower» = «d.toNameLower»;
					} 
				«ENDIF»
				''' 

	}
	
	dispatch def generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversion conversion) {
		'''
			final double offset = «conversion.offset»;
			final double scalingFactor = «conversion.scalingFactor»;
			
			this.«data.toNameLower» = («data.toSimpleTypeName») «data.eContainer.getSensorInterfaceName»«SensIDLConstants.UTILITY_CLASS_NAME».«SensIDLConstants.LINEAR_CONVERSION_METHOD_NAME»(«data.toNameLower», scalingFactor, offset);
		'''
	}
	
	dispatch def generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversionWithInterval conversion) {
		'''
			«data.toTypeName» oldMin = («data.toSimpleTypeName») «conversion.fromInterval.lowerBound»;
			«data.toTypeName» oldMax = («data.toSimpleTypeName») «conversion.fromInterval.upperBound»;
			«data.toTypeName» newMin = («data.toSimpleTypeName») «conversion.toInterval.lowerBound»;
			«data.toTypeName» newMax = («data.toSimpleTypeName») «conversion.toInterval.upperBound»;
			
			this.«data.toNameLower» = («data.toSimpleTypeName») «data.eContainer.getSensorInterfaceName»«SensIDLConstants.UTILITY_CLASS_NAME».«SensIDLConstants.LINEAR_CONVERSION_WITH_INTERVAL_METHOD_NAME»(«data.toNameLower», oldMin, oldMax, newMin, newMax);
		'''
	}

	/** 
	 * Generates the Setter Method for the non measurement data
	 */
	def generateSetter(NonMeasurementData d) {
		if (d.constant) {
			'''
				// no setter for constant value
			'''
		} else {
			'''
				/**
				 * @param «d.toNameLower»
				 *			the «d.toNameLower» to set
				 */
				public void «d.toSetterName»(«d.toTypeName» «d.toNameLower»){
					this.«d.toNameLower» = «d.toNameLower»;
				} 
			'''
		}
	}

	def toSetterName(Data d) {
		'''set«d.name.replaceAll("[^a-zA-Z0-9]", "").toFirstUpper»'''
	}


	/**
	 * @return the name of the data with a lower first letter
	 */
	def toNameLower(Data d) {
		d.name.toFirstLower
	}

	/**
	 * @return the name of the DataSet with a lower first letter
	 */
	def toNameLower(DataSet d) {
		d.name.toFirstLower
	}

	/**
	 * @return the name of the data with an upper first letter 
	 */
	def toNameUpper(Data d) {
		d.name.toFirstUpper
	}

	/**
	 * @return the name of the DataSet with an upper first letter
	 */
	def toNameUpper(DataSet d) {
		d.name.toFirstUpper
	}
	
	def generateJsonUnmarshal(DataSet d){
		'''
		/**
		 * Alternative method responsible for deserializing the received
		 * JSON-formatted L stage from sensor.
		 * 
		 * @param dataset
		 *            the dataset to unmarshall incoming from sensor side in a JSON
		 *            format
		 * @return L unmarshalled L structure
		 */
		public «d.toNameUpper» unmarshal«d.toNameUpper» (BufferedReader dataset) { 
			
			Gson gson = new Gson();
			BufferedReader br = dataset;
			«d.toNameUpper» obj = gson.fromJson(br, «d.toNameUpper».class);
			return obj;
		}
		'''
	}
	
	def generateByteArrayUnmarshal(DataSet d){
		'''
		/**
		 * Method responsible for deserializing the received byte array
		 * representation of L from sensor.
		 * 
		 * @param dataset
		 *            the dataset to unmarshall incoming from sensor side as a byte
		 *            array
		 * @return L unmarshalled L structure
		 * @throws IOException
		 * @throws ClassNotFoundException
		 */
		public «d.toNameUpper» unmarshal«d.toNameUpper»(byte[] dataset) throws IOException, ClassNotFoundException {
			
			ByteArrayInputStream in = new ByteArrayInputStream(dataset);
			ObjectInputStream ois = null;
			ois = new ObjectInputStream(in);
			Object o = ois.readObject();
			«d.toNameUpper» «d.toNameLower» = («d.toNameUpper») o; // TODO: Ensure the type conversion is valid
			in.close();
			if (in != null) {
				ois.close();
			}
			return «d.toNameLower»;
		}
		'''
	}
	
	override addFileExtensionTo(String ClassName) {
		return ClassName + SensIDLConstants.JAVA_EXTENSION
	}
	
	/**
	 * get the sensorInterface Name
	 */
	def String getSensorInterfaceName(EObject currentElement) {
		if (currentElement instanceof SensorInterface) {
			return (currentElement as SensorInterface).name
		}
		return currentElement.eContainer.sensorInterfaceName
	}

}