/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.javascript;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaScriptDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(JavaScriptDTOGenerator.class);
    private List<DataSet> dataSet;

    public JavaScriptDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a JavaScript data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet d : this.dataSet) {
            String _nameUpper = this.toNameUpper(d);
            String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
            String _nameUpper_1 = this.toNameUpper(d);
            CharSequence _generateClass = this.generateClass(_nameUpper_1, d);
            filesToGenerate.put(_addFileExtensionTo, _generateClass);
            String _nameUpper_2 = this.toNameUpper(d);
            String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
            String _plus = "File: " + _addFileExtensionTo_1;
            String _plus_1 = String.valueOf(_plus) + " was generated in ";
            String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
            logger.info((Object)_plus_2);
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClass(String name, DataSet dataset) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        TreeIterator _eAllContents = dataset.eAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_eAllContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, NonMeasurementData.class);
        NonMeasurementData nmdatalast = (NonMeasurementData)IterableExtensions.last((Iterable)_filter);
        TreeIterator _eAllContents_1 = dataset.eAllContents();
        Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)_eAllContents_1);
        Iterable _filter_1 = Iterables.filter((Iterable)_iterable_1, MeasurementData.class);
        MeasurementData mdatalast = (MeasurementData)IterableExtensions.last((Iterable)_filter_1);
        StringConcatenation _builder = new StringConcatenation();
        String _description = dataset.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)"/* ");
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.append((Object)" */");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"var ");
        _builder.append((Object)name, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.newLine();
        TreeIterator _eAllContents_2 = dataset.eAllContents();
        Iterable _iterable_2 = IteratorExtensions.toIterable((Iterator)_eAllContents_2);
        Iterable _filter_2 = Iterables.filter((Iterable)_iterable_2, NonMeasurementData.class);
        for (NonMeasurementData nmdata : _filter_2) {
            boolean _notEquals_4;
            boolean _notEquals_3;
            boolean _isConstant = nmdata.isConstant();
            if (_isConstant) {
                String _description_2;
                boolean _notEquals_2;
                boolean _notEquals_1;
                _builder.append((Object)"\t");
                _builder.append((Object)"_");
                String _name = nmdata.getName();
                String _upperCase = _name.toUpperCase();
                _builder.append((Object)_upperCase, "\t");
                String _value = nmdata.getValue();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_value, null);
                if (_notEquals_1) {
                    _builder.append((Object)" : ");
                    String _value_1 = nmdata.getValue();
                    _builder.append((Object)_value_1, "\t");
                    _builder.append((Object)",");
                }
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_description_2 = nmdata.getDescription()), null);
                if (_notEquals_2) {
                    _builder.append((Object)"/*");
                    String _description_3 = nmdata.getDescription();
                    _builder.append((Object)_description_3, "\t");
                    _builder.append((Object)" */");
                }
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"_");
            String _nameLower = this.toNameLower((Data)nmdata);
            _builder.append((Object)_nameLower, "\t");
            String _value_2 = nmdata.getValue();
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)_value_2, null);
            if (_notEquals_3) {
                _builder.append((Object)" : ");
                String _value_3 = nmdata.getValue();
                _builder.append((Object)_value_3, "\t");
            } else {
                _builder.append((Object)" : 0");
            }
            _builder.append((Object)",");
            String _description_4 = nmdata.getDescription();
            boolean bl5 = _notEquals_4 = !Objects.equal((Object)_description_4, null);
            if (_notEquals_4) {
                _builder.append((Object)"/*");
                String _description_5 = nmdata.getDescription();
                _builder.append((Object)_description_5, "\t");
                _builder.append((Object)" */");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        TreeIterator _eAllContents_3 = dataset.eAllContents();
        Iterable _iterable_3 = IteratorExtensions.toIterable((Iterator)_eAllContents_3);
        Iterable _filter_3 = Iterables.filter((Iterable)_iterable_3, MeasurementData.class);
        for (MeasurementData mdata : _filter_3) {
            _builder.append((Object)"\t");
            _builder.append((Object)"_");
            String _nameLower_1 = this.toNameLower((Data)mdata);
            _builder.append((Object)_nameLower_1, "\t");
            _builder.append((Object)" : 0, /*");
            String _description_6 = mdata.getDescription();
            _builder.append((Object)_description_6, "\t");
            _builder.append((Object)" Measured in Unit: ");
            Unit _unit = mdata.getUnit();
            _builder.append((Object)_unit, "\t");
            _builder.append((Object)" */ ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        TreeIterator _eAllContents_4 = dataset.eAllContents();
        Iterable _iterable_4 = IteratorExtensions.toIterable((Iterator)_eAllContents_4);
        Iterable _filter_4 = Iterables.filter((Iterable)_iterable_4, NonMeasurementData.class);
        for (NonMeasurementData data : _filter_4) {
            boolean _not;
            _builder.append((Object)"\t");
            CharSequence _generateGetter = this.generateGetter(data);
            _builder.append((Object)_generateGetter, "\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateSetter = this.generateSetter(data);
            _builder.append((Object)_generateSetter, "\t");
            boolean _isConstant_1 = data.isConstant();
            boolean bl6 = _not = !_isConstant_1;
            if (_not) {
                boolean _notEquals_5;
                boolean _not_1;
                boolean _or = false;
                boolean _equals = data.equals(nmdatalast);
                boolean bl7 = _not_1 = !_equals;
                _or = _not_1 ? true : (_notEquals_5 = !Objects.equal((Object)mdatalast, null));
                if (_or) {
                    _builder.append((Object)",");
                }
            }
            _builder.newLineIfNotEmpty();
        }
        TreeIterator _eAllContents_5 = dataset.eAllContents();
        Iterable _iterable_5 = IteratorExtensions.toIterable((Iterator)_eAllContents_5);
        Iterable _filter_5 = Iterables.filter((Iterable)_iterable_5, MeasurementData.class);
        for (MeasurementData data_1 : _filter_5) {
            boolean _not_2;
            _builder.append((Object)"\t");
            CharSequence _generateGetter_1 = this.generateGetter(data_1);
            _builder.append((Object)_generateGetter_1, "\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateSetter_1 = this.generateSetter(data_1);
            _builder.append((Object)_generateSetter_1, "\t");
            boolean _equals_1 = data_1.equals(mdatalast);
            boolean bl8 = _not_2 = !_equals_1;
            if (_not_2) {
                _builder.append((Object)",");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateGetter(MeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)" : function(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this._");
        String _nameLower_1 = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        return _builder;
    }

    public CharSequence generateGetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)" : function(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this._");
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
        } else {
            String _nameLower_1 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, "\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        return _builder;
    }

    public CharSequence toGetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateSetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_1 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            CharSequence _setterName = this.toSetterName((Data)d);
            _builder.append((Object)_setterName, "");
            _builder.append((Object)" : function(");
            String _nameLower_2 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_2, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"this._");
            String _nameLower_3 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_3, "\t");
            _builder.append((Object)" = ");
            String _nameLower_4 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_4, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"} ");
            _builder.newLine();
            _builder.append((Object)"\t");
        }
        _builder.append((Object)"\t");
        return _builder;
    }

    public CharSequence generateSetter(MeasurementData d) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_1 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    CharSequence _setterName = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName, "");
                    _builder.append((Object)" : function(");
                    String _nameLower_2 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _nameLower_3 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _nameLower_4 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this._");
                    String _nameLower_5 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "\t\t");
                    _builder.append((Object)" = ");
                    String _nameLower_6 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"alert(\"value ");
                    String _nameLower_7 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_7, "\t\t");
                    _builder.append((Object)" is out of defined range\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                if (dataAdj instanceof LinearDataConversion) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower_8 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_8, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_9 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_9, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    CharSequence _setterName_1 = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName_1, "");
                    _builder.append((Object)" : function(");
                    String _nameLower_10 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_10, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"this._");
                    String _nameLower_11 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_11, "\t");
                    _builder.append((Object)" = ");
                    String _nameLower_12 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_12, "\t");
                    _builder.append((Object)" *  ");
                    double _scalingFactor = ((LinearDataConversion)dataAdj).getScalingFactor();
                    _builder.append((Object)_scalingFactor, "\t");
                    _builder.append((Object)" +  ");
                    double _offset = ((LinearDataConversion)dataAdj).getOffset();
                    _builder.append((Object)_offset, "\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}  ");
                    _builder.newLine();
                    continue;
                }
                if (!(dataAdj instanceof LinearDataConversionWithInterval)) continue;
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* @param ");
                String _nameLower_13 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_13, " ");
                _builder.append((Object)"  ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*\t\t\tthe ");
                String _nameLower_14 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_14, " ");
                _builder.append((Object)" to set");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                CharSequence _setterName_2 = this.toSetterName((Data)d);
                _builder.append((Object)_setterName_2, "");
                _builder.append((Object)" : function(");
                String _nameLower_15 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_15, "");
                _builder.append((Object)"){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (");
                String _nameLower_16 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_16, "\t");
                _builder.append((Object)" >= ");
                Interval _fromInterval = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_1 = _fromInterval.getLowerBound();
                _builder.append((Object)_lowerBound_1, "\t");
                _builder.append((Object)" && ");
                String _nameLower_17 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_17, "\t");
                _builder.append((Object)" <= ");
                Interval _fromInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_1 = _fromInterval_1.getUpperBound();
                _builder.append((Object)_upperBound_1, "\t");
                _builder.append((Object)"){\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var oldMin =  ");
                Interval _fromInterval_2 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _lowerBound_2 = _fromInterval_2.getLowerBound();
                _builder.append((Object)_lowerBound_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var oldMax =  ");
                Interval _fromInterval_3 = ((LinearDataConversionWithInterval)dataAdj).getFromInterval();
                double _upperBound_2 = _fromInterval_3.getUpperBound();
                _builder.append((Object)_upperBound_2, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var newMin =  ");
                Interval _toInterval = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _lowerBound_3 = _toInterval.getLowerBound();
                _builder.append((Object)_lowerBound_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"var newMax =  ");
                Interval _toInterval_1 = ((LinearDataConversionWithInterval)dataAdj).getToInterval();
                double _upperBound_3 = _toInterval_1.getUpperBound();
                _builder.append((Object)_upperBound_3, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"this._");
                String _nameLower_18 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_18, "\t\t");
                _builder.append((Object)" =  ((((");
                String _nameLower_19 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_19, "\t\t");
                _builder.append((Object)" - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"alert(\"value ");
                String _nameLower_20 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_20, "\t\t");
                _builder.append((Object)" is out of defined source Interval\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"} \t\t");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower_21 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_21, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_22 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_22, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            CharSequence _setterName_3 = this.toSetterName((Data)d);
            _builder.append((Object)_setterName_3, "");
            _builder.append((Object)" : function(");
            String _nameLower_23 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_23, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"this._");
            String _nameLower_24 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_24, "\t");
            _builder.append((Object)" = ");
            String _nameLower_25 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_25, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"} ");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
        }
        return _builder;
    }

    public CharSequence toSetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public String toNameLower(Data d) {
        String _name = d.getName();
        return StringExtensions.toFirstLower((String)_name);
    }

    public String toNameLower(DataSet d) {
        String _name = d.getName();
        return StringExtensions.toFirstLower((String)_name);
    }

    public String toNameUpper(Data d) {
        String _name = d.getName();
        return StringExtensions.toFirstUpper((String)_name);
    }

    public String toNameUpper(DataSet d) {
        String _name = d.getName();
        return StringExtensions.toFirstUpper((String)_name);
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".js";
    }

    @Override
    public String toTypeName(Data data) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }
}

