/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.language.generator.factory.IUtilityGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaUtilityGenerator
implements IUtilityGenerator {
    private static Logger logger = Logger.getLogger(JavaUtilityGenerator.class);
    private List<MeasurementData> data;
    private boolean createProject = false;

    public JavaUtilityGenerator(List<MeasurementData> newData) {
        this.data = newData;
    }

    public JavaUtilityGenerator(List<MeasurementData> newData, boolean createProject) {
        this.data = newData;
        this.createProject = createProject;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the java utility class.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        MeasurementData _get = this.data.get(0);
        EObject _eContainer = _get.eContainer();
        String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
        String fileName = String.valueOf(_sensorInterfaceName) + "Utility";
        if (this.createProject) {
            MeasurementData _get_1 = this.data.get(0);
            EObject _eContainer_1 = _get_1.eContainer();
            String _sensorInterfaceName_1 = this.getSensorInterfaceName(_eContainer_1);
            String _plus = "src/de/fzi/sensidl/" + _sensorInterfaceName_1;
            String _plus_1 = String.valueOf(_plus) + "/";
            String _addFileExtensionTo = this.addFileExtensionTo(fileName);
            String _plus_2 = String.valueOf(_plus_1) + _addFileExtensionTo;
            CharSequence _generateClassBody = this.generateClassBody(fileName);
            filesToGenerate.put(_plus_2, _generateClassBody);
        } else {
            String _addFileExtensionTo_1 = this.addFileExtensionTo(fileName);
            CharSequence _generateClassBody_1 = this.generateClassBody(fileName);
            filesToGenerate.put(_addFileExtensionTo_1, _generateClassBody_1);
        }
        String _addFileExtensionTo_2 = this.addFileExtensionTo(fileName);
        String _plus_3 = "File: " + _addFileExtensionTo_2;
        String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
        String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
        logger.info((Object)_plus_5);
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public String getSensorInterfaceName(EObject currentElement) {
        if (currentElement instanceof SensorInterface) {
            return ((SensorInterface)currentElement).getName();
        }
        EObject _eContainer = currentElement.eContainer();
        return this.getSensorInterfaceName(_eContainer);
    }

    public CharSequence generateClassBody(String className) {
        StringConcatenation _builder = new StringConcatenation();
        if (this.createProject) {
            _builder.append((Object)"package de.fzi.sensidl.");
            MeasurementData _get = this.data.get(0);
            EObject _eContainer = _get.eContainer();
            String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
            _builder.append((Object)_sensorInterfaceName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.newLine();
        }
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data transfer object for ");
        _builder.append((Object)className, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        Functions.Function1<MeasurementData, Boolean> _function = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversion;
            }
        };
        boolean _exists = IterableExtensions.exists(this.data, (Functions.Function1)_function);
        if (_exists) {
            _builder.append((Object)"\t");
            CharSequence _generateLinearDataConversionMethod = this.generateLinearDataConversionMethod();
            _builder.append((Object)_generateLinearDataConversionMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generateGetMaxValueOfMethod = this.generateGetMaxValueOfMethod();
            _builder.append((Object)_generateGetMaxValueOfMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        Functions.Function1<MeasurementData, Boolean> _function_1 = new Functions.Function1<MeasurementData, Boolean>(){

            public Boolean apply(MeasurementData data) {
                EList _adjustments = data.getAdjustments();
                DataAdjustment _get = (DataAdjustment)_adjustments.get(0);
                return _get instanceof LinearDataConversionWithInterval;
            }
        };
        boolean _exists_1 = IterableExtensions.exists(this.data, (Functions.Function1)_function_1);
        if (_exists_1) {
            _builder.append((Object)"\t");
            CharSequence _generateLinearDataConversionWithIntervalMethod = this.generateLinearDataConversionWithIntervalMethod();
            _builder.append((Object)_generateLinearDataConversionWithIntervalMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateLinearDataConversionMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" scalingFactor, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" offset) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the linear-function f(x) = m*x + b");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"double calculatedValue = (scalingFactor * independentVariable.doubleValue()) + offset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (getMaxValueOf(independentVariable) >= calculatedValue) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return calculatedValue;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than the range of the data type.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateLinearDataConversionWithIntervalMethod() {
        StringConcatenation _xblockexpression = null;
        String dataType = "double";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public static ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" ");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(Number independentVariable, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" x_min, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" x_max, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" y_min, ");
        _builder.append((Object)"double", "");
        _builder.append((Object)" y_max) throws IllegalArgumentException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Conversion is calculated by the mapping rule f(x) = (x_max - x_min)*((x - y_min)/(y_max - y_min))");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (independentVariable.doubleValue() < x_min || independentVariable.doubleValue() > x_max) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"The value is larger than specified minimal and maximal range.\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (y_max - y_min)*((independentVariable.doubleValue() - x_min)/(x_max - x_min));");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateGetMaxValueOfMethod() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private static double getMaxValueOf(Number number) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (number instanceof Byte) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Byte.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Short) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Short.MAX_VALUE;\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Integer) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Integer.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Long) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Long.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (number instanceof Float) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Float.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return Double.MAX_VALUE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }
}

