/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class JavaPluginProjectGenerator {
    private static String projectName;

    public static IProject createPluginProject() throws CoreException, IOException {
        IProject project = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            final boolean[] result = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)new Shell(), (String)("'" + projectName + "'" + "already exists"), (String)("Warning: '" + projectName + "' already exists. Should this project be deleted?"));
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            } else {
                return null;
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projectDescription.setLocation(null);
        project.create(projectDescription, null);
        projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
        project.open(null);
        project.setDescription(projectDescription, null);
        IFolder srcFolder = project.getFolder("src");
        if (!srcFolder.exists()) {
            srcFolder.create(false, true, null);
        }
        Bundle bundle = Platform.getBundle((String)"com.google.gson");
        Path path = new Path("");
        URL absoluteFileURL = FileLocator.resolve((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
        java.nio.file.Path gsonSource = Paths.get(absoluteFileURL.toString().replaceFirst("jar:file:/", "").replace("!/", ""), new String[0]);
        java.nio.file.Path gsonDestination = Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation() + "/" + projectName + "/", new String[0]);
        Files.copy(gsonSource, gsonDestination.resolve(gsonSource.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        classpathEntries.add(0, srcClasspathEntry);
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5")));
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
        File file = new File(gsonDestination.resolve(gsonSource.getFileName()).toString());
        classpathEntries.add(JavaCore.newLibraryEntry((IPath)Path.fromOSString((String)file.getAbsolutePath()), null, null));
        javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
        javaProject.setOutputLocation((IPath)new Path("/" + projectName + "/bin"), null);
        JavaPluginProjectGenerator.createManifest(projectName, project);
        JavaPluginProjectGenerator.createBuildProperties(project, "src");
        return project;
    }

    public static void setProjectName(String project) {
        projectName = project;
    }

    public static String getProjectName() {
        return projectName;
    }

    private static void createManifest(String projectName, IProject project) throws CoreException, IOException {
        StringBuilder content = new StringBuilder("Manifest-Version: 1.0\n");
        content.append("Bundle-ManifestVersion: 2\n");
        content.append("Bundle-Name: " + projectName + "\n");
        content.append("Bundle-SymbolicName: " + projectName.replaceAll(" ", "") + "; singleton:=true\n");
        content.append("Bundle-Version: 1.0.0.qualifier\n");
        content.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, null);
        JavaPluginProjectGenerator.createFile("MANIFEST.MF", (IContainer)metaInf, content.toString());
    }

    private static void createBuildProperties(IProject project, String srcFolder) throws CoreException, IOException {
        StringBuilder content = new StringBuilder("source.. = " + srcFolder + "/");
        content.append("\n");
        content.append("bin.includes = META-INF/,\\\n.");
        JavaPluginProjectGenerator.createFile("build.properties", (IContainer)project, content.toString());
    }

    private static IFile createFile(String name, IContainer container, String content) throws CoreException, IOException {
        IFile file = container.getFile((IPath)new Path(name));
        JavaPluginProjectGenerator.createDirectory(file.getParent());
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, null);
        } else {
            file.create((InputStream)stream, true, null);
        }
        ((InputStream)stream).close();
        return file;
    }

    private static void createDirectory(IContainer container) throws CoreException {
        if (!container.exists()) {
            if (!container.getParent().exists()) {
                JavaPluginProjectGenerator.createDirectory(container.getParent());
            }
            if (container instanceof IFolder) {
                ((IFolder)container).create(false, true, null);
            }
        }
    }
}

