/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.java;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaDTOGenerator
implements IDTOGenerator {
    private static Logger logger = Logger.getLogger(JavaDTOGenerator.class);
    private boolean createEmptyConstructor = true;
    private List<DataSet> dataSet;
    private boolean createProject = false;

    public JavaDTOGenerator(List<DataSet> newDataSet) {
        this.dataSet = newDataSet;
    }

    public JavaDTOGenerator(List<DataSet> newDataSet, boolean createProject) {
        this.dataSet = newDataSet;
        this.createProject = createProject;
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of a java data transfer object.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        if (this.createProject) {
            for (DataSet d : this.dataSet) {
                DataSet _get = this.dataSet.get(0);
                EList _eContents = _get.eContents();
                Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
                Data _get_1 = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
                EObject _eContainer = _get_1.eContainer();
                String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
                String _plus = "src/de/fzi/sensidl/" + _sensorInterfaceName;
                String _plus_1 = String.valueOf(_plus) + "/";
                String _nameUpper = this.toNameUpper(d);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _plus_2 = String.valueOf(_plus_1) + _addFileExtensionTo;
                String _nameUpper_1 = this.toNameUpper(d);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d);
                filesToGenerate.put(_plus_2, _generateClassBody);
                String _nameUpper_2 = this.toNameUpper(d);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus_3 = "File: " + _addFileExtensionTo_1;
                String _plus_4 = String.valueOf(_plus_3) + " was generated in ";
                String _plus_5 = String.valueOf(_plus_4) + "./src-gen";
                logger.info((Object)_plus_5);
            }
        } else {
            for (DataSet d_1 : this.dataSet) {
                String _nameUpper = this.toNameUpper(d_1);
                String _addFileExtensionTo = this.addFileExtensionTo(_nameUpper);
                String _nameUpper_1 = this.toNameUpper(d_1);
                CharSequence _generateClassBody = this.generateClassBody(_nameUpper_1, d_1);
                filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
                String _nameUpper_2 = this.toNameUpper(d_1);
                String _addFileExtensionTo_1 = this.addFileExtensionTo(_nameUpper_2);
                String _plus = "File: " + _addFileExtensionTo_1;
                String _plus_1 = String.valueOf(_plus) + " was generated in ";
                String _plus_2 = String.valueOf(_plus_1) + "./src-gen";
                logger.info((Object)_plus_2);
            }
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence generateClassBody(String className, DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        if (this.createProject) {
            _builder.append((Object)"package de.fzi.sensidl.");
            EList _eContents = d.eContents();
            Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
            Data _get = ((Data[])Conversions.unwrapArray((Object)_filter, Data.class))[0];
            EObject _eContainer = _get.eContainer();
            String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
            _builder.append((Object)_sensorInterfaceName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.newLine();
        }
        _builder.append((Object)"import java.io.BufferedReader;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ByteArrayInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.append((Object)"import java.io.ObjectInputStream;");
        _builder.newLine();
        _builder.append((Object)"import java.io.Serializable;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Data transfer object for ");
        _builder.append((Object)className, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @generated");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final long serialVersionUID = 1L;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _eContents_1 = d.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, NonMeasurementData.class);
        for (NonMeasurementData data : _filter_1) {
            _builder.append((Object)"\t");
            CharSequence _generateDataFields = this.generateDataFields(data);
            _builder.append((Object)_generateDataFields, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_2 = d.eContents();
        Iterable _filter_2 = Iterables.filter((Iterable)_eContents_2, MeasurementData.class);
        for (MeasurementData data_1 : _filter_2) {
            _builder.append((Object)"\t");
            CharSequence _generateDataFields_1 = this.generateDataFields(data_1);
            _builder.append((Object)_generateDataFields_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Constructor for the Data transfer object");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)className, "\t");
        _builder.append((Object)" (");
        CharSequence _generateConstructorArguments = this.generateConstructorArguments(d);
        _builder.append((Object)_generateConstructorArguments, "\t");
        _builder.append((Object)"){  ");
        _builder.newLineIfNotEmpty();
        EList _eContents_3 = d.eContents();
        Iterable _filter_3 = Iterables.filter((Iterable)_eContents_3, MeasurementData.class);
        for (MeasurementData data_2 : _filter_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _nameLower = this.toNameLower((Data)data_2);
            _builder.append((Object)_nameLower, "\t\t");
            _builder.append((Object)" = ");
            String _nameLower_1 = this.toNameLower((Data)data_2);
            _builder.append((Object)_nameLower_1, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        EList _eContents_4 = d.eContents();
        Iterable _filter_4 = Iterables.filter((Iterable)_eContents_4, NonMeasurementData.class);
        for (NonMeasurementData data_3 : _filter_4) {
            boolean _not;
            boolean _isConstant = data_3.isConstant();
            boolean bl = _not = !_isConstant;
            if (!_not) continue;
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _nameLower_2 = this.toNameLower((Data)data_3);
            _builder.append((Object)_nameLower_2, "\t\t");
            _builder.append((Object)" = ");
            String _nameLower_3 = this.toNameLower((Data)data_3);
            _builder.append((Object)_nameLower_3, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        if (this.createEmptyConstructor) {
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"* empty constructor for the Data transfer object");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            _builder.append((Object)className, "\t");
            _builder.append((Object)"(){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _eContents_5 = d.eContents();
        Iterable _filter_5 = Iterables.filter((Iterable)_eContents_5, MeasurementData.class);
        for (MeasurementData data_4 : _filter_5) {
            _builder.append((Object)"\t");
            CharSequence _generateGetter = this.generateGetter(data_4);
            _builder.append((Object)_generateGetter, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateSetter = this.generateSetter(data_4);
            _builder.append((Object)_generateSetter, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _eContents_6 = d.eContents();
        Iterable _filter_6 = Iterables.filter((Iterable)_eContents_6, NonMeasurementData.class);
        for (NonMeasurementData data_5 : _filter_6) {
            _builder.append((Object)"\t");
            CharSequence _generateGetter_1 = this.generateGetter(data_5);
            _builder.append((Object)_generateGetter_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateSetter_1 = this.generateSetter(data_5);
            _builder.append((Object)_generateSetter_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateJsonUnmarshal = this.generateJsonUnmarshal(d);
        _builder.append((Object)_generateJsonUnmarshal, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _generateByteArrayUnmarshal = this.generateByteArrayUnmarshal(d);
        _builder.append((Object)_generateByteArrayUnmarshal, "\t");
        _builder.append((Object)"\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateDataFields(MeasurementData d) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"/*");
        _builder.newLine();
        String _description = d.getDescription();
        boolean bl = _notEquals = !Objects.equal((Object)_description, null);
        if (_notEquals) {
            _builder.append((Object)" * ");
            String _description_1 = d.getDescription();
            _builder.append((Object)_description_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* Unit: ");
        Unit _unit = d.getUnit();
        _builder.append((Object)_unit, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _nameLower = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateDataFields(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            boolean _notEquals;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)" ");
            _builder.newLine();
            String _description = d.getDescription();
            boolean bl = _notEquals = !Objects.equal((Object)_description, null);
            if (_notEquals) {
                _builder.append((Object)"/*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*");
                String _description_1 = d.getDescription();
                _builder.append((Object)_description_1, " ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
            }
            _builder.append((Object)"private static final ");
            String _typeName = this.toTypeName((Data)d);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)" = ");
            String _value = d.getValue();
            _builder.append((Object)_value, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            boolean _notEquals_1;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)" ");
            _builder_1.newLine();
            String _description_2 = d.getDescription();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_description_2, null);
            if (_notEquals_1) {
                _builder_1.append((Object)"/*");
                _builder_1.newLine();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*");
                String _description_3 = d.getDescription();
                _builder_1.append((Object)_description_3, " ");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"*/");
                _builder_1.newLine();
            }
            _builder_1.append((Object)"private ");
            String _typeName_1 = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName_1, "");
            _builder_1.append((Object)" ");
            String _nameLower = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, "");
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    @Override
    public String toTypeName(Data d) {
        String _switchResult = null;
        DataType _dataType = d.getDataType();
        if (_dataType != null) {
            switch (_dataType) {
                case INT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case UINT8: {
                    _switchResult = Byte.class.getName();
                    break;
                }
                case INT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case UINT16: {
                    _switchResult = Short.class.getName();
                    break;
                }
                case INT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case UINT32: {
                    _switchResult = Integer.class.getName();
                    break;
                }
                case INT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case UINT64: {
                    _switchResult = Long.class.getName();
                    break;
                }
                case FLOAT: {
                    _switchResult = Float.class.getName();
                    break;
                }
                case DOUBLE: {
                    _switchResult = Double.class.getName();
                    break;
                }
            }
        }
        return _switchResult;
    }

    public String toSimpleTypeName(Data d) {
        String _typeName = this.toTypeName(d);
        String _typeName_1 = this.toTypeName(d);
        int _lastIndexOf = _typeName_1.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        String _substring = _typeName.substring(_plus);
        return _substring.toLowerCase();
    }

    public CharSequence generateConstructorArguments(DataSet d) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        ArrayList<Data> dataList = new ArrayList<Data>();
        EList _eContents = d.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            if (data instanceof NonMeasurementData) {
                boolean _not;
                NonMeasurementData nmdata = (NonMeasurementData)data;
                boolean _isConstant = nmdata.isConstant();
                boolean bl = _not = !_isConstant;
                if (!_not) continue;
                dataList.add(data);
                continue;
            }
            dataList.add(data);
        }
        StringConcatenation _xifexpression = null;
        int _size = dataList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            StringConcatenation _xblockexpression_1 = null;
            Data _get = (Data)dataList.get(0);
            String _typeName = this.toTypeName(_get);
            String _plus = String.valueOf(_typeName) + " ";
            Data _get_1 = (Data)dataList.get(0);
            String _nameLower = this.toNameLower(_get_1);
            String firstElement = String.valueOf(_plus) + _nameLower;
            dataList.remove(0);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)firstElement, "");
            for (Data data_1 : dataList) {
                _builder.append((Object)", ");
                String _typeName_1 = this.toTypeName(data_1);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_1 = this.toNameLower(data_1);
                _builder.append((Object)_nameLower_1, "");
            }
            _xifexpression = _xblockexpression_1 = _builder;
        } else {
            StringConcatenation _builder;
            StringConcatenation _xblockexpression_2 = null;
            this.createEmptyConstructor = false;
            _xifexpression = _xblockexpression_2 = (_builder = new StringConcatenation());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence generateGetter(MeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        String _nameLower_1 = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetter(NonMeasurementData d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ");
        String _nameLower = this.toNameLower((Data)d);
        _builder.append((Object)_nameLower, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _typeName = this.toTypeName((Data)d);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        CharSequence _getterName = this.toGetterName((Data)d);
        _builder.append((Object)_getterName, "");
        _builder.append((Object)"(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            String _name = d.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append((Object)_upperCase, "\t");
        } else {
            String _nameLower_1 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_1, "\t");
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence toGetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public CharSequence generateSetter(MeasurementData d) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        EList _adjustments = d.getAdjustments();
        boolean _isEmpty = _adjustments.isEmpty();
        boolean bl = _equals = !_isEmpty;
        if (_equals) {
            _builder.newLine();
            EList _adjustments_1 = d.getAdjustments();
            for (DataAdjustment dataAdj : _adjustments_1) {
                if (dataAdj instanceof DataRange) {
                    _builder.append((Object)"/**");
                    _builder.newLine();
                    _builder.append((Object)" ");
                    _builder.append((Object)"* @param ");
                    String _nameLower = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower, " ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*\t\t\tthe ");
                    String _nameLower_1 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_1, " ");
                    _builder.append((Object)" to set");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)" ");
                    _builder.append((Object)"*/");
                    _builder.newLine();
                    _builder.append((Object)"public void ");
                    CharSequence _setterName = this.toSetterName((Data)d);
                    _builder.append((Object)_setterName, "");
                    _builder.append((Object)"(");
                    String _typeName = this.toTypeName((Data)d);
                    _builder.append((Object)_typeName, "");
                    _builder.append((Object)" ");
                    String _nameLower_2 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_2, "");
                    _builder.append((Object)"){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if (");
                    String _nameLower_3 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_3, "\t");
                    _builder.append((Object)" >= ");
                    Interval _range = ((DataRange)dataAdj).getRange();
                    double _lowerBound = _range.getLowerBound();
                    _builder.append((Object)_lowerBound, "\t");
                    _builder.append((Object)" && ");
                    String _nameLower_4 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_4, "\t");
                    _builder.append((Object)" <= ");
                    Interval _range_1 = ((DataRange)dataAdj).getRange();
                    double _upperBound = _range_1.getUpperBound();
                    _builder.append((Object)_upperBound, "\t");
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"this.");
                    String _nameLower_5 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_5, "\t\t");
                    _builder.append((Object)" = ");
                    String _nameLower_6 = this.toNameLower((Data)d);
                    _builder.append((Object)_nameLower_6, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"else");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"throw new IllegalArgumentException(\"value is out of defined range\");\t");
                    _builder.newLine();
                    _builder.append((Object)"} ");
                    _builder.newLine();
                    continue;
                }
                if (!(dataAdj instanceof DataConversion)) continue;
                _builder.newLine();
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)"* @param ");
                String _nameLower_7 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_7, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"*\t\t\tthe ");
                String _nameLower_8 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_8, "");
                _builder.append((Object)" to set");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"public void ");
                CharSequence _setterName_1 = this.toSetterName((Data)d);
                _builder.append((Object)_setterName_1, "");
                _builder.append((Object)"(");
                String _typeName_1 = this.toTypeName((Data)d);
                _builder.append((Object)_typeName_1, "");
                _builder.append((Object)" ");
                String _nameLower_9 = this.toNameLower((Data)d);
                _builder.append((Object)_nameLower_9, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"try {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CharSequence _generateSetterBodyForMeasurementData = this.generateSetterBodyForMeasurementData(d, (DataConversion)dataAdj);
                _builder.append((Object)_generateSetterBodyForMeasurementData, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"} catch (IllegalArgumentException e) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"//Do something");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
        } else {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param ");
            String _nameLower_10 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_10, " ");
            _builder.append((Object)"  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*\t\t\tthe ");
            String _nameLower_11 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_11, " ");
            _builder.append((Object)" to set");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"public void ");
            CharSequence _setterName_2 = this.toSetterName((Data)d);
            _builder.append((Object)_setterName_2, "");
            _builder.append((Object)"(");
            String _typeName_2 = this.toTypeName((Data)d);
            _builder.append((Object)_typeName_2, "");
            _builder.append((Object)" ");
            String _nameLower_12 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_12, "");
            _builder.append((Object)"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _nameLower_13 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_13, "\t");
            _builder.append((Object)" = ");
            String _nameLower_14 = this.toNameLower((Data)d);
            _builder.append((Object)_nameLower_14, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"} ");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversion conversion) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"final double offset = ");
        double _offset = conversion.getOffset();
        _builder.append((Object)_offset, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"final double scalingFactor = ");
        double _scalingFactor = conversion.getScalingFactor();
        _builder.append((Object)_scalingFactor, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = this.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversion", "");
        _builder.append((Object)"(");
        String _nameLower_1 = this.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", scalingFactor, offset);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateSetterBodyForMeasurementData(MeasurementData data, LinearDataConversionWithInterval conversion) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" oldMin = (");
        String _simpleTypeName = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName, "");
        _builder.append((Object)") ");
        Interval _fromInterval = conversion.getFromInterval();
        double _lowerBound = _fromInterval.getLowerBound();
        _builder.append((Object)_lowerBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_1 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_1, "");
        _builder.append((Object)" oldMax = (");
        String _simpleTypeName_1 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_1, "");
        _builder.append((Object)") ");
        Interval _fromInterval_1 = conversion.getFromInterval();
        double _upperBound = _fromInterval_1.getUpperBound();
        _builder.append((Object)_upperBound, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_2 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_2, "");
        _builder.append((Object)" newMin = (");
        String _simpleTypeName_2 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_2, "");
        _builder.append((Object)") ");
        Interval _toInterval = conversion.getToInterval();
        double _lowerBound_1 = _toInterval.getLowerBound();
        _builder.append((Object)_lowerBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _typeName_3 = this.toTypeName((Data)data);
        _builder.append((Object)_typeName_3, "");
        _builder.append((Object)" newMax = (");
        String _simpleTypeName_3 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_3, "");
        _builder.append((Object)") ");
        Interval _toInterval_1 = conversion.getToInterval();
        double _upperBound_1 = _toInterval_1.getUpperBound();
        _builder.append((Object)_upperBound_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"this.");
        String _nameLower = this.toNameLower((Data)data);
        _builder.append((Object)_nameLower, "");
        _builder.append((Object)" = (");
        String _simpleTypeName_4 = this.toSimpleTypeName((Data)data);
        _builder.append((Object)_simpleTypeName_4, "");
        _builder.append((Object)") ");
        EObject _eContainer = data.eContainer();
        String _sensorInterfaceName = this.getSensorInterfaceName(_eContainer);
        _builder.append((Object)_sensorInterfaceName, "");
        _builder.append((Object)"Utility", "");
        _builder.append((Object)".");
        _builder.append((Object)"linearConversionWithInterval", "");
        _builder.append((Object)"(");
        String _nameLower_1 = this.toNameLower((Data)data);
        _builder.append((Object)_nameLower_1, "");
        _builder.append((Object)", oldMin, oldMax, newMin, newMax);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateSetter(NonMeasurementData d) {
        StringConcatenation _xifexpression = null;
        boolean _isConstant = d.isConstant();
        if (_isConstant) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"// no setter for constant value");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"/**");
            _builder_1.newLine();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"* @param ");
            String _nameLower = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower, " ");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*\t\t\tthe ");
            String _nameLower_1 = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_1, " ");
            _builder_1.append((Object)" to set");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*/");
            _builder_1.newLine();
            _builder_1.append((Object)"public void ");
            CharSequence _setterName = this.toSetterName((Data)d);
            _builder_1.append((Object)_setterName, "");
            _builder_1.append((Object)"(");
            String _typeName = this.toTypeName((Data)d);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)" ");
            String _nameLower_2 = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_2, "");
            _builder_1.append((Object)"){");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            _builder_1.append((Object)"this.");
            String _nameLower_3 = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_3, "\t");
            _builder_1.append((Object)" = ");
            String _nameLower_4 = this.toNameLower((Data)d);
            _builder_1.append((Object)_nameLower_4, "\t");
            _builder_1.append((Object)";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"} ");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    public CharSequence toSetterName(Data d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _name = d.getName();
        String _replaceAll = _name.replaceAll("[^a-zA-Z0-9]", "");
        String _firstUpper = StringExtensions.toFirstUpper((String)_replaceAll);
        _builder.append((Object)_firstUpper, "");
        return _builder;
    }

    public String toNameLower(Data d) {
        String _name = d.getName();
        return StringExtensions.toFirstLower((String)_name);
    }

    public String toNameLower(DataSet d) {
        String _name = d.getName();
        return StringExtensions.toFirstLower((String)_name);
    }

    public String toNameUpper(Data d) {
        String _name = d.getName();
        return StringExtensions.toFirstUpper((String)_name);
    }

    public String toNameUpper(DataSet d) {
        String _name = d.getName();
        return StringExtensions.toFirstUpper((String)_name);
    }

    public CharSequence generateJsonUnmarshal(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Alternative method responsible for deserializing the received");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* JSON-formatted L stage from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side in a JSON");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            format");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return L unmarshalled L structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _nameUpper = this.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" unmarshal");
        String _nameUpper_1 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)" (BufferedReader dataset) { ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Gson gson = new Gson();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"BufferedReader br = dataset;");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _nameUpper_2 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_2, "\t");
        _builder.append((Object)" obj = gson.fromJson(br, ");
        String _nameUpper_3 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_3, "\t");
        _builder.append((Object)".class);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return obj;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateByteArrayUnmarshal(DataSet d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Method responsible for deserializing the received byte array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* representation of L from sensor.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param dataset");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            the dataset to unmarshall incoming from sensor side as a byte");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*            array");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return L unmarshalled L structure");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws IOException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @throws ClassNotFoundException");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _nameUpper = this.toNameUpper(d);
        _builder.append((Object)_nameUpper, "");
        _builder.append((Object)" unmarshal");
        String _nameUpper_1 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_1, "");
        _builder.append((Object)"(byte[] dataset) throws IOException, ClassNotFoundException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ByteArrayInputStream in = new ByteArrayInputStream(dataset);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ObjectInputStream ois = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ois = new ObjectInputStream(in);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Object o = ois.readObject();");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _nameUpper_2 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_2, "\t");
        _builder.append((Object)" ");
        String _nameLower = this.toNameLower(d);
        _builder.append((Object)_nameLower, "\t");
        _builder.append((Object)" = (");
        String _nameUpper_3 = this.toNameUpper(d);
        _builder.append((Object)_nameUpper_3, "\t");
        _builder.append((Object)") o; // TODO: Ensure the type conversion is valid");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"in.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (in != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ois.close();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return ");
        String _nameLower_1 = this.toNameLower(d);
        _builder.append((Object)_nameLower_1, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String ClassName) {
        return String.valueOf(ClassName) + ".java";
    }

    public String getSensorInterfaceName(EObject currentElement) {
        if (currentElement instanceof SensorInterface) {
            return ((SensorInterface)currentElement).getName();
        }
        EObject _eContainer = currentElement.eContainer();
        return this.getSensorInterfaceName(_eContainer);
    }

    public CharSequence generateSetterBodyForMeasurementData(MeasurementData data, DataConversion conversion) {
        if (conversion instanceof LinearDataConversion) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversion)conversion);
        }
        if (conversion instanceof LinearDataConversionWithInterval) {
            return this._generateSetterBodyForMeasurementData(data, (LinearDataConversionWithInterval)conversion);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data, conversion).toString());
    }
}

