/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.generator.factory.c;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.language.generator.factory.c.CDTOGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class HeaderDTOGenerator
extends CDTOGenerator {
    private static Logger logger = Logger.getLogger(HeaderDTOGenerator.class);

    public HeaderDTOGenerator(List<DataSet> newDataSet) {
        super(newDataSet);
    }

    @Override
    public HashMap<String, CharSequence> generate() {
        HashMap<String, CharSequence> _xblockexpression = null;
        logger.info((Object)"Start with code-generation of the data transfer object header-file.");
        HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
        for (DataSet dataset : this.dataSet) {
            String _name = dataset.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            String fileName = this.addFileExtensionTo(_firstUpper);
            String _name_1 = dataset.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
            CharSequence _generateStruct = this.generateStruct(_firstUpper_1, dataset);
            filesToGenerate.put(fileName, _generateStruct);
            logger.info((Object)("File: " + fileName + " was generated in " + "./src-gen"));
        }
        _xblockexpression = filesToGenerate;
        return _xblockexpression;
    }

    public CharSequence compile(DataSet dataset) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        CharSequence _generateStruct = this.generateStruct(_firstUpper, dataset);
        _builder.append((Object)_generateStruct, "");
        return _builder;
    }

    public CharSequence generateStruct(String structName, DataSet dataset) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**\\brief\t\t");
        String _description = dataset.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = dataset.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.append((Object)"  ");
        _builder.newLineIfNotEmpty();
        EList _eContents = dataset.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Data.class);
        for (Data data : _filter) {
            CharSequence _generateDescription = this.generateDescription(data);
            _builder.append((Object)_generateDescription, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#ifndef ");
        String _upperCase = structName.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#define ");
        String _upperCase_1 = structName.toUpperCase();
        _builder.append((Object)_upperCase_1, "");
        _builder.append((Object)"_H");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include <stdint.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"typedef struct");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _eContents_1 = dataset.eContents();
        Iterable _filter_1 = Iterables.filter((Iterable)_eContents_1, Data.class);
        for (Data data_1 : _filter_1) {
            _builder.append((Object)"\t");
            CharSequence _generateVariable = this.generateVariable(data_1);
            _builder.append((Object)_generateVariable, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"} ");
        String _name = dataset.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"extern ");
        String _name_1 = dataset.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)" ");
        String _name_2 = dataset.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name_2);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateDescription(MeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*\t\t\t\tMeasured in unit: ");
        Unit _unit = data.getUnit();
        _builder.append((Object)_unit, "");
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateDescription(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"* \\param\t\t");
        String _name = data.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)": ");
        String _description = data.getDescription();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_description);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _description_1 = data.getDescription();
            _builder.append((Object)_description_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateVariable(MeasurementData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name = data.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name);
        _builder.append((Object)_firstLower, "");
        _builder.append((Object)";");
        return _builder;
    }

    protected CharSequence _generateVariable(NonMeasurementData data) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isConstant = data.isConstant();
        if (_isConstant) {
            _builder.append((Object)"const ");
        }
        String _typeName = this.toTypeName((Data)data);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name = data.getName();
        String _firstLower = StringExtensions.toFirstLower((String)_name);
        _builder.append((Object)_firstLower, "");
        String _value = data.getValue();
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)_value);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)" = ");
            String _value_1 = data.getValue();
            _builder.append((Object)_value_1, "");
        }
        _builder.append((Object)";");
        return _builder;
    }

    @Override
    public String addFileExtensionTo(String className) {
        return String.valueOf(className) + ".h";
    }

    public CharSequence generateDescription(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateDescription((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateDescription((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }

    public CharSequence generateVariable(Data data) {
        if (data instanceof MeasurementData) {
            return this._generateVariable((MeasurementData)data);
        }
        if (data instanceof NonMeasurementData) {
            return this._generateVariable((NonMeasurementData)data);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(data).toString());
    }
}

