/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.ui.wizard;

import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import de.fzi.sensidl.language.ui.handler.GenerationHandler;
import de.fzi.sensidl.language.ui.handler.SettingsHandler;
import de.fzi.sensidl.language.ui.wizard.ErrorDialogHandler;
import de.fzi.sensidl.language.ui.wizard.SensidlWizardPage;
import java.io.FileNotFoundException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;

public class SensidlWizard
extends Wizard {
    protected SensidlWizardPage sensidlWizardPage;
    private String modelPath;
    private String path;
    private String language;

    public SensidlWizard(String modelPath, String path, String language) {
        this.modelPath = modelPath;
        this.path = path;
        this.language = language;
    }

    public void addPages() {
        Bundle bundle = Platform.getBundle((String)"de.fzi.sensidl.language.ui");
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)"images/SensIDL_logo.jpg");
        this.sensidlWizardPage = new SensidlWizardPage("SensIDL Tooling Wizard", "SensIDL Tooling Wizard", ImageDescriptor.createFromURL((URL)fullPathString), this.modelPath, this.path, this.language);
        this.addPage((IWizardPage)this.sensidlWizardPage);
    }

    public boolean performFinish() {
        String modelPath = null;
        modelPath = this.sensidlWizardPage.getTextModelPath().startsWith("platform:/resource") ? this.sensidlWizardPage.getTextModelPath().replace("platform:/resource", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) : this.sensidlWizardPage.getTextModelPath();
        String path = null;
        path = this.sensidlWizardPage.getTextPath().startsWith("platform:/resource") ? this.sensidlWizardPage.getTextPath().replace("platform:/resource", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) : this.sensidlWizardPage.getTextPath();
        ErrorDialogHandler errorHandler = new ErrorDialogHandler();
        try {
            GenerationHandler.generate(path, modelPath, this.sensidlWizardPage.getLanguage());
            MessageDialog.openInformation((Shell)new Shell(), (String)"Info", (String)"The code was successfully generated");
        }
        catch (FileNotFoundException ex) {
            errorHandler.execute(new Shell(), ex);
            return false;
        }
        catch (NoSidlFileException ex) {
            errorHandler.execute(new Shell(), ex);
            return false;
        }
        catch (Exception ex) {
            errorHandler.execute(new Shell(), ex);
            return false;
        }
        SettingsHandler.saveSettings(this.sensidlWizardPage.getTextPath(), this.sensidlWizardPage.getLanguage());
        return true;
    }
}

