/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.language.tests.generator;

import de.fzi.sensidl.design.sensidl.dataRepresentation.impl.DataRepresentationPackageImpl;
import de.fzi.sensidl.language.ui.exception.NoSidlFileException;
import de.fzi.sensidl.language.ui.handler.GenerationHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileDeleteStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class FileGenerationTest {
    private static File testGenDir;
    static Map<String, Boolean> map;
    private static String[] dataSets;
    private static String sensorInterfaceName;

    static {
        dataSets = new String[]{"Conductor", "NeutralConductor", "Energy"};
        sensorInterfaceName = "EMeter";
    }

    @BeforeClass
    public static void setUp() throws IOException {
        DataRepresentationPackageImpl.init();
        testGenDir = new File("test-gen/generator");
        if (!testGenDir.exists()) {
            testGenDir.mkdir();
        } else {
            FileGenerationTest.deleteGen();
        }
        map = new HashMap<String, Boolean>();
    }

    @Test
    public void javaFilesGenerationTest() throws IOException, NoSidlFileException {
        int i = 0;
        while (i < dataSets.length) {
            map.put(String.valueOf(dataSets[i]) + ".java", false);
            ++i;
        }
        GenerationHandler.generate((String)testGenDir.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"Java");
        String[] stringArray = testGenDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (map.containsKey(file)) {
                map.put(file, true);
            } else if (!this.checkFile(file, "sidlTestCode")) {
                throw new AssertionError((Object)(String.valueOf(file) + " should not get generated"));
            }
            ++n2;
        }
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            Assert.assertTrue((boolean)entry.getValue());
        }
        Assert.assertTrue((boolean)this.containsTextAndSensidl("sidlTestCode"));
    }

    @Test
    public void javascriptFilesGenerationTest() throws IOException, NoSidlFileException {
        boolean containsJSFile = false;
        GenerationHandler.generate((String)testGenDir.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"JavaScript");
        String[] stringArray = testGenDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.equals(String.valueOf(sensorInterfaceName) + ".js")) {
                containsJSFile = true;
            } else if (!this.checkFile(file, "sidlTestCode")) {
                throw new AssertionError((Object)(String.valueOf(file) + " should not get generated"));
            }
            ++n2;
        }
        Assert.assertTrue((boolean)containsJSFile);
        Assert.assertTrue((boolean)this.containsTextAndSensidl("sidlTestCode"));
    }

    @Test
    public void CFilesGenerationTest() throws IOException, NoSidlFileException {
        int i = 0;
        while (i < dataSets.length) {
            map.put(String.valueOf(dataSets[i]) + ".c", false);
            map.put(String.valueOf(dataSets[i]) + ".h", false);
            ++i;
        }
        GenerationHandler.generate((String)testGenDir.getPath(), (String)"resource/generator/sidlTestCode.sidl", (String)"C");
        String[] stringArray = testGenDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (map.containsKey(file)) {
                map.put(file, true);
            } else if (!this.checkFile(file, "sidlTestCode")) {
                throw new AssertionError((Object)(String.valueOf(file) + " should not get generated"));
            }
            ++n2;
        }
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            Assert.assertTrue((boolean)entry.getValue());
        }
        Assert.assertTrue((boolean)this.containsTextAndSensidl("sidlTestCode"));
    }

    @Test
    @Ignore
    public void CSharpFilesGenerationTest() throws IOException {
    }

    @After
    public void tearDown() throws IOException {
        FileGenerationTest.deleteGen();
        map.clear();
    }

    private boolean checkFile(String file, String sidlFileName) {
        if (file.equals(String.valueOf(sensorInterfaceName) + ".txt")) {
            return true;
        }
        return file.equals(String.valueOf(sidlFileName) + ".sensidl");
    }

    private boolean containsTextAndSensidl(String sidlFileName) {
        boolean containsText = false;
        boolean containsSensidl = false;
        String[] stringArray = testGenDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.equals(String.valueOf(sensorInterfaceName) + ".txt")) {
                containsText = true;
            } else if (file.equals(String.valueOf(sidlFileName) + ".sensidl")) {
                containsSensidl = true;
            }
            ++n2;
        }
        return containsText & containsSensidl;
    }

    private static void deleteGen() throws IOException {
        File[] fileArray = testGenDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            FileDeleteStrategy.FORCE.delete(file);
            ++n2;
        }
    }
}

