package de.fzi.sensidl.vorto.generator;

import de.fzi.sensidl.language.generator.generationstep.DTOGenerationStep;
import de.fzi.sensidl.vorto.generator.TransformationHandler;
import java.io.IOException;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;

/**
 * SensIDL Vorto Generator. The Vorto Information model will be
 * transformed to a SensIDL model and code will be generated by
 * the SensIDL generator
 * 
 * @author Sven Eckhardt
 */
@SuppressWarnings("all")
public class SensIDLGenerator implements IVortoCodeGenerator {
  /**
   * Start the transformation from the vorto information model to
   * the sensidl model (which will start the sensidl generation process)
   */
  public IGenerationResult generate(final InformationModel infomodel, final InvocationContext mappingContext) {
    DTOGenerationStep.createSidlFile = true;
    try {
      TransformationHandler _transformationHandler = new TransformationHandler();
      _transformationHandler.execute(infomodel);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException ex = (IOException)_t;
        String _message = ex.getMessage();
        InputOutput.<String>println(_message);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return null;
  }
  
  public String getServiceKey() {
    return "SensIDL Generator";
  }
}
