package de.fzi.sensidl.language.generator.templates.java.opcua;

import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class OpcUaUtil {
  private final static String NAMESPACE_SUFFIX = "Namespace";
  
  private final static String INTERFACE_NAME_SUFFIX = "DataSet";
  
  private final static String DATA_SET_PREFIX = "OpcUa";
  
  public static String getDefaultPackageName(final SensorInterface sensorInterface) {
    return sensorInterface.getName();
  }
  
  public static String getServerNamespaceName(final SensorInterface sensorInterface) {
    String _name = sensorInterface.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    return (_firstUpper + OpcUaUtil.NAMESPACE_SUFFIX);
  }
  
  public static CharSequence getDefaultServerUrn(final SensorInterface sensorInterface) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("urn:");
    String _name = sensorInterface.getName();
    String _lowerCase = _name.toLowerCase();
    _builder.append(_lowerCase, "");
    _builder.append(":opcua:server");
    return _builder;
  }
  
  public static CharSequence getDefaultNamespaceUrn(final SensorInterface sensorInterface) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("urn:opcua:server:namespace:");
    String _name = sensorInterface.getName();
    String _lowerCase = _name.toLowerCase();
    _builder.append(_lowerCase, "");
    return _builder;
  }
  
  public static CharSequence getDefaultClassName(final DataSet dataset) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = dataset.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    String _plus = (OpcUaUtil.DATA_SET_PREFIX + _firstUpper);
    _builder.append(_plus, "");
    return _builder;
  }
  
  public static CharSequence getDefaultClassName(final SensorInterface sensorInterface) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = sensorInterface.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    return _builder;
  }
  
  public static CharSequence getDefaultInterfaceName(final SensorInterface sensorInterface) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = sensorInterface.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    String _plus = (_firstUpper + OpcUaUtil.INTERFACE_NAME_SUFFIX);
    _builder.append(_plus, "");
    return _builder;
  }
}
