package de.fzi.sensidl.language.generator.templates.java.opcua;

import com.google.common.base.Objects;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription;
import de.fzi.sensidl.language.generator.templates.EclipsePuplicLicenseTemplate;
import de.fzi.sensidl.language.generator.templates.ITemplate;
import de.fzi.sensidl.language.generator.templates.java.opcua.OpcUaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class OpcUaServerNamespaceTemplate extends ITemplate<SensorInterface> {
  private String dataSetInterfaceClassName;
  
  private String dataSetInterfaceObjectName;
  
  private String packagePrefix;
  
  private ArrayList<CharSequence> dataSetInterfaceImplementer = new ArrayList<CharSequence>();
  
  /**
   * The constructor.
   * @param newElement - SensorInterface-element which is needed for the code-generation.
   */
  public OpcUaServerNamespaceTemplate(final SensorInterface newElement, final String newPackagePrefix) {
    super(newElement);
    this.packagePrefix = newPackagePrefix;
    CharSequence _defaultInterfaceName = OpcUaUtil.getDefaultInterfaceName(this.element);
    String _string = _defaultInterfaceName.toString();
    this.dataSetInterfaceClassName = _string;
    String _firstLower = StringExtensions.toFirstLower(this.dataSetInterfaceClassName);
    String _plus = (_firstLower + "s");
    this.dataSetInterfaceObjectName = _plus;
    this.addAllImplementers();
  }
  
  private void addAllImplementers() {
    SensorDataDescription _dataDescription = this.element.getDataDescription();
    EList<DataSet> _dataSets = _dataDescription.getDataSets();
    final Consumer<DataSet> _function = new Consumer<DataSet>() {
      public void accept(final DataSet dataSet) {
        CharSequence _stringRepresentation = OpcUaServerNamespaceTemplate.this.getStringRepresentation(dataSet);
        OpcUaServerNamespaceTemplate.this.dataSetInterfaceImplementer.add(_stringRepresentation);
      }
    };
    _dataSets.forEach(_function);
  }
  
  private CharSequence getStringRepresentation(final DataSet set) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("add(new ");
    CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName(set);
    _builder.append(_defaultClassName, "");
    _builder.append("(namespaceIndex");
    String _addSubtypesIfNecessary = this.addSubtypesIfNecessary(set);
    _builder.append(_addSubtypesIfNecessary, "");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  private String addSubtypesIfNecessary(final DataSet set) {
    String _xblockexpression = null;
    {
      SensorDataDescription _dataDescription = this.element.getDataDescription();
      EList<DataSet> _dataSets = _dataDescription.getDataSets();
      BasicEList<DataSet> availableDataSets = new BasicEList<DataSet>(_dataSets);
      final Predicate<DataSet> _function = new Predicate<DataSet>() {
        public boolean test(final DataSet currentSet) {
          return (Objects.equal(currentSet, set) || (!currentSet.getUsedDataSets().contains(set)));
        }
      };
      availableDataSets.removeIf(_function);
      boolean _isEmpty = availableDataSets.isEmpty();
      if (_isEmpty) {
        return "";
      }
      final StringBuilder builder = new StringBuilder();
      final Consumer<DataSet> _function_1 = new Consumer<DataSet>() {
        public void accept(final DataSet availabeDataSet) {
          builder.append(", ");
          CharSequence _defaultClassName = OpcUaUtil.getDefaultClassName(availabeDataSet);
          String _plus = ("new " + _defaultClassName);
          String _plus_1 = (_plus + "(namespaceIndex)");
          builder.append(_plus_1);
        }
      };
      availableDataSets.forEach(_function_1);
      _xblockexpression = builder.toString();
    }
    return _xblockexpression;
  }
  
  /**
   * @see ITemplate<T>#getFileName()
   */
  public String getFileName() {
    return OpcUaUtil.getServerNamespaceName(this.element);
  }
  
  private String print(final List<CharSequence> elementsToPrint) {
    String _xblockexpression = null;
    {
      final StringBuilder builder = new StringBuilder();
      final Consumer<CharSequence> _function = new Consumer<CharSequence>() {
        public void accept(final CharSequence element) {
          builder.append(element);
        }
      };
      elementsToPrint.forEach(_function);
      _xblockexpression = builder.toString();
    }
    return _xblockexpression;
  }
  
  /**
   * Generates the OPC UA namespace which is required by the Opc UA server to register the user specific
   * SensIDL-DataSets as OPC UA nodes. The OPC UA namespace extends the default OPC UA addressspace.
   * @see ITemplate<T>#getCode()
   */
  public CharSequence getCode() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _text = EclipsePuplicLicenseTemplate.getText();
    _builder.append(_text, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("package ");
    _builder.append(this.packagePrefix, "");
    String _defaultPackageName = OpcUaUtil.getDefaultPackageName(this.element);
    _builder.append(_defaultPackageName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import static org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned.ubyte;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import java.util.ArrayList;");
    _builder.newLine();
    _builder.append("import java.util.List;");
    _builder.newLine();
    _builder.append("import java.util.Optional;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.CompletableFuture;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.core.AccessLevel;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.core.Reference;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.OpcUaServer;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.api.DataItem;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.api.MethodInvocationHandler;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.api.Namespace;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaFolderNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaMethodNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaObjectNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaObjectTypeNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.model.UaVariableNode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.Identifiers;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.StatusCodes;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.UaException;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;");
    _builder.newLine();
    _builder.append("import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;");
    _builder.newLine();
    _builder.append("import org.slf4j.Logger;");
    _builder.newLine();
    _builder.append("import org.slf4j.LoggerFactory;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import com.google.common.collect.Lists;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class ");
    String _serverNamespaceName = OpcUaUtil.getServerNamespaceName(this.element);
    _builder.append(_serverNamespaceName, "");
    _builder.append(" implements Namespace {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static final String NAMESPACE_URI = \"");
    CharSequence _defaultNamespaceUrn = OpcUaUtil.getDefaultNamespaceUrn(this.element);
    _builder.append(_defaultNamespaceUrn, "\t");
    _builder.append("\";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final List<");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append("> ");
    _builder.append(this.dataSetInterfaceObjectName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final Logger logger = LoggerFactory.getLogger(getClass());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final SubscriptionModel subscriptionModel;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final OpcUaServer server;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private final UShort namespaceIndex;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _serverNamespaceName_1 = OpcUaUtil.getServerNamespaceName(this.element);
    _builder.append(_serverNamespaceName_1, "\t");
    _builder.append("(OpcUaServer server, UShort namespaceIndex) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this.server = server;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.namespaceIndex = namespaceIndex;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.subscriptionModel = new SubscriptionModel(server, this);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.");
    _builder.append(this.dataSetInterfaceObjectName, "\t\t");
    _builder.append(" = new ArrayList<");
    _builder.append(this.dataSetInterfaceClassName, "\t\t");
    _builder.append(">() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t\t ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append("\t\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    String _print = this.print(this.dataSetInterfaceImplementer);
    _builder.append(_print, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("initialize();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void initialize() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("extendUaNamespace();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("add");
    String _name = this.element.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "\t\t");
    _builder.append("Nodes();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void extendUaNamespace() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.");
    _builder.append(this.dataSetInterfaceObjectName, "\t\t");
    _builder.append(".forEach(dataSet -> addObjectType(dataSet));");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void addObjectType(");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append(" dataSet) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("UaObjectTypeNode node = new UaObjectTypeNode(this.server.getNodeManager(), dataSet.getObjectTypeNodeId(),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("new QualifiedName(this.server.getUaNamespace().getNamespaceIndex(), dataSet.getObjectTypeName()),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("new LocalizedText(\"en\", dataSet.getObjectTypeName()),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Optional.of(new LocalizedText(\"en\", dataSet.getDescription())), Optional.of(UInteger.valueOf(0L)),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Optional.of(UInteger.valueOf(0L)), false);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.server.getNodeManager().addNode(node);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(Identifiers.BaseObjectType, Identifiers.HasSubtype, true,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("dataSet.getObjectTypeNodeId().expanded(), NodeClass.ObjectType);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(dataSet.getObjectTypeNodeId(), Identifiers.HasSubtype,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("false, Identifiers.BaseObjectType.expanded(), NodeClass.ObjectType);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (UaException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void add");
    String _name_1 = this.element.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("Nodes() {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("NodeId folderNodeId = new NodeId(namespaceIndex, \"");
    String _name_2 = this.element.getName();
    String _firstUpper_2 = StringExtensions.toFirstUpper(_name_2);
    _builder.append(_firstUpper_2, "\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("UaFolderNode folderNode = new UaFolderNode(server.getNodeManager(), folderNodeId,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new QualifiedName(namespaceIndex, \"");
    String _name_3 = this.element.getName();
    String _firstUpper_3 = StringExtensions.toFirstUpper(_name_3);
    _builder.append(_firstUpper_3, "\t\t\t");
    _builder.append("\"), LocalizedText.english(\"");
    String _name_4 = this.element.getName();
    String _firstUpper_4 = StringExtensions.toFirstUpper(_name_4);
    _builder.append(_firstUpper_4, "\t\t\t");
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("server.getNodeManager().addNode(folderNode);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("server.getUaNamespace().addReference(Identifiers.ObjectsFolder, Identifiers.Organizes, true,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("folderNodeId.expanded(), NodeClass.Object);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (UaException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("add");
    String _name_5 = this.element.getName();
    String _firstUpper_5 = StringExtensions.toFirstUpper(_name_5);
    _builder.append(_firstUpper_5, "\t\t");
    _builder.append("NodesTo(folderNode);");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void add");
    String _name_6 = this.element.getName();
    String _firstUpper_6 = StringExtensions.toFirstUpper(_name_6);
    _builder.append(_firstUpper_6, "\t");
    _builder.append("NodesTo(UaFolderNode folderNode) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.");
    _builder.append(this.dataSetInterfaceObjectName, "\t\t");
    _builder.append(".stream().filter(dataSet -> dataSet.getSubtypes() == null)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append(".forEach(dataSetWithoutSubtype -> addObject(dataSetWithoutSubtype, folderNode));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.");
    _builder.append(this.dataSetInterfaceObjectName, "\t\t");
    _builder.append(".stream().filter(dataSet -> dataSet.getSubtypes() != null)");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append(".forEach(dataSetWithSubtype -> addObjectWithSubtype(dataSetWithSubtype, folderNode));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void addObject(");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append(" dataSet, UaFolderNode folderNode) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("UaObjectNode node = new UaObjectNode(this.server.getNodeManager(), dataSet.getObjectNodeId(),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("new QualifiedName(this.namespaceIndex, dataSet.getObjectName()),");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("LocalizedText.english(dataSet.getObjectName()));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.server.getNodeManager().addNode(node);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(dataSet.getObjectNodeId(), Identifiers.HasTypeDefinition,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("true, dataSet.getObjectTypeNodeId().expanded(), NodeClass.ObjectType);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("addVariablesTo(node, dataSet);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (UaException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("folderNode.addOrganizes(node);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void addObjectWithSubtype(");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append(" dataSet, UaFolderNode folderNode) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("addObject(dataSet, folderNode);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dataSet.getSubtypes().forEach(subtype -> addHasSubtypeReferences(dataSet, subtype));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void addHasSubtypeReferences(");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append(" supertype, ");
    _builder.append(this.dataSetInterfaceClassName, "\t");
    _builder.append(" subtype) {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(supertype.getObjectNodeId(), Identifiers.HasSubtype, true,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("subtype.getObjectNodeId().expanded(), NodeClass.Object);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(subtype.getObjectNodeId(), Identifiers.HasSubtype, false,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("supertype.getObjectNodeId().expanded(), NodeClass.Object);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (UaException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("logger.error(\"An error occurred during namespace initialization. \", e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void addVariablesTo(UaObjectNode node, ");
    CharSequence _defaultInterfaceName = OpcUaUtil.getDefaultInterfaceName(this.element);
    _builder.append(_defaultInterfaceName, "\t");
    _builder.append(" dataSet) throws UaException {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (dataSet.getVariables() == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Object[] variable : dataSet.getVariables()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("String name = (String) variable[0];");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("NodeId typeId = (NodeId) variable[1];");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Variant variant = (Variant) variable[2];");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("String description = (String) variable[3];");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("UaVariableNode variableNode = new UaVariableNode.UaVariableNodeBuilder(server.getNodeManager())");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setNodeId(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("new NodeId(this.namespaceIndex, node.getNodeId().getIdentifier().toString() + \"/\" + name))");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setAccessLevel(ubyte(AccessLevel.getMask(AccessLevel.READ_WRITE)))");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setBrowseName(new QualifiedName(this.namespaceIndex, name))");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setDisplayName(LocalizedText.english(name)).setDataType(typeId)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setDescription(LocalizedText.english(description))");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append(".setTypeDefinition(Identifiers.BaseDataVariableType).build();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("variableNode.setValue(new DataValue(variant));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("server.getNodeManager().addNode(variableNode);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("this.server.getUaNamespace().addReference(node.getNodeId(), Identifiers.HasComponent, true,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("variableNode.getNodeId().expanded(), NodeClass.Variable);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public CompletableFuture<List<Reference>> getReferences(NodeId nodeId) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("UaNode node = server.getNodeManager().get(nodeId);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (node != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return CompletableFuture.completedFuture(node.getReferences());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return failedFuture(new UaException(StatusCodes.Bad_NodeIdUnknown));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private <T> CompletableFuture<T> failedFuture(Throwable ex) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("CompletableFuture<T> f = new CompletableFuture<>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("f.completeExceptionally(ex);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return f;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void read(ReadContext context, Double maxAge, TimestampsToReturn timestamps,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("List<ReadValueId> readValueIds) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<DataValue> results = Lists.newArrayListWithCapacity(readValueIds.size());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (ReadValueId readValueId : readValueIds) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("UaNode node = server.getNodeManager().get(readValueId.getNodeId());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (node != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("DataValue value = node.readAttribute(readValueId.getAttributeId().intValue(), timestamps,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("readValueId.getIndexRange());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("results.add(value);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("results.add(new DataValue(StatusCodes.Bad_NodeIdUnknown));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("context.complete(results);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void write(WriteContext context, List<WriteValue> writeValues) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<StatusCode> results = Lists.newArrayListWithCapacity(writeValues.size());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (WriteValue writeValue : writeValues) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("UaNode node = server.getNodeManager().get(writeValue.getNodeId());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (node != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("node.writeAttribute(server.getNamespaceManager(), writeValue.getAttributeId(),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("writeValue.getValue(), writeValue.getIndexRange());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("results.add(StatusCode.GOOD);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (UaException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("logger.error(\"Unable to write value={}\", writeValue.getValue(), e);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("results.add(e.getStatusCode());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("results.add(new StatusCode(StatusCodes.Bad_NodeIdUnknown));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("context.complete(results);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void onDataItemsCreated(List<DataItem> dataItems) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("subscriptionModel.onDataItemsCreated(dataItems);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void onDataItemsModified(List<DataItem> dataItems) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("subscriptionModel.onDataItemsModified(dataItems);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void onDataItemsDeleted(List<DataItem> dataItems) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("subscriptionModel.onDataItemsDeleted(dataItems);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("subscriptionModel.onMonitoringModeChanged(monitoredItems);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Optional<MethodInvocationHandler> getInvocationHandler(NodeId methodId) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Optional<UaNode> node = server.getNodeManager().getNode(methodId);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return node.flatMap(n -> {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (n instanceof UaMethodNode) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return ((UaMethodNode) n).getInvocationHandler();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return Optional.empty();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public UShort getNamespaceIndex() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return namespaceIndex;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getNamespaceUri() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return NAMESPACE_URI;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
}
