package de.fzi.sensidl.language.generator.factory.java.unittest;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Data;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataAdjustment;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataRange;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataSet;
import de.fzi.sensidl.design.sensidl.dataRepresentation.DataType;
import de.fzi.sensidl.design.sensidl.dataRepresentation.Interval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversion;
import de.fzi.sensidl.design.sensidl.dataRepresentation.LinearDataConversionWithInterval;
import de.fzi.sensidl.design.sensidl.dataRepresentation.ListData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.MeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.NonMeasurementData;
import de.fzi.sensidl.design.sensidl.dataRepresentation.SensorDataDescription;
import de.fzi.sensidl.language.generator.GenerationUtil;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensIDLOutputConfigurationProvider;
import de.fzi.sensidl.language.generator.factory.IDTOGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Java unit test code generator for the SensIDL Model.
 * Code will be generated by running the {@code generate()}-Method
 * 
 * @author Max Peters
 */
@SuppressWarnings("all")
public class JavaUnitTestDTOGenerator implements IDTOGenerator {
  private final static Logger logger = Logger.getLogger(JavaUnitTestDTOGenerator.class);
  
  private final String packagePrefix;
  
  private final List<DataSet> dataSet;
  
  /**
   * The constructor calls the constructor of the superclass to set a
   * list of DataSet-elements.
   * @param newDataSet - represents the list of DataSet-elements.
   */
  public JavaUnitTestDTOGenerator(final List<DataSet> newDataSet, final String newPackagePrefix) {
    this.dataSet = newDataSet;
    this.packagePrefix = newPackagePrefix;
  }
  
  /**
   * Generates the .java file for the tests of each data set.
   * @see IDTOGenerator#generate()
   */
  public HashMap<String, CharSequence> generate() {
    HashMap<String, CharSequence> _xblockexpression = null;
    {
      JavaUnitTestDTOGenerator.logger.info("Start with code-generation of a java test data transfer object.");
      final HashMap<String, CharSequence> filesToGenerate = new HashMap<String, CharSequence>();
      for (final DataSet d : this.dataSet) {
        {
          String _nameUpper = GenerationUtil.toNameUpper(d);
          String _plus = (_nameUpper + "Test");
          String _addFileExtensionTo = this.addFileExtensionTo(_plus);
          String _nameUpper_1 = GenerationUtil.toNameUpper(d);
          String _plus_1 = (_nameUpper_1 + "Test");
          CharSequence _generateClassBody = this.generateClassBody(_plus_1, d);
          filesToGenerate.put(_addFileExtensionTo, _generateClassBody);
          String _nameUpper_2 = GenerationUtil.toNameUpper(d);
          String _plus_2 = (_nameUpper_2 + "Test");
          String _addFileExtensionTo_1 = this.addFileExtensionTo(_plus_2);
          String _plus_3 = ("File: " + _addFileExtensionTo_1);
          String _plus_4 = (_plus_3 + " was generated in ");
          String _plus_5 = (_plus_4 + SensIDLOutputConfigurationProvider.SENSIDL_GEN);
          JavaUnitTestDTOGenerator.logger.info(_plus_5);
        }
      }
      _xblockexpression = filesToGenerate;
    }
    return _xblockexpression;
  }
  
  /**
   * Generates the Classes
   */
  public CharSequence generateClassBody(final String className, final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.packagePrefix, "");
    DataSet _get = this.dataSet.get(0);
    EObject _eContainer = _get.eContainer();
    String _sensorInterfaceName = GenerationUtil.getSensorInterfaceName(_eContainer);
    _builder.append(_sensorInterfaceName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import static org.junit.Assert.assertTrue;");
    _builder.newLine();
    _builder.append("import java.lang.reflect.Method;");
    _builder.newLine();
    _builder.append("import org.junit.After;");
    _builder.newLine();
    _builder.append("import org.junit.Assert;");
    _builder.newLine();
    _builder.append("import org.junit.Before;");
    _builder.newLine();
    _builder.append("import java.util.ArrayList;");
    _builder.newLine();
    _builder.append("import java.util.List;");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Test cases of ");
    int _length = className.length();
    int _minus = (_length - 4);
    String _substring = className.substring(0, _minus);
    _builder.append(_substring, " ");
    _builder.append(".");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(className, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private ");
    String _name = d.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "\t");
    _builder.append(" ");
    String _name_1 = d.getName();
    String _firstLower = StringExtensions.toFirstLower(_name_1);
    _builder.append(_firstLower, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Sets up the test environment.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Before public void setUp() {");
    _builder.newLine();
    _builder.append("\t\t");
    String _name_2 = d.getName();
    String _firstLower_1 = StringExtensions.toFirstLower(_name_2);
    _builder.append(_firstLower_1, "\t\t");
    _builder.append(" = new ");
    String _name_3 = d.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_3);
    _builder.append(_firstUpper_1, "\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Cleans the test environment.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@After public void tearDown() {");
    _builder.newLine();
    _builder.append("\t\t");
    String _name_4 = d.getName();
    String _firstLower_2 = StringExtensions.toFirstLower(_name_4);
    _builder.append(_firstLower_2, "\t\t");
    _builder.append(" = null;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generateConstructorTest = this.generateConstructorTest(d);
    _builder.append(_generateConstructorTest, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateSetterTests = this.generateSetterTests(d);
    _builder.append(_generateSetterTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateInitialValueTests = this.generateInitialValueTests(d);
    _builder.append(_generateInitialValueTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateExcludedMethodsTest = this.generateExcludedMethodsTest(d);
    _builder.append(_generateExcludedMethodsTest, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateRangeAdjustmentTests = this.generateRangeAdjustmentTests(d);
    _builder.append(_generateRangeAdjustmentTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateLinearDataConversionTests = this.generateLinearDataConversionTests(d);
    _builder.append(_generateLinearDataConversionTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateLinearDataConversionWithIntervalTests = this.generateLinearDataConversionWithIntervalTests(d);
    _builder.append(_generateLinearDataConversionWithIntervalTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generateListTests = this.generateListTests(d);
    _builder.append(_generateListTests, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates test cases for all list datas of a data set.
   */
  public CharSequence generateListTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<ListData> _filter = Iterables.<ListData>filter(_data, ListData.class);
      for(final ListData data : _filter) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Test case for setter of list ");
        String _name = data.getName();
        String _firstUpper = StringExtensions.toFirstUpper(_name);
        _builder.append(_firstUpper, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* testing basic functionality");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t");
        _builder.newLine();
        _builder.append("@org.junit.Test public void test");
        String _name_1 = data.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
        _builder.append(_firstUpper_1, "");
        _builder.append("ListSetter() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("List<");
        String _typeName = this.toTypeName(data);
        _builder.append(_typeName, "\t");
        _builder.append("> list = new ArrayList<");
        String _typeName_1 = this.toTypeName(data);
        _builder.append(_typeName_1, "\t");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_2 = d.getName();
        String _firstLower = StringExtensions.toFirstLower(_name_2);
        _builder.append(_firstLower, "\t");
        _builder.append(".set");
        String _name_3 = data.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
        _builder.append(_firstUpper_2, "\t");
        _builder.append("(list);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("assertTrue(");
        String _name_4 = d.getName();
        String _firstLower_1 = StringExtensions.toFirstLower(_name_4);
        _builder.append(_firstLower_1, "\t");
        _builder.append(".get");
        String _name_5 = data.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper(_name_5);
        _builder.append(_firstUpper_3, "\t");
        _builder.append("().equals(list));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Test case for add(*) of ");
        String _name_6 = data.getName();
        String _firstUpper_4 = StringExtensions.toFirstUpper(_name_6);
        _builder.append(_firstUpper_4, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* testing basic functionality");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t");
        _builder.newLine();
        _builder.append("@org.junit.Test public void test");
        String _name_7 = data.getName();
        String _firstUpper_5 = StringExtensions.toFirstUpper(_name_7);
        _builder.append(_firstUpper_5, "");
        _builder.append("AddToList() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_8 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower(_name_8);
        _builder.append(_firstLower_2, "\t");
        _builder.append(".add");
        String _name_9 = data.getName();
        String _firstUpper_6 = StringExtensions.toFirstUpper(_name_9);
        _builder.append(_firstUpper_6, "\t");
        _builder.append("(");
        DataType _dataType = data.getDataType();
        Object _minValue = this.getMinValue(data);
        CharSequence _numberWithCast = this.getNumberWithCast(_dataType, _minValue);
        _builder.append(_numberWithCast, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_10 = d.getName();
        String _firstLower_3 = StringExtensions.toFirstLower(_name_10);
        _builder.append(_firstLower_3, "\t");
        _builder.append(".add");
        String _name_11 = data.getName();
        String _firstUpper_7 = StringExtensions.toFirstUpper(_name_11);
        _builder.append(_firstUpper_7, "\t");
        _builder.append("(");
        DataType _dataType_1 = data.getDataType();
        Object _maxValue = this.getMaxValue(data);
        CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _maxValue);
        _builder.append(_numberWithCast_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("assertTrue(");
        String _name_12 = d.getName();
        String _firstLower_4 = StringExtensions.toFirstLower(_name_12);
        _builder.append(_firstLower_4, "\t");
        _builder.append(".get");
        String _name_13 = data.getName();
        String _firstUpper_8 = StringExtensions.toFirstUpper(_name_13);
        _builder.append(_firstUpper_8, "\t");
        _builder.append("(");
        DataType _dataType_2 = data.getDataType();
        Object _minValue_1 = this.getMinValue(data);
        CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, _minValue_1);
        _builder.append(_numberWithCast_2, "\t");
        _builder.append(") == ");
        DataType _dataType_3 = data.getDataType();
        Object _minValue_2 = this.getMinValue(data);
        CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_3, _minValue_2);
        _builder.append(_numberWithCast_3, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("assertTrue(");
        String _name_14 = d.getName();
        String _firstLower_5 = StringExtensions.toFirstLower(_name_14);
        _builder.append(_firstLower_5, "\t");
        _builder.append(".get");
        String _name_15 = data.getName();
        String _firstUpper_9 = StringExtensions.toFirstUpper(_name_15);
        _builder.append(_firstUpper_9, "\t");
        _builder.append("(");
        DataType _dataType_4 = data.getDataType();
        Object _maxValue_1 = this.getMaxValue(data);
        CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_4, _maxValue_1);
        _builder.append(_numberWithCast_4, "\t");
        _builder.append(") == ");
        DataType _dataType_5 = data.getDataType();
        Object _maxValue_2 = this.getMaxValue(data);
        CharSequence _numberWithCast_5 = this.getNumberWithCast(_dataType_5, _maxValue_2);
        _builder.append(_numberWithCast_5, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * Generates test cases for all measurement datas with linear data conversion with interval of a data set.
   */
  public CharSequence generateLinearDataConversionWithIntervalTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_data, MeasurementData.class);
      for(final MeasurementData data : _filter) {
        {
          EList<DataAdjustment> _adjustments = data.getAdjustments();
          for(final DataAdjustment adj : _adjustments) {
            {
              if ((adj instanceof LinearDataConversionWithInterval)) {
                {
                  EList<String> _excludedMethods = data.getExcludedMethods();
                  boolean _contains = _excludedMethods.contains("setter");
                  boolean _not = (!_contains);
                  if (_not) {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with linear data conversion with interval of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper(_name);
                    _builder.append(_firstUpper, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing conversion");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
                    _builder.append(_firstUpper_1, "");
                    _builder.append("SetterWithLinearDataConversionWithIntervalPositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName = this.toTypeName(data);
                    _builder.append(_typeName, "\t");
                    _builder.append(" minValue = ");
                    DataType _dataType = data.getDataType();
                    Interval _fromInterval = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound = _fromInterval.getLowerBound();
                    CharSequence _numberWithCast = this.getNumberWithCast(_dataType, Double.valueOf(_lowerBound));
                    _builder.append(_numberWithCast, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_1 = this.toTypeName(data);
                    _builder.append(_typeName_1, "\t");
                    _builder.append(" maxValue = ");
                    DataType _dataType_1 = data.getDataType();
                    Interval _fromInterval_1 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound = _fromInterval_1.getUpperBound();
                    CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, Double.valueOf(_upperBound));
                    _builder.append(_numberWithCast_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_2 = this.toTypeName(data);
                    _builder.append(_typeName_2, "\t");
                    _builder.append(" midValue = ");
                    DataType _dataType_2 = data.getDataType();
                    Interval _fromInterval_2 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_1 = _fromInterval_2.getUpperBound();
                    Interval _fromInterval_3 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_1 = _fromInterval_3.getLowerBound();
                    double _minus = (_upperBound_1 - _lowerBound_1);
                    double _divide = (_minus / 2);
                    Interval _fromInterval_4 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_2 = _fromInterval_4.getLowerBound();
                    double _plus = (_divide + _lowerBound_2);
                    CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, Double.valueOf(_plus));
                    _builder.append(_numberWithCast_2, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    DataType _dataType_3 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_3 = this.toTypeName(_dataType_3);
                    _builder.append(_typeName_3, "\t");
                    _builder.append(" minValueAdj = (");
                    DataType _dataType_4 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName = this.toSimpleTypeName(_dataType_4);
                    _builder.append(_simpleTypeName, "\t");
                    _builder.append(") (");
                    Interval _fromInterval_5 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_3 = _fromInterval_5.getLowerBound();
                    Interval _fromInterval_6 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_4 = _fromInterval_6.getLowerBound();
                    Interval _fromInterval_7 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_2 = _fromInterval_7.getUpperBound();
                    Interval _toInterval = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_5 = _toInterval.getLowerBound();
                    Interval _toInterval_1 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_3 = _toInterval_1.getUpperBound();
                    CharSequence _linearDataConversionWithInterval = this.getLinearDataConversionWithInterval(Double.valueOf(_lowerBound_3), _lowerBound_4, _upperBound_2, _lowerBound_5, _upperBound_3);
                    _builder.append(_linearDataConversionWithInterval, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    DataType _dataType_5 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_4 = this.toTypeName(_dataType_5);
                    _builder.append(_typeName_4, "\t");
                    _builder.append(" maxValueAdj = (");
                    DataType _dataType_6 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName_1 = this.toSimpleTypeName(_dataType_6);
                    _builder.append(_simpleTypeName_1, "\t");
                    _builder.append(") (");
                    Interval _fromInterval_8 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_4 = _fromInterval_8.getUpperBound();
                    Interval _fromInterval_9 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_6 = _fromInterval_9.getLowerBound();
                    Interval _fromInterval_10 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_5 = _fromInterval_10.getUpperBound();
                    Interval _toInterval_2 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_7 = _toInterval_2.getLowerBound();
                    Interval _toInterval_3 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_6 = _toInterval_3.getUpperBound();
                    CharSequence _linearDataConversionWithInterval_1 = this.getLinearDataConversionWithInterval(Double.valueOf(_upperBound_4), _lowerBound_6, _upperBound_5, _lowerBound_7, _upperBound_6);
                    _builder.append(_linearDataConversionWithInterval_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    DataType _dataType_7 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _typeName_5 = this.toTypeName(_dataType_7);
                    _builder.append(_typeName_5, "\t");
                    _builder.append(" midValueAdj = (");
                    DataType _dataType_8 = ((LinearDataConversionWithInterval)adj).getDataType();
                    String _simpleTypeName_2 = this.toSimpleTypeName(_dataType_8);
                    _builder.append(_simpleTypeName_2, "\t");
                    _builder.append(") (");
                    DataType _dataType_9 = data.getDataType();
                    Interval _fromInterval_11 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_7 = _fromInterval_11.getUpperBound();
                    Interval _fromInterval_12 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_8 = _fromInterval_12.getLowerBound();
                    double _minus_1 = (_upperBound_7 - _lowerBound_8);
                    double _divide_1 = (_minus_1 / 2);
                    Interval _fromInterval_13 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_9 = _fromInterval_13.getLowerBound();
                    double _plus_1 = (_divide_1 + _lowerBound_9);
                    Number _dataType_10 = this.toDataType(_dataType_9, Double.valueOf(_plus_1));
                    double _doubleValue = _dataType_10.doubleValue();
                    Interval _fromInterval_14 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _lowerBound_10 = _fromInterval_14.getLowerBound();
                    Interval _fromInterval_15 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                    double _upperBound_8 = _fromInterval_15.getUpperBound();
                    Interval _toInterval_4 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _lowerBound_11 = _toInterval_4.getLowerBound();
                    Interval _toInterval_5 = ((LinearDataConversionWithInterval)adj).getToInterval();
                    double _upperBound_9 = _toInterval_5.getUpperBound();
                    CharSequence _linearDataConversionWithInterval_2 = this.getLinearDataConversionWithInterval(Double.valueOf(_doubleValue), _lowerBound_10, _upperBound_8, _lowerBound_11, _upperBound_9);
                    _builder.append(_linearDataConversionWithInterval_2, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _name_2 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower(_name_2);
                    _builder.append(_firstLower, "\t");
                    _builder.append(".set");
                    String _name_3 = data.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
                    _builder.append(_firstUpper_2, "\t");
                    _builder.append("WithDataConversion(minValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_1 = data.getExcludedMethods();
                      boolean _contains_1 = _excludedMethods_1.contains("getter");
                      boolean _not_1 = (!_contains_1);
                      if (_not_1) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_4 = d.getName();
                        String _firstLower_1 = StringExtensions.toFirstLower(_name_4);
                        _builder.append(_firstLower_1, "\t");
                        _builder.append(".get");
                        String _name_5 = data.getName();
                        String _firstUpper_3 = StringExtensions.toFirstUpper(_name_5);
                        _builder.append(_firstUpper_3, "\t");
                        _builder.append("().equals(minValueAdj));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_6 = data.getName();
                        String _firstUpper_4 = StringExtensions.toFirstUpper(_name_6);
                        _builder.append(_firstUpper_4, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    String _name_7 = d.getName();
                    String _firstLower_2 = StringExtensions.toFirstLower(_name_7);
                    _builder.append(_firstLower_2, "\t");
                    _builder.append(".set");
                    String _name_8 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper(_name_8);
                    _builder.append(_firstUpper_5, "\t");
                    _builder.append("WithDataConversion(maxValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_2 = data.getExcludedMethods();
                      boolean _contains_2 = _excludedMethods_2.contains("getter");
                      boolean _not_2 = (!_contains_2);
                      if (_not_2) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_9 = d.getName();
                        String _firstLower_3 = StringExtensions.toFirstLower(_name_9);
                        _builder.append(_firstLower_3, "\t");
                        _builder.append(".get");
                        String _name_10 = data.getName();
                        String _firstUpper_6 = StringExtensions.toFirstUpper(_name_10);
                        _builder.append(_firstUpper_6, "\t");
                        _builder.append("().equals(maxValueAdj));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_11 = data.getName();
                        String _firstUpper_7 = StringExtensions.toFirstUpper(_name_11);
                        _builder.append(_firstUpper_7, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    String _name_12 = d.getName();
                    String _firstLower_4 = StringExtensions.toFirstLower(_name_12);
                    _builder.append(_firstLower_4, "\t");
                    _builder.append(".set");
                    String _name_13 = data.getName();
                    String _firstUpper_8 = StringExtensions.toFirstUpper(_name_13);
                    _builder.append(_firstUpper_8, "\t");
                    _builder.append("WithDataConversion(midValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_3 = data.getExcludedMethods();
                      boolean _contains_3 = _excludedMethods_3.contains("getter");
                      boolean _not_3 = (!_contains_3);
                      if (_not_3) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_14 = d.getName();
                        String _firstLower_5 = StringExtensions.toFirstLower(_name_14);
                        _builder.append(_firstLower_5, "\t");
                        _builder.append(".get");
                        String _name_15 = data.getName();
                        String _firstUpper_9 = StringExtensions.toFirstUpper(_name_15);
                        _builder.append(_firstUpper_9, "\t");
                        _builder.append("().equals(midValueAdj));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_16 = data.getName();
                        String _firstUpper_10 = StringExtensions.toFirstUpper(_name_16);
                        _builder.append(_firstUpper_10, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with linear data conversion with interval of ");
                    String _name_17 = data.getName();
                    String _firstUpper_11 = StringExtensions.toFirstUpper(_name_17);
                    _builder.append(_firstUpper_11, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing overflow");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_18 = data.getName();
                    String _firstUpper_12 = StringExtensions.toFirstUpper(_name_18);
                    _builder.append(_firstUpper_12, "");
                    _builder.append("SetterWithLinearDataConversionWithIntervalNegativHigher() {");
                    _builder.newLineIfNotEmpty();
                    {
                      Interval _fromInterval_16 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                      double _upperBound_10 = _fromInterval_16.getUpperBound();
                      double _plus_2 = (_upperBound_10 + 1);
                      Object _maxValue = this.getMaxValue(data);
                      String _string = _maxValue.toString();
                      Double _valueOf = Double.valueOf(_string);
                      boolean _lessEqualsThan = (_plus_2 <= (_valueOf).doubleValue());
                      if (_lessEqualsThan) {
                        _builder.append("\t");
                        String _typeName_6 = this.toTypeName(data);
                        _builder.append(_typeName_6, "\t");
                        _builder.append(" value = ");
                        DataType _dataType_11 = data.getDataType();
                        Interval _fromInterval_17 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _upperBound_11 = _fromInterval_17.getUpperBound();
                        double _plus_3 = (_upperBound_11 + 1);
                        CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_11, Double.valueOf(_plus_3));
                        _builder.append(_numberWithCast_3, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        String _name_19 = d.getName();
                        String _firstLower_6 = StringExtensions.toFirstLower(_name_19);
                        _builder.append(_firstLower_6, "\t");
                        _builder.append(".set");
                        String _name_20 = data.getName();
                        String _firstUpper_13 = StringExtensions.toFirstUpper(_name_20);
                        _builder.append(_firstUpper_13, "\t");
                        _builder.append("WithDataConversion(value);");
                        _builder.newLineIfNotEmpty();
                        {
                          EList<String> _excludedMethods_4 = data.getExcludedMethods();
                          boolean _contains_4 = _excludedMethods_4.contains("getter");
                          boolean _not_4 = (!_contains_4);
                          if (_not_4) {
                            _builder.append("\t");
                            _builder.append("assertTrue(");
                            String _name_21 = d.getName();
                            String _firstLower_7 = StringExtensions.toFirstLower(_name_21);
                            _builder.append(_firstLower_7, "\t");
                            _builder.append(".get");
                            String _name_22 = data.getName();
                            String _firstUpper_14 = StringExtensions.toFirstUpper(_name_22);
                            _builder.append(_firstUpper_14, "\t");
                            _builder.append("() == null);");
                            _builder.newLineIfNotEmpty();
                          } else {
                            _builder.append("\t");
                            _builder.append("//no getter for ");
                            String _name_23 = data.getName();
                            String _firstUpper_15 = StringExtensions.toFirstUpper(_name_23);
                            _builder.append(_firstUpper_15, "\t");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append("\t");
                        _builder.append("//test value ");
                        Interval _fromInterval_18 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _upperBound_12 = _fromInterval_18.getUpperBound();
                        double _plus_4 = (_upperBound_12 + 1);
                        _builder.append(_plus_4, "\t");
                        _builder.append(" causes overflow");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with linear data conversion with interval of ");
                    String _name_24 = data.getName();
                    String _firstUpper_16 = StringExtensions.toFirstUpper(_name_24);
                    _builder.append(_firstUpper_16, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing underflow");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_25 = data.getName();
                    String _firstUpper_17 = StringExtensions.toFirstUpper(_name_25);
                    _builder.append(_firstUpper_17, "");
                    _builder.append("SetterWithLinearDataConversionWithIntervalNegativLower() {");
                    _builder.newLineIfNotEmpty();
                    {
                      Interval _fromInterval_19 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                      double _lowerBound_12 = _fromInterval_19.getLowerBound();
                      double _minus_2 = (_lowerBound_12 - 1);
                      Object _minValue = this.getMinValue(data);
                      String _string_1 = _minValue.toString();
                      Double _valueOf_1 = Double.valueOf(_string_1);
                      boolean _greaterEqualsThan = (_minus_2 >= (_valueOf_1).doubleValue());
                      if (_greaterEqualsThan) {
                        _builder.append("\t");
                        String _typeName_7 = this.toTypeName(data);
                        _builder.append(_typeName_7, "\t");
                        _builder.append(" value = ");
                        DataType _dataType_12 = data.getDataType();
                        Interval _fromInterval_20 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_13 = _fromInterval_20.getLowerBound();
                        double _minus_3 = (_lowerBound_13 - 1);
                        CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_12, Double.valueOf(_minus_3));
                        _builder.append(_numberWithCast_4, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        String _name_26 = d.getName();
                        String _firstLower_8 = StringExtensions.toFirstLower(_name_26);
                        _builder.append(_firstLower_8, "\t");
                        _builder.append(".set");
                        String _name_27 = data.getName();
                        String _firstUpper_18 = StringExtensions.toFirstUpper(_name_27);
                        _builder.append(_firstUpper_18, "\t");
                        _builder.append("WithDataConversion(value);");
                        _builder.newLineIfNotEmpty();
                        {
                          EList<String> _excludedMethods_5 = data.getExcludedMethods();
                          boolean _contains_5 = _excludedMethods_5.contains("getter");
                          boolean _not_5 = (!_contains_5);
                          if (_not_5) {
                            _builder.append("\t");
                            _builder.append("assertTrue(");
                            String _name_28 = d.getName();
                            String _firstLower_9 = StringExtensions.toFirstLower(_name_28);
                            _builder.append(_firstLower_9, "\t");
                            _builder.append(".get");
                            String _name_29 = data.getName();
                            String _firstUpper_19 = StringExtensions.toFirstUpper(_name_29);
                            _builder.append(_firstUpper_19, "\t");
                            _builder.append("() == null);");
                            _builder.newLineIfNotEmpty();
                          } else {
                            _builder.append("\t");
                            _builder.append("//no getter for ");
                            String _name_30 = data.getName();
                            String _firstUpper_20 = StringExtensions.toFirstUpper(_name_30);
                            _builder.append(_firstUpper_20, "\t");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append("\t");
                        _builder.append("//");
                        Interval _fromInterval_21 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_14 = _fromInterval_21.getLowerBound();
                        double _minus_4 = (_lowerBound_14 - 1);
                        String _plus_5 = (Double.valueOf(_minus_4) + " ");
                        Object _minValue_1 = this.getMinValue(data);
                        String _string_2 = _minValue_1.toString();
                        Double _valueOf_2 = Double.valueOf(_string_2);
                        String _plus_6 = (_plus_5 + _valueOf_2);
                        String _plus_7 = (_plus_6 + " ");
                        Interval _fromInterval_22 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_15 = _fromInterval_22.getLowerBound();
                        double _minus_5 = (_lowerBound_15 - 1);
                        Object _minValue_2 = this.getMinValue(data);
                        String _string_3 = _minValue_2.toString();
                        Double _valueOf_3 = Double.valueOf(_string_3);
                        boolean _lessThan = (_minus_5 < (_valueOf_3).doubleValue());
                        String _plus_8 = (_plus_7 + Boolean.valueOf(_lessThan));
                        System.out.println(_plus_8);
                        Interval _fromInterval_23 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_16 = _fromInterval_23.getLowerBound();
                        double _minus_6 = (_lowerBound_16 - 1);
                        Object _minValue_3 = this.getMinValue(data);
                        String _string_4 = _minValue_3.toString();
                        Double _valueOf_4 = Double.valueOf(_string_4);
                        boolean _greaterEqualsThan_1 = (_minus_6 >= (_valueOf_4).doubleValue());
                        _builder.append(_greaterEqualsThan_1, "\t");
                        Object _minValue_4 = this.getMinValue(data);
                        String _string_5 = _minValue_4.toString();
                        Double _valueOf_5 = Double.valueOf(_string_5);
                        _builder.append(_valueOf_5, "\t");
                        _builder.append(" test value ");
                        Interval _fromInterval_24 = ((LinearDataConversionWithInterval)adj).getFromInterval();
                        double _lowerBound_17 = _fromInterval_24.getLowerBound();
                        double _minus_7 = (_lowerBound_17 - 1);
                        _builder.append(_minus_7, "\t");
                        _builder.append(" causes underflow");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  } else {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for excluded setter with linear data conversion with interval of ");
                    String _name_31 = data.getName();
                    String _firstUpper_21 = StringExtensions.toFirstUpper(_name_31);
                    _builder.append(_firstUpper_21, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing existence");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_32 = data.getName();
                    String _firstUpper_22 = StringExtensions.toFirstUpper(_name_32);
                    _builder.append(_firstUpper_22, "");
                    _builder.append("ExcludedSetterWithDataConversion() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("for (Method m : ");
                    String _name_33 = d.getName();
                    String _firstLower_10 = StringExtensions.toFirstLower(_name_33);
                    _builder.append(_firstLower_10, "\t");
                    _builder.append(".getClass().getMethods()) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("Assert.assertNotEquals(m.getName(), \"set");
                    String _name_34 = data.getName();
                    String _firstUpper_23 = StringExtensions.toFirstUpper(_name_34);
                    _builder.append(_firstUpper_23, "\t\t");
                    _builder.append("WithDataConversion\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Generates test cases for all measurement datas with linear data conversion of a data set.
   */
  public CharSequence generateLinearDataConversionTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_data, MeasurementData.class);
      for(final MeasurementData data : _filter) {
        {
          EList<DataAdjustment> _adjustments = data.getAdjustments();
          for(final DataAdjustment adj : _adjustments) {
            {
              if ((adj instanceof LinearDataConversion)) {
                {
                  EList<String> _excludedMethods = data.getExcludedMethods();
                  boolean _contains = _excludedMethods.contains("setter");
                  boolean _not = (!_contains);
                  if (_not) {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with linear data conversion of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper(_name);
                    _builder.append(_firstUpper, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing conversion");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
                    _builder.append(_firstUpper_1, "");
                    _builder.append("SetterWithLinearDataConversionPositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName = this.toTypeName(data);
                    _builder.append(_typeName, "\t");
                    _builder.append(" value = ");
                    DataType _dataType = data.getDataType();
                    Object _maxValue = this.getMaxValue(data);
                    String _string = _maxValue.toString();
                    Double _valueOf = Double.valueOf(_string);
                    double _scalingFactor = ((LinearDataConversion)adj).getScalingFactor();
                    double _multiply = (_scalingFactor * 10);
                    double _divide = ((_valueOf).doubleValue() / _multiply);
                    double _offset = ((LinearDataConversion)adj).getOffset();
                    double _minus = (_divide - _offset);
                    CharSequence _numberWithCast = this.getNumberWithCast(_dataType, Double.valueOf(_minus));
                    _builder.append(_numberWithCast, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _name_2 = d.getName();
                    String _firstLower = StringExtensions.toFirstLower(_name_2);
                    _builder.append(_firstLower, "\t");
                    _builder.append(".set");
                    String _name_3 = data.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
                    _builder.append(_firstUpper_2, "\t");
                    _builder.append("WithDataConversion(value);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_1 = data.getExcludedMethods();
                      boolean _contains_1 = _excludedMethods_1.contains("getter");
                      boolean _not_1 = (!_contains_1);
                      if (_not_1) {
                        _builder.append("\t");
                        _builder.append("Double d = (value * ");
                        double _scalingFactor_1 = ((LinearDataConversion)adj).getScalingFactor();
                        _builder.append(_scalingFactor_1, "\t");
                        _builder.append(") + ");
                        double _offset_1 = ((LinearDataConversion)adj).getOffset();
                        _builder.append(_offset_1, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_4 = d.getName();
                        String _firstLower_1 = StringExtensions.toFirstLower(_name_4);
                        _builder.append(_firstLower_1, "\t");
                        _builder.append(".get");
                        String _name_5 = data.getName();
                        String _firstUpper_3 = StringExtensions.toFirstUpper(_name_5);
                        _builder.append(_firstUpper_3, "\t");
                        _builder.append("().equals(d.");
                        String _typeName_1 = this.toTypeName(data);
                        String _typeName_2 = this.toTypeName(data);
                        int _lastIndexOf = _typeName_2.lastIndexOf(".");
                        int _plus = (_lastIndexOf + 1);
                        String _typeName_3 = this.toTypeName(data);
                        int _length = _typeName_3.length();
                        String _substring = _typeName_1.substring(_plus, _length);
                        String _firstLower_2 = StringExtensions.toFirstLower(_substring);
                        String _replace = _firstLower_2.replace("integer", "int");
                        _builder.append(_replace, "\t");
                        _builder.append("Value()));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_6 = data.getName();
                        String _firstUpper_4 = StringExtensions.toFirstUpper(_name_6);
                        _builder.append(_firstUpper_4, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with linear data conversion of ");
                    String _name_7 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper(_name_7);
                    _builder.append(_firstUpper_5, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing overflow");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_8 = data.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper(_name_8);
                    _builder.append(_firstUpper_6, "");
                    _builder.append("SetterWithLinearDataConversionNegativ() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_4 = this.toTypeName(data);
                    _builder.append(_typeName_4, "\t");
                    _builder.append(" value = ");
                    DataType _dataType_1 = data.getDataType();
                    Object _maxValue_1 = this.getMaxValue(data);
                    String _string_1 = _maxValue_1.toString();
                    Double _valueOf_1 = Double.valueOf(_string_1);
                    CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, _valueOf_1);
                    _builder.append(_numberWithCast_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _name_9 = d.getName();
                    String _firstLower_3 = StringExtensions.toFirstLower(_name_9);
                    _builder.append(_firstLower_3, "\t");
                    _builder.append(".set");
                    String _name_10 = data.getName();
                    String _firstUpper_7 = StringExtensions.toFirstUpper(_name_10);
                    _builder.append(_firstUpper_7, "\t");
                    _builder.append("WithDataConversion(value);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_2 = data.getExcludedMethods();
                      boolean _contains_2 = _excludedMethods_2.contains("getter");
                      boolean _not_2 = (!_contains_2);
                      if (_not_2) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_11 = d.getName();
                        String _firstLower_4 = StringExtensions.toFirstLower(_name_11);
                        _builder.append(_firstLower_4, "\t");
                        _builder.append(".get");
                        String _name_12 = data.getName();
                        String _firstUpper_8 = StringExtensions.toFirstUpper(_name_12);
                        _builder.append(_firstUpper_8, "\t");
                        _builder.append("() == null);");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_13 = data.getName();
                        String _firstUpper_9 = StringExtensions.toFirstUpper(_name_13);
                        _builder.append(_firstUpper_9, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  } else {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for excluded setter with linear data conversion of ");
                    String _name_14 = data.getName();
                    String _firstUpper_10 = StringExtensions.toFirstUpper(_name_14);
                    _builder.append(_firstUpper_10, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing existence");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_15 = data.getName();
                    String _firstUpper_11 = StringExtensions.toFirstUpper(_name_15);
                    _builder.append(_firstUpper_11, "");
                    _builder.append("ExcludedSetterWithDataConversion() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("for (Method m : ");
                    String _name_16 = d.getName();
                    String _firstLower_5 = StringExtensions.toFirstLower(_name_16);
                    _builder.append(_firstLower_5, "\t");
                    _builder.append(".getClass().getMethods()) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("Assert.assertNotEquals(m.getName(), \"set");
                    String _name_17 = data.getName();
                    String _firstUpper_12 = StringExtensions.toFirstUpper(_name_17);
                    _builder.append(_firstUpper_12, "\t\t");
                    _builder.append("WithDataConversion\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Generates test cases for all measurement datas with range adjustment of a data set.
   */
  public CharSequence generateRangeAdjustmentTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<MeasurementData> _filter = Iterables.<MeasurementData>filter(_data, MeasurementData.class);
      for(final MeasurementData data : _filter) {
        {
          EList<DataAdjustment> _adjustments = data.getAdjustments();
          for(final DataAdjustment adj : _adjustments) {
            {
              if ((adj instanceof DataRange)) {
                {
                  EList<String> _excludedMethods = data.getExcludedMethods();
                  boolean _contains = _excludedMethods.contains("setter");
                  boolean _not = (!_contains);
                  if (_not) {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with range of ");
                    String _name = data.getName();
                    String _firstUpper = StringExtensions.toFirstUpper(_name);
                    _builder.append(_firstUpper, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing range overflow");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test (expected = IllegalArgumentException.class) public void test");
                    String _name_1 = data.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
                    _builder.append(_firstUpper_1, "");
                    _builder.append("SetterWithRangeNegativHigher() {");
                    _builder.newLineIfNotEmpty();
                    {
                      Interval _range = ((DataRange)adj).getRange();
                      double _upperBound = _range.getUpperBound();
                      double _plus = (_upperBound + 1);
                      Object _maxValue = this.getMaxValue(data);
                      String _string = _maxValue.toString();
                      Double _valueOf = Double.valueOf(_string);
                      boolean _lessEqualsThan = (_plus <= (_valueOf).doubleValue());
                      if (_lessEqualsThan) {
                        _builder.append("\t");
                        String _typeName = this.toTypeName(data);
                        _builder.append(_typeName, "\t");
                        _builder.append(" value = ");
                        DataType _dataType = data.getDataType();
                        Interval _range_1 = ((DataRange)adj).getRange();
                        double _upperBound_1 = _range_1.getUpperBound();
                        double _plus_1 = (_upperBound_1 + 1);
                        CharSequence _numberWithCast = this.getNumberWithCast(_dataType, Double.valueOf(_plus_1));
                        _builder.append(_numberWithCast, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        String _name_2 = d.getName();
                        String _firstLower = StringExtensions.toFirstLower(_name_2);
                        _builder.append(_firstLower, "\t");
                        _builder.append(".set");
                        String _name_3 = data.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
                        _builder.append(_firstUpper_2, "\t");
                        _builder.append("WithRange(value);");
                        _builder.newLineIfNotEmpty();
                        {
                          EList<String> _excludedMethods_1 = data.getExcludedMethods();
                          boolean _contains_1 = _excludedMethods_1.contains("getter");
                          boolean _not_1 = (!_contains_1);
                          if (_not_1) {
                            _builder.append("\t");
                            _builder.append("assertTrue(");
                            String _name_4 = d.getName();
                            String _firstLower_1 = StringExtensions.toFirstLower(_name_4);
                            _builder.append(_firstLower_1, "\t");
                            _builder.append(".get");
                            String _name_5 = data.getName();
                            String _firstUpper_3 = StringExtensions.toFirstUpper(_name_5);
                            _builder.append(_firstUpper_3, "\t");
                            _builder.append("().equals(value));");
                            _builder.newLineIfNotEmpty();
                          } else {
                            _builder.append("\t");
                            _builder.append("//no getter for ");
                            String _name_6 = data.getName();
                            String _firstUpper_4 = StringExtensions.toFirstUpper(_name_6);
                            _builder.append(_firstUpper_4, "\t");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append("\t");
                        _builder.append("//test value ");
                        Interval _range_2 = ((DataRange)adj).getRange();
                        double _upperBound_2 = _range_2.getUpperBound();
                        double _plus_2 = (_upperBound_2 + 1);
                        _builder.append(_plus_2, "\t");
                        _builder.append(" causes overflow");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with range of ");
                    String _name_7 = data.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper(_name_7);
                    _builder.append(_firstUpper_5, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing range underflow");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test (expected = IllegalArgumentException.class) public void test");
                    String _name_8 = data.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper(_name_8);
                    _builder.append(_firstUpper_6, "");
                    _builder.append("SetterWithRangeNegativLower() {");
                    _builder.newLineIfNotEmpty();
                    {
                      Interval _range_3 = ((DataRange)adj).getRange();
                      double _lowerBound = _range_3.getLowerBound();
                      double _minus = (_lowerBound - 1);
                      Object _minValue = this.getMinValue(data);
                      String _string_1 = _minValue.toString();
                      Double _valueOf_1 = Double.valueOf(_string_1);
                      boolean _greaterEqualsThan = (_minus >= (_valueOf_1).doubleValue());
                      if (_greaterEqualsThan) {
                        _builder.append("\t");
                        String _typeName_1 = this.toTypeName(data);
                        _builder.append(_typeName_1, "\t");
                        _builder.append(" value = ");
                        DataType _dataType_1 = data.getDataType();
                        Interval _range_4 = ((DataRange)adj).getRange();
                        double _lowerBound_1 = _range_4.getLowerBound();
                        double _minus_1 = (_lowerBound_1 - 1);
                        CharSequence _numberWithCast_1 = this.getNumberWithCast(_dataType_1, Double.valueOf(_minus_1));
                        _builder.append(_numberWithCast_1, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        String _name_9 = d.getName();
                        String _firstLower_2 = StringExtensions.toFirstLower(_name_9);
                        _builder.append(_firstLower_2, "\t");
                        _builder.append(".set");
                        String _name_10 = data.getName();
                        String _firstUpper_7 = StringExtensions.toFirstUpper(_name_10);
                        _builder.append(_firstUpper_7, "\t");
                        _builder.append("WithRange(value);");
                        _builder.newLineIfNotEmpty();
                        {
                          EList<String> _excludedMethods_2 = data.getExcludedMethods();
                          boolean _contains_2 = _excludedMethods_2.contains("getter");
                          boolean _not_2 = (!_contains_2);
                          if (_not_2) {
                            _builder.append("\t");
                            _builder.append("assertTrue(");
                            String _name_11 = d.getName();
                            String _firstLower_3 = StringExtensions.toFirstLower(_name_11);
                            _builder.append(_firstLower_3, "\t");
                            _builder.append(".get");
                            String _name_12 = data.getName();
                            String _firstUpper_8 = StringExtensions.toFirstUpper(_name_12);
                            _builder.append(_firstUpper_8, "\t");
                            _builder.append("().equals(value));");
                            _builder.newLineIfNotEmpty();
                          } else {
                            _builder.append("\t");
                            _builder.append("//no getter for ");
                            String _name_13 = data.getName();
                            String _firstUpper_9 = StringExtensions.toFirstUpper(_name_13);
                            _builder.append(_firstUpper_9, "\t");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append("\t");
                        _builder.append("//test value ");
                        Interval _range_5 = ((DataRange)adj).getRange();
                        double _lowerBound_2 = _range_5.getLowerBound();
                        double _minus_2 = (_lowerBound_2 - 1);
                        _builder.append(_minus_2, "\t");
                        _builder.append(" causes underflow");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for setter with range of ");
                    String _name_14 = data.getName();
                    String _firstUpper_10 = StringExtensions.toFirstUpper(_name_14);
                    _builder.append(_firstUpper_10, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing with valid values");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_15 = data.getName();
                    String _firstUpper_11 = StringExtensions.toFirstUpper(_name_15);
                    _builder.append(_firstUpper_11, "");
                    _builder.append("SetterWithRangePositiv() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_2 = this.toTypeName(data);
                    _builder.append(_typeName_2, "\t");
                    _builder.append(" minValue = ");
                    DataType _dataType_2 = data.getDataType();
                    Interval _range_6 = ((DataRange)adj).getRange();
                    double _lowerBound_3 = _range_6.getLowerBound();
                    CharSequence _numberWithCast_2 = this.getNumberWithCast(_dataType_2, Double.valueOf(_lowerBound_3));
                    _builder.append(_numberWithCast_2, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_3 = this.toTypeName(data);
                    _builder.append(_typeName_3, "\t");
                    _builder.append(" maxValue = ");
                    DataType _dataType_3 = data.getDataType();
                    Interval _range_7 = ((DataRange)adj).getRange();
                    double _upperBound_3 = _range_7.getUpperBound();
                    CharSequence _numberWithCast_3 = this.getNumberWithCast(_dataType_3, Double.valueOf(_upperBound_3));
                    _builder.append(_numberWithCast_3, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _typeName_4 = this.toTypeName(data);
                    _builder.append(_typeName_4, "\t");
                    _builder.append(" midValue = ");
                    DataType _dataType_4 = data.getDataType();
                    Interval _range_8 = ((DataRange)adj).getRange();
                    double _upperBound_4 = _range_8.getUpperBound();
                    Interval _range_9 = ((DataRange)adj).getRange();
                    double _lowerBound_4 = _range_9.getLowerBound();
                    double _minus_3 = (_upperBound_4 - _lowerBound_4);
                    double _divide = (_minus_3 / 2);
                    Interval _range_10 = ((DataRange)adj).getRange();
                    double _lowerBound_5 = _range_10.getLowerBound();
                    double _plus_3 = (_divide + _lowerBound_5);
                    CharSequence _numberWithCast_4 = this.getNumberWithCast(_dataType_4, Double.valueOf(_plus_3));
                    _builder.append(_numberWithCast_4, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _name_16 = d.getName();
                    String _firstLower_4 = StringExtensions.toFirstLower(_name_16);
                    _builder.append(_firstLower_4, "\t");
                    _builder.append(".set");
                    String _name_17 = data.getName();
                    String _firstUpper_12 = StringExtensions.toFirstUpper(_name_17);
                    _builder.append(_firstUpper_12, "\t");
                    _builder.append("WithRange(minValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_3 = data.getExcludedMethods();
                      boolean _contains_3 = _excludedMethods_3.contains("getter");
                      boolean _not_3 = (!_contains_3);
                      if (_not_3) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_18 = d.getName();
                        String _firstLower_5 = StringExtensions.toFirstLower(_name_18);
                        _builder.append(_firstLower_5, "\t");
                        _builder.append(".get");
                        String _name_19 = data.getName();
                        String _firstUpper_13 = StringExtensions.toFirstUpper(_name_19);
                        _builder.append(_firstUpper_13, "\t");
                        _builder.append("().equals(minValue));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_20 = data.getName();
                        String _firstUpper_14 = StringExtensions.toFirstUpper(_name_20);
                        _builder.append(_firstUpper_14, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    String _name_21 = d.getName();
                    String _firstLower_6 = StringExtensions.toFirstLower(_name_21);
                    _builder.append(_firstLower_6, "\t");
                    _builder.append(".set");
                    String _name_22 = data.getName();
                    String _firstUpper_15 = StringExtensions.toFirstUpper(_name_22);
                    _builder.append(_firstUpper_15, "\t");
                    _builder.append("WithRange(midValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_4 = data.getExcludedMethods();
                      boolean _contains_4 = _excludedMethods_4.contains("getter");
                      boolean _not_4 = (!_contains_4);
                      if (_not_4) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_23 = d.getName();
                        String _firstLower_7 = StringExtensions.toFirstLower(_name_23);
                        _builder.append(_firstLower_7, "\t");
                        _builder.append(".get");
                        String _name_24 = data.getName();
                        String _firstUpper_16 = StringExtensions.toFirstUpper(_name_24);
                        _builder.append(_firstUpper_16, "\t");
                        _builder.append("().equals(midValue));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_25 = data.getName();
                        String _firstUpper_17 = StringExtensions.toFirstUpper(_name_25);
                        _builder.append(_firstUpper_17, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    String _name_26 = d.getName();
                    String _firstLower_8 = StringExtensions.toFirstLower(_name_26);
                    _builder.append(_firstLower_8, "\t");
                    _builder.append(".set");
                    String _name_27 = data.getName();
                    String _firstUpper_18 = StringExtensions.toFirstUpper(_name_27);
                    _builder.append(_firstUpper_18, "\t");
                    _builder.append("WithRange(maxValue);");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<String> _excludedMethods_5 = data.getExcludedMethods();
                      boolean _contains_5 = _excludedMethods_5.contains("getter");
                      boolean _not_5 = (!_contains_5);
                      if (_not_5) {
                        _builder.append("\t");
                        _builder.append("assertTrue(");
                        String _name_28 = d.getName();
                        String _firstLower_9 = StringExtensions.toFirstLower(_name_28);
                        _builder.append(_firstLower_9, "\t");
                        _builder.append(".get");
                        String _name_29 = data.getName();
                        String _firstUpper_19 = StringExtensions.toFirstUpper(_name_29);
                        _builder.append(_firstUpper_19, "\t");
                        _builder.append("().equals(maxValue));");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("//no getter for ");
                        String _name_30 = data.getName();
                        String _firstUpper_20 = StringExtensions.toFirstUpper(_name_30);
                        _builder.append(_firstUpper_20, "\t");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  } else {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Test case for excluded setter with range of ");
                    String _name_31 = data.getName();
                    String _firstUpper_21 = StringExtensions.toFirstUpper(_name_31);
                    _builder.append(_firstUpper_21, " ");
                    _builder.append(".");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("* testing existence");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @generated");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/\t");
                    _builder.newLine();
                    _builder.append("@org.junit.Test public void test");
                    String _name_32 = data.getName();
                    String _firstUpper_22 = StringExtensions.toFirstUpper(_name_32);
                    _builder.append(_firstUpper_22, "");
                    _builder.append("ExcludedSetterWithRange() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("for (Method m : ");
                    String _name_33 = d.getName();
                    String _firstLower_10 = StringExtensions.toFirstLower(_name_33);
                    _builder.append(_firstLower_10, "\t");
                    _builder.append(".getClass().getMethods()) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("Assert.assertNotEquals(m.getName(), \"set");
                    String _name_34 = data.getName();
                    String _firstUpper_23 = StringExtensions.toFirstUpper(_name_34);
                    _builder.append(_firstUpper_23, "\t\t");
                    _builder.append("WithRange\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                  }
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Generates test cases for all excluded methods of a data set.
   */
  public CharSequence generateExcludedMethodsTest(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      for(final Data data : _data) {
        {
          EList<String> _excludedMethods = data.getExcludedMethods();
          for(final String method : _excludedMethods) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Test case for excluded ");
            _builder.append(method, " ");
            _builder.append(" of ");
            String _name = data.getName();
            String _firstUpper = StringExtensions.toFirstUpper(_name);
            _builder.append(_firstUpper, " ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* testing existence");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/\t");
            _builder.newLine();
            _builder.append("@org.junit.Test public void test");
            String _name_1 = data.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
            _builder.append(_firstUpper_1, "");
            _builder.append("Excluded");
            String _firstUpper_2 = StringExtensions.toFirstUpper(method);
            _builder.append(_firstUpper_2, "");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("for (Method m : ");
            String _name_2 = d.getName();
            String _firstLower = StringExtensions.toFirstLower(_name_2);
            _builder.append(_firstLower, "\t");
            _builder.append(".getClass().getMethods()) {");
            _builder.newLineIfNotEmpty();
            {
              boolean _equals = method.equals("setter");
              if (_equals) {
                _builder.append("\t\t");
                _builder.append("Assert.assertNotEquals(m.getName(), \"set");
                String _name_3 = data.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper(_name_3);
                _builder.append(_firstUpper_3, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
              } else {
                boolean _equals_1 = method.equals("getter");
                if (_equals_1) {
                  _builder.append("\t\t");
                  _builder.append("Assert.assertNotEquals(m.getName(), \"get");
                  String _name_4 = data.getName();
                  String _firstUpper_4 = StringExtensions.toFirstUpper(_name_4);
                  _builder.append(_firstUpper_4, "\t\t");
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Generates a test case for the constructor of a data set.
   */
  public CharSequence generateConstructorTest(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Test case for constructor of ");
    String _name = d.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, " ");
    _builder.append(".");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* testing basic functionality");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/\t");
    _builder.newLine();
    _builder.append("@org.junit.Test public void testConstructor() {");
    _builder.newLine();
    {
      EList<Data> _data = d.getData();
      for(final Data data : _data) {
        {
          if ((data instanceof NonMeasurementData)) {
            {
              boolean _isConstant = ((NonMeasurementData)data).isConstant();
              boolean _not = (!_isConstant);
              if (_not) {
                _builder.append("\t");
                String _typeName = this.toTypeName(data);
                _builder.append(_typeName, "\t");
                _builder.append(" ");
                String _name_1 = ((NonMeasurementData)data).getName();
                _builder.append(_name_1, "\t");
                _builder.append(" = ");
                Object _minValue = this.getMinValue(data);
                _builder.append(_minValue, "\t");
                DataType _dataType = ((NonMeasurementData)data).getDataType();
                String _dataTypeExtention = this.getDataTypeExtention(_dataType);
                _builder.append(_dataTypeExtention, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            if ((data instanceof MeasurementData)) {
              _builder.append("\t");
              String _typeName_1 = this.toTypeName(data);
              _builder.append(_typeName_1, "\t");
              _builder.append(" ");
              String _name_2 = data.getName();
              _builder.append(_name_2, "\t");
              _builder.append(" = ");
              Object _minValue_1 = this.getMinValue(data);
              _builder.append(_minValue_1, "\t");
              DataType _dataType_1 = data.getDataType();
              String _dataTypeExtention_1 = this.getDataTypeExtention(_dataType_1);
              _builder.append(_dataTypeExtention_1, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet dataSet : _usedDataSets) {
        _builder.append("\t");
        String _name_3 = dataSet.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper(_name_3);
        _builder.append(_firstUpper_1, "\t");
        _builder.append(" ");
        String _name_4 = dataSet.getName();
        String _firstLower = StringExtensions.toFirstLower(_name_4);
        _builder.append(_firstLower, "\t");
        _builder.append(" = new ");
        String _name_5 = dataSet.getName();
        String _firstUpper_2 = StringExtensions.toFirstUpper(_name_5);
        _builder.append(_firstUpper_2, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    String _name_6 = d.getName();
    String _firstLower_1 = StringExtensions.toFirstLower(_name_6);
    _builder.append(_firstLower_1, "\t");
    _builder.append(" = new ");
    String _name_7 = d.getName();
    String _firstUpper_3 = StringExtensions.toFirstUpper(_name_7);
    _builder.append(_firstUpper_3, "\t");
    _builder.append("(");
    String _attributesInLine = this.getAttributesInLine(d);
    _builder.append(_attributesInLine, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      EList<Data> _data_1 = d.getData();
      for(final Data data_1 : _data_1) {
        {
          if ((data_1 instanceof NonMeasurementData)) {
            {
              boolean _isConstant_1 = ((NonMeasurementData)data_1).isConstant();
              boolean _not_1 = (!_isConstant_1);
              if (_not_1) {
                {
                  EList<String> _excludedMethods = ((NonMeasurementData)data_1).getExcludedMethods();
                  boolean _contains = _excludedMethods.contains("getter");
                  boolean _not_2 = (!_contains);
                  if (_not_2) {
                    _builder.append("\t");
                    _builder.append("assertTrue(");
                    String _name_8 = d.getName();
                    String _firstLower_2 = StringExtensions.toFirstLower(_name_8);
                    _builder.append(_firstLower_2, "\t");
                    _builder.append(".get");
                    String _name_9 = ((NonMeasurementData)data_1).getName();
                    String _firstUpper_4 = StringExtensions.toFirstUpper(_name_9);
                    _builder.append(_firstUpper_4, "\t");
                    _builder.append("().equals(");
                    String _name_10 = ((NonMeasurementData)data_1).getName();
                    _builder.append(_name_10, "\t");
                    _builder.append("));");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t");
                    _builder.append("//no getter for ");
                    String _name_11 = ((NonMeasurementData)data_1).getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper(_name_11);
                    _builder.append(_firstUpper_5, "\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          } else {
            if ((data_1 instanceof MeasurementData)) {
              {
                EList<String> _excludedMethods_1 = data_1.getExcludedMethods();
                boolean _contains_1 = _excludedMethods_1.contains("getter");
                boolean _not_3 = (!_contains_1);
                if (_not_3) {
                  {
                    boolean _isAdjustedByLinearDataConversionWithInterval = this.isAdjustedByLinearDataConversionWithInterval(data_1);
                    if (_isAdjustedByLinearDataConversionWithInterval) {
                      _builder.append("\t");
                      _builder.append("assertTrue(");
                      String _name_12 = d.getName();
                      String _firstLower_3 = StringExtensions.toFirstLower(_name_12);
                      _builder.append(_firstLower_3, "\t");
                      _builder.append(".get");
                      String _name_13 = data_1.getName();
                      String _firstUpper_6 = StringExtensions.toFirstUpper(_name_13);
                      _builder.append(_firstUpper_6, "\t");
                      _builder.append("NotAdjusted().equals(");
                      String _name_14 = data_1.getName();
                      _builder.append(_name_14, "\t");
                      _builder.append("));");
                      _builder.newLineIfNotEmpty();
                    } else {
                      _builder.append("\t");
                      _builder.append("assertTrue(");
                      String _name_15 = d.getName();
                      String _firstLower_4 = StringExtensions.toFirstLower(_name_15);
                      _builder.append(_firstLower_4, "\t");
                      _builder.append(".get");
                      String _name_16 = data_1.getName();
                      String _firstUpper_7 = StringExtensions.toFirstUpper(_name_16);
                      _builder.append(_firstUpper_7, "\t");
                      _builder.append("().equals(");
                      String _name_17 = data_1.getName();
                      _builder.append(_name_17, "\t");
                      _builder.append("));");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                } else {
                  _builder.append("\t");
                  _builder.append("//no getter for ");
                  String _name_18 = data_1.getName();
                  String _firstUpper_8 = StringExtensions.toFirstUpper(_name_18);
                  _builder.append(_firstUpper_8, "\t");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    {
      EList<DataSet> _usedDataSets_1 = d.getUsedDataSets();
      for(final DataSet dataSet_1 : _usedDataSets_1) {
        _builder.append("\t");
        _builder.append("assertTrue(");
        String _name_19 = d.getName();
        String _firstLower_5 = StringExtensions.toFirstLower(_name_19);
        _builder.append(_firstLower_5, "\t");
        _builder.append(".get");
        String _name_20 = dataSet_1.getName();
        String _firstUpper_9 = StringExtensions.toFirstUpper(_name_20);
        _builder.append(_firstUpper_9, "\t");
        _builder.append("().equals(");
        String _name_21 = dataSet_1.getName();
        String _firstLower_6 = StringExtensions.toFirstLower(_name_21);
        _builder.append(_firstLower_6, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Generates test cases for the initial value of non measurement datas of a data set.
   */
  public CharSequence generateInitialValueTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<NonMeasurementData> _filter = Iterables.<NonMeasurementData>filter(_data, NonMeasurementData.class);
      for(final NonMeasurementData data : _filter) {
        {
          String _value = data.getValue();
          boolean _notEquals = (!Objects.equal(_value, null));
          if (_notEquals) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Test case for initial value of non measurement data ");
            String _name = data.getName();
            String _firstUpper = StringExtensions.toFirstUpper(_name);
            _builder.append(_firstUpper, " ");
            _builder.append(".");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* testing if initial value is set correctly");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/\t");
            _builder.newLine();
            _builder.append("@org.junit.Test public void test");
            String _name_1 = data.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
            _builder.append(_firstUpper_1, "");
            _builder.append("InitialValue() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _typeName = this.toTypeName(data);
            _builder.append(_typeName, "\t");
            _builder.append(" initialValue = ");
            String _typeName_1 = this.toTypeName(data);
            _builder.append(_typeName_1, "\t");
            _builder.append(".valueOf(\"");
            String _value_1 = data.getValue();
            _builder.append(_value_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            {
              EList<String> _excludedMethods = data.getExcludedMethods();
              boolean _contains = _excludedMethods.contains("getter");
              boolean _not = (!_contains);
              if (_not) {
                _builder.append("\t");
                _builder.append("assertTrue(");
                String _name_2 = d.getName();
                String _firstLower = StringExtensions.toFirstLower(_name_2);
                _builder.append(_firstLower, "\t");
                _builder.append(".get");
                String _name_3 = data.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
                _builder.append(_firstUpper_2, "\t");
                _builder.append("().equals(initialValue));");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("//no getter for ");
                String _name_4 = data.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper(_name_4);
                _builder.append(_firstUpper_3, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }
  
  /**
   * Generates test cases for setters of the datas of a data set.
   */
  public CharSequence generateSetterTests(final DataSet d) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Data> _data = d.getData();
      Iterable<Data> _filter = Iterables.<Data>filter(_data, Data.class);
      for(final Data data : _filter) {
        {
          if ((data instanceof NonMeasurementData)) {
            {
              boolean _isConstant = ((NonMeasurementData)data).isConstant();
              if (_isConstant) {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Test case for constant non measurement data ");
                String _name = ((NonMeasurementData)data).getName();
                String _firstUpper = StringExtensions.toFirstUpper(_name);
                _builder.append(_firstUpper, " ");
                _builder.append(".");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("* testing if there is no setter for constant datas");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @generated");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/\t");
                _builder.newLine();
                _builder.append("@org.junit.Test public void testConstant");
                String _name_1 = ((NonMeasurementData)data).getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
                _builder.append(_firstUpper_1, "");
                _builder.append("() {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("for (Method m : ");
                String _name_2 = d.getName();
                String _firstLower = StringExtensions.toFirstLower(_name_2);
                _builder.append(_firstLower, "\t");
                _builder.append(".getClass().getMethods()) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("Assert.assertNotEquals(m.getName(), \"set");
                String _name_3 = ((NonMeasurementData)data).getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
                _builder.append(_firstUpper_2, "\t\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
              } else {
                EList<String> _excludedMethods = ((NonMeasurementData)data).getExcludedMethods();
                boolean _contains = _excludedMethods.contains("setter");
                boolean _not = (!_contains);
                if (_not) {
                  CharSequence _setterTest = this.getSetterTest(data);
                  _builder.append(_setterTest, "");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          } else {
            if ((data instanceof MeasurementData)) {
              {
                EList<String> _excludedMethods_1 = data.getExcludedMethods();
                boolean _contains_1 = _excludedMethods_1.contains("setter");
                boolean _not_1 = (!_contains_1);
                if (_not_1) {
                  CharSequence _setterTest_1 = this.getSetterTest(data);
                  _builder.append(_setterTest_1, "");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    {
      EList<DataSet> _usedDataSets = d.getUsedDataSets();
      for(final DataSet dataSet : _usedDataSets) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Test case for setter of ");
        String _name_4 = dataSet.getName();
        String _firstUpper_3 = StringExtensions.toFirstUpper(_name_4);
        _builder.append(_firstUpper_3, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* testing basic functionality");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/\t");
        _builder.newLine();
        _builder.append("@org.junit.Test public void test");
        String _name_5 = dataSet.getName();
        String _firstUpper_4 = StringExtensions.toFirstUpper(_name_5);
        _builder.append(_firstUpper_4, "");
        _builder.append("Setter() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_6 = dataSet.getName();
        String _firstUpper_5 = StringExtensions.toFirstUpper(_name_6);
        _builder.append(_firstUpper_5, "\t");
        _builder.append(" ");
        String _name_7 = dataSet.getName();
        String _firstLower_1 = StringExtensions.toFirstLower(_name_7);
        _builder.append(_firstLower_1, "\t");
        _builder.append(" = new ");
        String _name_8 = dataSet.getName();
        String _firstUpper_6 = StringExtensions.toFirstUpper(_name_8);
        _builder.append(_firstUpper_6, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_9 = d.getName();
        String _firstLower_2 = StringExtensions.toFirstLower(_name_9);
        _builder.append(_firstLower_2, "\t");
        _builder.append(".set");
        String _name_10 = dataSet.getName();
        String _firstUpper_7 = StringExtensions.toFirstUpper(_name_10);
        _builder.append(_firstUpper_7, "\t");
        _builder.append("(");
        String _name_11 = dataSet.getName();
        String _firstLower_3 = StringExtensions.toFirstLower(_name_11);
        _builder.append(_firstLower_3, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("assertTrue(");
        String _name_12 = d.getName();
        String _firstLower_4 = StringExtensions.toFirstLower(_name_12);
        _builder.append(_firstLower_4, "\t");
        _builder.append(".get");
        String _name_13 = dataSet.getName();
        String _firstUpper_8 = StringExtensions.toFirstUpper(_name_13);
        _builder.append(_firstUpper_8, "\t");
        _builder.append("().equals(");
        String _name_14 = dataSet.getName();
        String _firstLower_5 = StringExtensions.toFirstLower(_name_14);
        _builder.append(_firstLower_5, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * returns the parameters of a constructor of this data set in a single line
   */
  private String getAttributesInLine(final DataSet d) {
    String s = "";
    EList<Data> _data = d.getData();
    for (final Data data : _data) {
      if ((data instanceof NonMeasurementData)) {
        boolean _isConstant = ((NonMeasurementData)data).isConstant();
        boolean _not = (!_isConstant);
        if (_not) {
          String _s = s;
          String _name = ((NonMeasurementData)data).getName();
          String _plus = (_name + ",");
          s = (_s + _plus);
        }
      } else {
        if ((data instanceof MeasurementData)) {
          String _s_1 = s;
          String _name_1 = ((MeasurementData)data).getName();
          String _plus_1 = (_name_1 + ",");
          s = (_s_1 + _plus_1);
        }
      }
    }
    EList<DataSet> _usedDataSets = d.getUsedDataSets();
    for (final DataSet dataSet : _usedDataSets) {
      String _s_2 = s;
      String _name_2 = dataSet.getName();
      String _firstLower = StringExtensions.toFirstLower(_name_2);
      String _plus_2 = (_firstLower + ",");
      s = (_s_2 + _plus_2);
    }
    boolean _isEmpty = s.isEmpty();
    if (_isEmpty) {
      return "";
    } else {
      int _length = s.length();
      int _minus = (_length - 1);
      return s.substring(0, _minus);
    }
  }
  
  /**
   * returns the imports necessary for the test cases
   */
  private CharSequence getImports(final EList<DataSet> dataSets) {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final DataSet dataSet : dataSets) {
        _builder.append("import ");
        SensorDataDescription _sensorDataDescription = dataSet.getSensorDataDescription();
        SensorInterface _sensorInterface = _sensorDataDescription.getSensorInterface();
        String _name = _sensorInterface.getName();
        _builder.append(_name, "");
        _builder.append(".");
        String _name_1 = dataSet.getName();
        String _firstUpper = StringExtensions.toFirstUpper(_name_1);
        _builder.append(_firstUpper, "");
        _builder.append(".");
        String _name_2 = dataSet.getName();
        String _firstUpper_1 = StringExtensions.toFirstUpper(_name_2);
        _builder.append(_firstUpper_1, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * generates a setter test for a data
   */
  private CharSequence getSetterTest(final Data data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Test case for setter of ");
    String _name = data.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, " ");
    _builder.append(".");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* testing basic functionality");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/\t");
    _builder.newLine();
    _builder.append("@org.junit.Test public void test");
    String _name_1 = data.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "");
    _builder.append("Setter() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _typeName = this.toTypeName(data);
    _builder.append(_typeName, "\t");
    _builder.append(" minValue = ");
    Object _minValue = this.getMinValue(data);
    _builder.append(_minValue, "\t");
    DataType _dataType = data.getDataType();
    String _dataTypeExtention = this.getDataTypeExtention(_dataType);
    _builder.append(_dataTypeExtention, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _typeName_1 = this.toTypeName(data);
    _builder.append(_typeName_1, "\t");
    _builder.append(" maxValue = ");
    Object _maxValue = this.getMaxValue(data);
    _builder.append(_maxValue, "\t");
    DataType _dataType_1 = data.getDataType();
    String _dataTypeExtention_1 = this.getDataTypeExtention(_dataType_1);
    _builder.append(_dataTypeExtention_1, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    DataSet _dataSet = data.getDataSet();
    String _name_2 = _dataSet.getName();
    String _firstLower = StringExtensions.toFirstLower(_name_2);
    _builder.append(_firstLower, "\t");
    _builder.append(".set");
    String _name_3 = data.getName();
    String _firstUpper_2 = StringExtensions.toFirstUpper(_name_3);
    _builder.append(_firstUpper_2, "\t");
    _builder.append("(minValue);");
    _builder.newLineIfNotEmpty();
    {
      EList<String> _excludedMethods = data.getExcludedMethods();
      boolean _contains = _excludedMethods.contains("getter");
      boolean _not = (!_contains);
      if (_not) {
        {
          boolean _isAdjustedByLinearDataConversionWithInterval = this.isAdjustedByLinearDataConversionWithInterval(data);
          if (_isAdjustedByLinearDataConversionWithInterval) {
            _builder.append("\t");
            _builder.append("assertTrue(");
            DataSet _dataSet_1 = data.getDataSet();
            String _name_4 = _dataSet_1.getName();
            String _firstLower_1 = StringExtensions.toFirstLower(_name_4);
            _builder.append(_firstLower_1, "\t");
            _builder.append(".get");
            String _name_5 = data.getName();
            String _firstUpper_3 = StringExtensions.toFirstUpper(_name_5);
            _builder.append(_firstUpper_3, "\t");
            _builder.append("NotAdjusted().equals(minValue));");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("assertTrue(");
            DataSet _dataSet_2 = data.getDataSet();
            String _name_6 = _dataSet_2.getName();
            String _firstLower_2 = StringExtensions.toFirstLower(_name_6);
            _builder.append(_firstLower_2, "\t");
            _builder.append(".get");
            String _name_7 = data.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper(_name_7);
            _builder.append(_firstUpper_4, "\t");
            _builder.append("().equals(minValue));");
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("\t");
        _builder.append("//no getter for ");
        String _name_8 = data.getName();
        String _firstUpper_5 = StringExtensions.toFirstUpper(_name_8);
        _builder.append(_firstUpper_5, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    DataSet _dataSet_3 = data.getDataSet();
    String _name_9 = _dataSet_3.getName();
    String _firstLower_3 = StringExtensions.toFirstLower(_name_9);
    _builder.append(_firstLower_3, "\t");
    _builder.append(".set");
    String _name_10 = data.getName();
    String _firstUpper_6 = StringExtensions.toFirstUpper(_name_10);
    _builder.append(_firstUpper_6, "\t");
    _builder.append("(maxValue);");
    _builder.newLineIfNotEmpty();
    {
      EList<String> _excludedMethods_1 = data.getExcludedMethods();
      boolean _contains_1 = _excludedMethods_1.contains("getter");
      boolean _not_1 = (!_contains_1);
      if (_not_1) {
        {
          boolean _isAdjustedByLinearDataConversionWithInterval_1 = this.isAdjustedByLinearDataConversionWithInterval(data);
          if (_isAdjustedByLinearDataConversionWithInterval_1) {
            _builder.append("\t");
            _builder.append("assertTrue(");
            DataSet _dataSet_4 = data.getDataSet();
            String _name_11 = _dataSet_4.getName();
            String _firstLower_4 = StringExtensions.toFirstLower(_name_11);
            _builder.append(_firstLower_4, "\t");
            _builder.append(".get");
            String _name_12 = data.getName();
            String _firstUpper_7 = StringExtensions.toFirstUpper(_name_12);
            _builder.append(_firstUpper_7, "\t");
            _builder.append("NotAdjusted().equals(maxValue));");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("assertTrue(");
            DataSet _dataSet_5 = data.getDataSet();
            String _name_13 = _dataSet_5.getName();
            String _firstLower_5 = StringExtensions.toFirstLower(_name_13);
            _builder.append(_firstLower_5, "\t");
            _builder.append(".get");
            String _name_14 = data.getName();
            String _firstUpper_8 = StringExtensions.toFirstUpper(_name_14);
            _builder.append(_firstUpper_8, "\t");
            _builder.append("().equals(maxValue));");
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        _builder.append("\t");
        _builder.append("//no getter for ");
        String _name_15 = data.getName();
        String _firstUpper_9 = StringExtensions.toFirstUpper(_name_15);
        _builder.append(_firstUpper_9, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }
  
  /**
   * returns the appropriate simple type name suitable for casting for dataType if necessary
   */
  private String getNecessaryCast(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = "(byte) ";
          break;
        case UINT8:
          _switchResult = "(byte) ";
          break;
        case INT16:
          _switchResult = "(short) ";
          break;
        case UINT16:
          _switchResult = "(short) ";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * returns the appropriate data type extention for numbers in java
   */
  private String getDataTypeExtention(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT64:
          _switchResult = "L";
          break;
        case UINT64:
          _switchResult = "L";
          break;
        case FLOAT:
          _switchResult = "F";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * returns the formula of a linear data conversion with interval with appropriate numbers
   */
  private CharSequence getLinearDataConversionWithInterval(final Number independentVariable, final double oldMin, final double oldMax, final double newMin, final double newMax) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(((");
    double _doubleValue = independentVariable.doubleValue();
    _builder.append(_doubleValue, "");
    _builder.append(" - ");
    _builder.append(oldMin, "");
    _builder.append(") * (");
    _builder.append(newMax, "");
    _builder.append(" - ");
    _builder.append(newMin, "");
    _builder.append(")) / (");
    _builder.append(oldMax, "");
    _builder.append(" - ");
    _builder.append(oldMin, "");
    _builder.append(")) + ");
    _builder.append(newMin, "");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * returns the formula of a linear data conversion with interval with appropriate numbers
   */
  private CharSequence getNumberWithCast(final DataType type, final Object number) {
    StringConcatenation _builder = new StringConcatenation();
    String _necessaryCast = this.getNecessaryCast(type);
    _builder.append(_necessaryCast, "");
    String _string = number.toString();
    Double _valueOf = Double.valueOf(_string);
    Number _dataType = this.toDataType(type, _valueOf);
    _builder.append(_dataType, "");
    String _dataTypeExtention = this.getDataTypeExtention(type);
    _builder.append(_dataTypeExtention, "");
    return _builder;
  }
  
  /**
   * returns the minimal value of the data type of this data
   */
  private Object getMinValue(final Data d) {
    Object _switchResult = null;
    DataType _dataType = d.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case INT8:
          _switchResult = Byte.valueOf(Byte.MIN_VALUE);
          break;
        case UINT8:
          _switchResult = Byte.valueOf(Byte.MIN_VALUE);
          break;
        case INT16:
          _switchResult = Short.valueOf(Short.MIN_VALUE);
          break;
        case UINT16:
          _switchResult = Short.valueOf(Short.MIN_VALUE);
          break;
        case INT32:
          _switchResult = Integer.valueOf(Integer.MIN_VALUE);
          break;
        case UINT32:
          _switchResult = Integer.valueOf(Integer.MIN_VALUE);
          break;
        case INT64:
          _switchResult = Long.valueOf(Long.MIN_VALUE);
          break;
        case UINT64:
          _switchResult = Long.valueOf(Long.MIN_VALUE);
          break;
        case FLOAT:
          _switchResult = Float.valueOf((-Float.MAX_VALUE));
          break;
        case DOUBLE:
          _switchResult = Double.valueOf((-Double.MAX_VALUE));
          break;
        case BOOLEAN:
          _switchResult = Boolean.valueOf(false);
          break;
        case STRING:
          _switchResult = "\"test\"";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * returns the maximal value of the data type of this data
   */
  private Object getMaxValue(final Data d) {
    Object _switchResult = null;
    DataType _dataType = d.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case INT8:
          _switchResult = Byte.valueOf(Byte.MAX_VALUE);
          break;
        case UINT8:
          _switchResult = Byte.valueOf(Byte.MAX_VALUE);
          break;
        case INT16:
          _switchResult = Short.valueOf(Short.MAX_VALUE);
          break;
        case UINT16:
          _switchResult = Short.valueOf(Short.MAX_VALUE);
          break;
        case INT32:
          _switchResult = Integer.valueOf(Integer.MAX_VALUE);
          break;
        case UINT32:
          _switchResult = Integer.valueOf(Integer.MAX_VALUE);
          break;
        case INT64:
          _switchResult = Long.valueOf(Long.MAX_VALUE);
          break;
        case UINT64:
          _switchResult = Long.valueOf(Long.MAX_VALUE);
          break;
        case FLOAT:
          _switchResult = Float.valueOf(Float.MAX_VALUE);
          break;
        case DOUBLE:
          _switchResult = Double.valueOf(Double.MAX_VALUE);
          break;
        case BOOLEAN:
          _switchResult = Boolean.valueOf(true);
          break;
        case STRING:
          _switchResult = "\"test\"";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * converts this value to a value of this data type
   */
  private Number toDataType(final DataType d, final Double value) {
    Number _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = Byte.valueOf(value.byteValue());
          break;
        case UINT8:
          _switchResult = Byte.valueOf(value.byteValue());
          break;
        case INT16:
          _switchResult = Short.valueOf(value.shortValue());
          break;
        case UINT16:
          _switchResult = Short.valueOf(value.shortValue());
          break;
        case INT32:
          _switchResult = Integer.valueOf(value.intValue());
          break;
        case UINT32:
          _switchResult = Integer.valueOf(value.intValue());
          break;
        case INT64:
          _switchResult = Long.valueOf(value.longValue());
          break;
        case UINT64:
          _switchResult = Long.valueOf(value.longValue());
          break;
        case FLOAT:
          _switchResult = Float.valueOf(value.floatValue());
          break;
        case DOUBLE:
          _switchResult = value;
          break;
        default:
          _switchResult = Integer.valueOf(0);
          break;
      }
    } else {
      _switchResult = Integer.valueOf(0);
    }
    return ((Number)_switchResult);
  }
  
  /**
   * returns the appropriate simple type name suitable for casting for dataType
   */
  private String toSimpleTypeName(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = "byte";
          break;
        case UINT8:
          _switchResult = "byte";
          break;
        case INT16:
          _switchResult = "short";
          break;
        case UINT16:
          _switchResult = "short";
          break;
        case INT32:
          _switchResult = "int";
          break;
        case UINT32:
          _switchResult = "int";
          break;
        case INT64:
          _switchResult = "long";
          break;
        case UINT64:
          _switchResult = "long";
          break;
        case FLOAT:
          _switchResult = "float";
          break;
        case DOUBLE:
          _switchResult = "double";
          break;
        case BOOLEAN:
          _switchResult = "boolean";
          break;
        case STRING:
          _switchResult = "String";
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * Maps to the corresponding language data type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  public String toTypeName(final Data d) {
    String _switchResult = null;
    DataType _dataType = d.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case INT8:
          _switchResult = Byte.class.getName();
          break;
        case UINT8:
          _switchResult = Byte.class.getName();
          break;
        case INT16:
          _switchResult = Short.class.getName();
          break;
        case UINT16:
          _switchResult = Short.class.getName();
          break;
        case INT32:
          _switchResult = Integer.class.getName();
          break;
        case UINT32:
          _switchResult = Integer.class.getName();
          break;
        case INT64:
          _switchResult = Long.class.getName();
          break;
        case UINT64:
          _switchResult = Long.class.getName();
          break;
        case FLOAT:
          _switchResult = Float.class.getName();
          break;
        case DOUBLE:
          _switchResult = Double.class.getName();
          break;
        case BOOLEAN:
          _switchResult = Boolean.class.getName();
          break;
        case STRING:
          _switchResult = String.class.getName();
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * Maps to the corresponding language data type.
   * @see IDTOGenerator#toTypeName(Data)
   */
  private String toTypeName(final DataType d) {
    String _switchResult = null;
    if (d != null) {
      switch (d) {
        case INT8:
          _switchResult = Byte.class.getName();
          break;
        case UINT8:
          _switchResult = Byte.class.getName();
          break;
        case INT16:
          _switchResult = Short.class.getName();
          break;
        case UINT16:
          _switchResult = Short.class.getName();
          break;
        case INT32:
          _switchResult = Integer.class.getName();
          break;
        case UINT32:
          _switchResult = Integer.class.getName();
          break;
        case INT64:
          _switchResult = Long.class.getName();
          break;
        case UINT64:
          _switchResult = Long.class.getName();
          break;
        case FLOAT:
          _switchResult = Float.class.getName();
          break;
        case DOUBLE:
          _switchResult = Double.class.getName();
          break;
        case BOOLEAN:
          _switchResult = Boolean.class.getName();
          break;
        case STRING:
          _switchResult = String.class.getName();
          break;
        default:
          _switchResult = "";
          break;
      }
    } else {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  /**
   * adds .java to a string
   */
  public String addFileExtensionTo(final String ClassName) {
    return (ClassName + SensIDLConstants.JAVA_EXTENSION);
  }
  
  /**
   * returns if a data is adjusted by linear data conversion with interval
   */
  private boolean isAdjustedByLinearDataConversionWithInterval(final Data d) {
    if ((d instanceof MeasurementData)) {
      EList<DataAdjustment> _adjustments = ((MeasurementData)d).getAdjustments();
      final Function1<DataAdjustment, Boolean> _function = new Function1<DataAdjustment, Boolean>() {
        public Boolean apply(final DataAdjustment adj) {
          return Boolean.valueOf((adj instanceof LinearDataConversionWithInterval));
        }
      };
      return IterableExtensions.<DataAdjustment>exists(_adjustments, _function);
    }
    return false;
  }
}
