/**
 * generated by Xtext
 */
package de.fzi.sensidl.language.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.fzi.sensidl.design.sensidl.SensorInterface;
import de.fzi.sensidl.language.SensidlRuntimeModule;
import de.fzi.sensidl.language.generator.EcorePersistenceHelper;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.SensidlCodeGenerationExecutor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Der Generator für SensIDL.
 * <p>
 * Stößt nacheinander zwei Generatoren an:
 * <ol>
 *   <li>{@link EcorePersistenceHelper} - persistiert das Modell.</li>
 *   <li>{@link SensidlCodeGenerationExecutor} - erzeugt Code für das Modell.</li>
 * </ol>
 * @author Dominik Werle
 */
@SuppressWarnings("all")
public class SensidlGenerator implements IGenerator {
  /**
   * Der SensidlCodeGenerationExecutor, wird durch Guice gebunden.
   * @see SensidlRuntimeModule
   */
  @Inject
  private SensidlCodeGenerationExecutor codeGenerator;
  
  private static Logger logger = Logger.getLogger(SensidlGenerator.class);
  
  private static String EXTENSION = "sensidl";
  
  private SensIDLConstants.GenerationLanguage generationLanguage = SensIDLConstants.GenerationLanguage.ALL;
  
  /**
   * Der Einstiegspunkt für den Generator für SensIDL.
   * <p>
   * Stößt nacheinander zwei Generatoren an:
   * <ol>
   *   <li>{@link EcorePersistenceHelper} - persistiert das Modell.</li>
   *   <li>{@link SensidlPseudoCodeGenerator} - erzeugt Pseudocode für das Modell.</li>
   * </ol>
   * @param resource die zu verarbeitende Resource
   * @param fsa Dateizugriff für die Dateigeneration
   */
  public void doGenerate(final Resource resource, final IFileSystemAccess fsa) {
    this.setUpLogger();
    this.codeGenerator.setGenerationLanguage(this.generationLanguage);
    this.codeGenerator.doGenerate(resource, fsa);
    SensidlGenerator.logger.info("Code was generated");
    EList<EObject> _contents = resource.getContents();
    Iterable<SensorInterface> _filter = Iterables.<SensorInterface>filter(_contents, SensorInterface.class);
    final SensorInterface dataModel = IterableExtensions.<SensorInterface>head(_filter);
    boolean _equals = Objects.equal(dataModel, null);
    if (_equals) {
      return;
    }
    URI _uRI = resource.getURI();
    URI _trimQuery = _uRI.trimQuery();
    URI _trimFragment = _trimQuery.trimFragment();
    URI _trimFileExtension = _trimFragment.trimFileExtension();
    final String fileNameBase = _trimFileExtension.lastSegment();
    final String fileName = ((fileNameBase + ".") + SensidlGenerator.EXTENSION);
    URI _createURI = URI.createURI(fileName);
    EcorePersistenceHelper.persistEcoreModel(dataModel, _createURI, fsa);
    SensidlGenerator.logger.info("Model was successfully persisted.");
  }
  
  public SensIDLConstants.GenerationLanguage setGenerationLanguage(final SensIDLConstants.GenerationLanguage generationLanguage) {
    return this.generationLanguage = generationLanguage;
  }
  
  public void setUpLogger() {
    Package _package = SensidlGenerator.class.getPackage();
    String _name = _package.getName();
    Logger logger = Logger.getLogger(_name);
    logger.setLevel(Level.ALL);
  }
}
