package de.fzi.sensidl.language.generator;

import de.fzi.sensidl.language.generator.GenerationParameter;
import de.fzi.sensidl.language.generator.ISensidlCodeGenerator;
import de.fzi.sensidl.language.generator.SensIDLConstants;
import de.fzi.sensidl.language.generator.job.GenerationJob;
import de.fzi.sensidl.language.generator.job.GenerationJobFactory;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * Code generator für die SensIDL Sprache.
 * 
 * @author Dominik Werle - Base implementation
 * @author Max Scheerer	- refinement of the base implementation
 * @author Emre Taspolatoglu
 */
@SuppressWarnings("all")
public class SensidlCodeGenerationExecutor implements ISensidlCodeGenerator {
  private static Logger logger = Logger.getLogger(SensidlCodeGenerationExecutor.class);
  
  private SensIDLConstants.GenerationLanguage generationLanguage;
  
  /**
   * The entry point to the generation.
   * @param input Corresponds to the resource file which includes all specified sensidl elements.
   * @param fsa   Corresponds to the IFileSystemAccess-object which is used for the file-generation.
   */
  public void doGenerate(final Resource input, final IFileSystemAccess fsa) {
    GenerationParameter _generationParameter = new GenerationParameter(input, fsa, this.generationLanguage);
    final GenerationJob generationJob = GenerationJobFactory.getGenerationJobBy(_generationParameter);
    try {
      SensidlCodeGenerationExecutor.logger.info("Start with code-generation.");
      generationJob.start();
    } catch (final Throwable _t) {
      if (_t instanceof OperationNotSupportedException) {
        final OperationNotSupportedException e = (OperationNotSupportedException)_t;
        SensidlCodeGenerationExecutor.logger.error("Start to generate code-templates which does not exist.", e);
      } else if (_t instanceof Exception) {
        final Exception e_1 = (Exception)_t;
        SensidlCodeGenerationExecutor.logger.error("A error occurred.", e_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  /**
   * Set the language to generate the code in.
   * @param generationLanguage Represents the new generation language value.
   */
  public SensIDLConstants.GenerationLanguage setGenerationLanguage(final SensIDLConstants.GenerationLanguage generationLanguage) {
    return this.generationLanguage = generationLanguage;
  }
}
