package de.fzi.sensidl.language.generator;

import de.fzi.sensidl.language.generator.SensIDLConstants;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess;

@SuppressWarnings("all")
public class GenerationParameter {
  private final Resource input;
  
  private final IFileSystemAccess fileSystemAccess;
  
  private final SensIDLConstants.GenerationLanguage generationLanguage;
  
  public GenerationParameter(final Resource input, final IFileSystemAccess fileSystemAccess, final SensIDLConstants.GenerationLanguage generationLanguage) {
    this.input = input;
    this.fileSystemAccess = fileSystemAccess;
    this.generationLanguage = generationLanguage;
  }
  
  public Resource getResource() {
    return this.input;
  }
  
  public IFileSystemAccess getFileSystemAccess() {
    return this.fileSystemAccess;
  }
  
  public SensIDLConstants.GenerationLanguage getGenerationLanguage() {
    return this.generationLanguage;
  }
}
