package de.fzi.sensidl.language.generator;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * Helper class to allow easy persisting of ecore models.
 * 
 * @author Dominik Werle
 */
@SuppressWarnings("all")
public class EcorePersistenceHelper {
  /**
   * Persistieren des Modells mit XMI
   */
  public static void persistEcoreModel(final EObject eObject, final URI fileName, final IFileSystemAccess fsa) {
    try {
      final Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
      final Map<String, Object> extensionToFactoryMap = registry.getExtensionToFactoryMap();
      String _fileExtension = fileName.fileExtension();
      XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
      extensionToFactoryMap.put(_fileExtension, _xMIResourceFactoryImpl);
      final ResourceSetImpl outResourceSet = new ResourceSetImpl();
      final Resource outResource = outResourceSet.createResource(fileName);
      EList<EObject> _contents = outResource.getContents();
      _contents.add(eObject);
      final ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
      outResource.save(outBuffer, Collections.EMPTY_MAP);
      String _fileString = fileName.toFileString();
      String _string = outBuffer.toString();
      fsa.generateFile(_fileString, _string);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
