/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sensidl.design.sensidl.dataRepresentation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    INT8(0, "INT8", "INT8"),
    UINT8(1, "UINT8", "UINT8"),
    INT16(2, "INT16", "INT16"),
    UINT16(3, "UINT16", "UINT16"),
    INT32(4, "INT32", "INT32"),
    UINT32(5, "UINT32", "UINT32"),
    INT64(6, "INT64", "INT64"),
    UINT64(7, "UINT64", "UINT64"),
    FLOAT(8, "FLOAT", "FLOAT"),
    DOUBLE(9, "DOUBLE", "DOUBLE"),
    BOOLEAN(10, "BOOLEAN", "BOOLEAN"),
    STRING(11, "STRING", "STRING"),
    UNDEFINED(12, "UNDEFINED", "UNDEFINED");

    public static final int INT8_VALUE = 0;
    public static final int UINT8_VALUE = 1;
    public static final int INT16_VALUE = 2;
    public static final int UINT16_VALUE = 3;
    public static final int INT32_VALUE = 4;
    public static final int UINT32_VALUE = 5;
    public static final int INT64_VALUE = 6;
    public static final int UINT64_VALUE = 7;
    public static final int FLOAT_VALUE = 8;
    public static final int DOUBLE_VALUE = 9;
    public static final int BOOLEAN_VALUE = 10;
    public static final int STRING_VALUE = 11;
    public static final int UNDEFINED_VALUE = 12;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{INT8, UINT8, INT16, UINT16, INT32, UINT32, INT64, UINT64, FLOAT, DOUBLE, BOOLEAN, STRING, UNDEFINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return INT8;
            }
            case 1: {
                return UINT8;
            }
            case 2: {
                return INT16;
            }
            case 3: {
                return UINT16;
            }
            case 4: {
                return INT32;
            }
            case 5: {
                return UINT32;
            }
            case 6: {
                return INT64;
            }
            case 7: {
                return UINT64;
            }
            case 8: {
                return FLOAT;
            }
            case 9: {
                return DOUBLE;
            }
            case 10: {
                return BOOLEAN;
            }
            case 11: {
                return STRING;
            }
            case 12: {
                return UNDEFINED;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

