/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.reclipse.math.functions.FunctionParameter;
import org.reclipse.math.functions.Lim0EFunction;
import org.reclipse.math.functions.Lim1EFunction;
import org.reclipse.math.functions.Lim1EFunctionNOA;
import org.reclipse.math.functions.Lim1EFunctionNOM;
import org.reclipse.math.functions.Lim1EFunctionWLOC;
import org.reclipse.math.functions.LinearFunction;
import org.reclipse.math.functions.MathFunctionsManager;
import org.reclipse.math.functions.MathematicalFunction;
import org.reclipse.metrics.extensionpoints.Metric;
import org.reclipse.metrics.extensionpoints.MetricUtil;
import org.reclipse.structure.specification.ui.PSImages;
import org.reclipse.structure.specification.ui.PSPlugin;
import org.reclipse.structure.specification.ui.figures.FuzzyFunctionFigure;
import org.reclipse.structure.specification.ui.figures.Lim0EFunctionFigure;
import org.reclipse.structure.specification.ui.figures.Lim1EFunctionFigure;
import org.reclipse.structure.specification.ui.figures.LinearFunctionFigure;

public class PSFuzzyExpressionWizardPage
extends WizardPage
implements SelectionListener {
    private ArrayList<String> functionNames;
    private int selectedFunctionsIndex = -1;
    private String selectedAcronym;
    private Composite topLevel;
    private Combo acronymComboBox;
    private StyledText acronymExplanation;
    private Combo functionComboBox;
    private TableViewer tableViewer;
    private Table table;
    private Canvas canvas;
    private Label functionImage;
    private LightweightSystem lws;
    private FuzzyFunctionFigure figure;
    private boolean displayAcronym = true;
    private boolean sizeAcronymSelectable = true;
    private HashMap<Integer, MathematicalFunction> cachedMathFunctions = new HashMap();

    public PSFuzzyExpressionWizardPage() {
        super("Fuzzy Expression", "Define the Fuzzy Expression", null);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.topLevel = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.topLevel.setLayout((Layout)layout);
        this.topLevel.setFont(parent.getFont());
        FormData canvasData = new FormData();
        canvasData.left = new FormAttachment(0, 0);
        canvasData.right = new FormAttachment(100, 0);
        canvasData.top = new FormAttachment(0, 0);
        canvasData.bottom = new FormAttachment(0, 100);
        this.canvas = new Canvas(this.topLevel, 526336);
        this.canvas.setLayoutData((Object)canvasData);
        this.lws = new LightweightSystem(this.canvas);
        FormData imageData = new FormData();
        imageData.left = new FormAttachment(0, 40);
        imageData.top = new FormAttachment((Control)this.canvas, 10);
        this.functionImage = new Label(this.topLevel, 0x1000000);
        this.functionImage.setLayoutData((Object)imageData);
        this.functionImage.setSize(450, 150);
        FormData acronymLabelData = new FormData();
        acronymLabelData.left = new FormAttachment(0, 0);
        acronymLabelData.top = new FormAttachment((Control)this.canvas, 165);
        Label acronymLabel = new Label(this.topLevel, 0);
        acronymLabel.setText("Metric Acronym: ");
        acronymLabel.setLayoutData((Object)acronymLabelData);
        FormData acronymComboBoxData = new FormData();
        acronymComboBoxData.left = new FormAttachment((Control)acronymLabel, 10);
        acronymComboBoxData.top = new FormAttachment((Control)this.canvas, 165);
        this.acronymComboBox = new Combo(this.topLevel, 8);
        this.acronymComboBox.setLayoutData((Object)acronymComboBoxData);
        this.acronymComboBox.addSelectionListener((SelectionListener)this);
        this.acronymComboBox.setEnabled(this.displayAcronym);
        FormData acronymExplanationData = new FormData();
        acronymExplanationData.left = new FormAttachment(0, 0);
        acronymExplanationData.top = new FormAttachment((Control)this.acronymComboBox, 10);
        acronymExplanationData.width = 500;
        acronymExplanationData.height = 80;
        this.acronymExplanation = new StyledText(this.topLevel, 8);
        this.acronymExplanation.setLayoutData((Object)acronymExplanationData);
        this.acronymExplanation.addSelectionListener((SelectionListener)this);
        this.acronymExplanation.setWordWrap(true);
        this.acronymExplanation.setText("");
        FormData functionLabelData = new FormData();
        functionLabelData.left = new FormAttachment(0, 0);
        functionLabelData.top = new FormAttachment((Control)this.acronymExplanation, 10);
        Label functionLabel = new Label(this.topLevel, 0);
        functionLabel.setText("Function: ");
        functionLabel.setLayoutData((Object)functionLabelData);
        FormData typeComboBoxData = new FormData();
        typeComboBoxData.left = new FormAttachment((Control)functionLabel, 10);
        typeComboBoxData.top = new FormAttachment((Control)this.acronymExplanation, 10);
        this.functionComboBox = new Combo(this.topLevel, 8);
        this.functionComboBox.setLayoutData((Object)typeComboBoxData);
        this.functionComboBox.addSelectionListener((SelectionListener)this);
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 0);
        tableData.top = new FormAttachment((Control)this.functionComboBox, 10);
        tableData.right = new FormAttachment(100, 0);
        this.tableViewer = this.createParametersTable(this.topLevel);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)tableData);
        Set metrics = MetricUtil.getAllMetrics();
        for (Metric metric : metrics) {
            this.acronymComboBox.add(metric.getAcronym());
        }
        this.functionNames = MathFunctionsManager.get().getAllKnownMathFunctionsNames();
        for (String name : this.functionNames) {
            this.functionComboBox.add(name);
        }
        if (!this.functionNames.isEmpty()) {
            this.functionComboBox.select(0);
            this.selectedFunctionsIndex = 0;
            this.updateFunctionViewer();
        }
        this.setControl((Control)this.topLevel);
        this.setDescription("Select the membership function.");
    }

    public boolean isValidState() {
        return this.functionComboBox != null && this.functionComboBox.getSelectionIndex() > -1 && this.acronymComboBox != null && (!this.acronymComboBox.isEnabled() || !this.acronymComboBox.getText().equals(""));
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.functionComboBox) {
            this.selectedFunctionsIndex = this.functionComboBox.getSelectionIndex();
        } else if (e.getSource() == this.acronymComboBox) {
            this.selectedAcronym = this.acronymComboBox.getText();
            this.updateAcronymSelection();
        }
        this.updateFunctionViewer();
        this.getWizard().getContainer().updateButtons();
    }

    private void updateAcronymSelection() {
        if (MetricUtil.getAllMetrics().isEmpty() && this.acronymExplanation != null) {
            this.acronymExplanation.setText("No metric configuration found. Please, register a metric configuration first.");
            return;
        }
        String selected = this.getMetricAcronym();
        if (selected == null) {
            return;
        }
        if (!selected.equals("")) {
            Set metrics = MetricUtil.getAllMetrics();
            for (Metric metric : metrics) {
                if (!selected.equals(metric.getAcronym())) continue;
                String explanation = String.valueOf(metric.getName()) + "\n";
                explanation = String.valueOf(explanation) + (metric.getDescription() != null ? String.valueOf(metric.getDescription()) + "\n" : "");
                this.acronymExplanation.setText(explanation);
                this.acronymExplanation.setToolTipText(metric.getDescription());
                this.acronymExplanation.redraw();
                break;
            }
        } else {
            this.acronymExplanation.setText("");
            this.acronymExplanation.setToolTipText("");
            this.acronymExplanation.redraw();
        }
    }

    private void updateFunctionViewer() {
        MathematicalFunction mathFunction = this.getSelectedMathFunction();
        if (mathFunction != null) {
            this.tableViewer.setInput((Object)mathFunction);
            this.table.getColumn(0).pack();
            this.table.getColumn(1).pack();
            ImageDescriptor desc = null;
            if (mathFunction instanceof LinearFunction || this.selectedFunctionsIndex == 0) {
                desc = PSImages.getDescriptor("icons/functions/linear-function.png");
                this.figure = new LinearFunctionFigure("X");
                this.figure.setFunction(mathFunction);
            } else if (mathFunction instanceof Lim0EFunction) {
                desc = PSImages.getDescriptor("icons/functions/e-lim0-function.png");
                this.figure = new Lim0EFunctionFigure("X");
                this.figure.setFunction(mathFunction);
            } else if (mathFunction instanceof Lim1EFunction || mathFunction instanceof Lim1EFunctionWLOC || mathFunction instanceof Lim1EFunctionNOM || mathFunction instanceof Lim1EFunctionNOA) {
                desc = PSImages.getDescriptor("icons/functions/e-lim1-function.png");
                this.figure = new Lim1EFunctionFigure("X");
                this.figure.setFunction(mathFunction);
            }
            this.figure.setBackgroundColor(ColorConstants.white);
            this.lws.setContents((IFigure)this.figure);
            if (desc != null) {
                this.functionImage.setImage(desc.createImage());
                this.functionImage.pack();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private TableViewer createParametersTable(Composite parent) {
        final TableViewer tableViewer = new TableViewer(parent, 67844);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText("parameter");
        column1.pack();
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText("value");
        column2.pack();
        tableViewer.setColumnProperties(new String[]{"parameter", "value"});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        tableViewer.setCellEditors(cellEditorArray);
        tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof FunctionParameter && property.equals("value");
            }

            public Object getValue(Object element, String property) {
                if (element instanceof FunctionParameter && property.equals("value")) {
                    return Double.toString(((FunctionParameter)element).getValue());
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item;
                Object data;
                if (element instanceof TableItem && property.equals("value") && value instanceof String && (data = (item = (TableItem)element).getData()) instanceof FunctionParameter) {
                    FunctionParameter parameter = (FunctionParameter)data;
                    double oldValue = parameter.getValue();
                    try {
                        double newValue = Double.parseDouble((String)value);
                        if (oldValue != newValue) {
                            parameter.setValue(newValue);
                            tableViewer.refresh((Object)parameter);
                            PSFuzzyExpressionWizardPage.this.updateFunctionViewer();
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof MathematicalFunction) {
                    MathematicalFunction mathFunction = (MathematicalFunction)inputElement;
                    ArrayList<FunctionParameter> list = new ArrayList<FunctionParameter>();
                    Iterator iter = mathFunction.entriesOfParams();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        list.add((FunctionParameter)entry.getValue());
                    }
                    return list.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof FunctionParameter) {
                    FunctionParameter param = (FunctionParameter)element;
                    if (columnIndex == 0) {
                        return param.getName();
                    }
                    if (columnIndex == 1) {
                        return Double.toString(param.getValue());
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        return tableViewer;
    }

    public MathematicalFunction getSelectedMathFunction() {
        int index = this.getSelectedFunctionsIndex();
        if (index >= 0) {
            ArrayList functionClasses;
            MathematicalFunction mathFunction = this.cachedMathFunctions.get(index);
            if (mathFunction == null && index < (functionClasses = MathFunctionsManager.get().getAllKnownMathFunctions()).size()) {
                Class functionClass = (Class)functionClasses.get(this.selectedFunctionsIndex);
                try {
                    mathFunction = (MathematicalFunction)functionClass.newInstance();
                }
                catch (InstantiationException e) {
                    PSPlugin.getDefault().logError("Could not create new math function instance", e);
                }
                catch (IllegalAccessException e) {
                    PSPlugin.getDefault().logError("Could not create new math function instance", e);
                }
                this.cachedMathFunctions.put(index, mathFunction);
            }
            return mathFunction;
        }
        return null;
    }

    public void setSelectedMathFunction(MathematicalFunction function) {
        ArrayList fctList = MathFunctionsManager.get().getAllKnownMathFunctions();
        ArrayList fctNamesList = MathFunctionsManager.get().getAllKnownMathFunctionsNames();
        String functionName = null;
        int functionIndex = -1;
        int i = 0;
        while (i < fctList.size()) {
            if (function.getClass().equals(fctList.get(i))) {
                functionName = (String)fctNamesList.get(i);
                functionIndex = i;
                break;
            }
            ++i;
        }
        if (functionName != null) {
            this.selectedFunctionsIndex = functionIndex;
            this.functionComboBox.select(functionIndex);
            this.cachedMathFunctions.put(functionIndex, function);
        }
        this.updateFunctionViewer();
    }

    public int getSelectedFunctionsIndex() {
        return this.selectedFunctionsIndex;
    }

    public String getMetricAcronym() {
        return this.selectedAcronym;
    }

    public void setMetricAcronym(String text) {
        if (this.acronymComboBox != null && text != null) {
            String[] acros = this.acronymComboBox.getItems();
            int i = 0;
            while (i < acros.length) {
                if (text.equals(acros[i])) {
                    this.acronymComboBox.select(i);
                    this.selectedAcronym = this.acronymComboBox.getText();
                }
                ++i;
            }
        }
        this.updateAcronymSelection();
    }

    public void dispose() {
        super.dispose();
        if (!this.cachedMathFunctions.isEmpty()) {
            this.cachedMathFunctions.clear();
        }
    }

    public boolean isDisplayAcronym() {
        return this.displayAcronym;
    }

    public void setDisplayAcronym(boolean displayAcronym) {
        this.displayAcronym = displayAcronym;
        if (this.acronymComboBox != null) {
            this.acronymComboBox.setEnabled(displayAcronym);
        }
    }

    public boolean isSizeAcronymSelectable() {
        return this.sizeAcronymSelectable;
    }

    public void setSizeAcronymSelectable(boolean sizeAcronymSelectable) {
        this.sizeAcronymSelectable = sizeAcronymSelectable;
        if (this.acronymComboBox != null && "SIZE".equals(this.acronymComboBox.getItem(0))) {
            this.acronymComboBox.remove(0);
        }
    }
}

