/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.wizards;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.reclipse.math.functions.FunctionParameter;
import org.reclipse.math.functions.MathematicalFunction;
import org.reclipse.structure.specification.PSFunctionParameter;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSFuzzySetRatingConstraint;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.wizards.AbstractPSFuzzyExpressionWizard;

public class NewPSFuzzyExpressionWizard
extends AbstractPSFuzzyExpressionWizard {
    private PSFuzzyConstraint product = null;
    private EClass type;
    private String acronym;

    public NewPSFuzzyExpressionWizard(EClass type, String acronym) {
        super(!SpecificationPackage.eINSTANCE.getPSFuzzySetRatingConstraint().equals(type));
        this.type = type;
        this.acronym = acronym;
        this.setWindowTitle("New Fuzzy Expression");
    }

    @Override
    public void addPages() {
        super.addPages();
        this.page.setMetricAcronym(this.acronym);
    }

    public boolean performFinish() {
        MathematicalFunction mathFunction = this.page.getSelectedMathFunction();
        if (mathFunction == null) {
            return false;
        }
        PSFuzzySetRatingConstraint constraint = null;
        String acronym = this.page.getMetricAcronym();
        if (SpecificationPackage.eINSTANCE.getPSFuzzySetRatingConstraint().equals(this.type)) {
            constraint = SpecificationFactory.eINSTANCE.createPSFuzzySetRatingConstraint();
        } else {
            constraint = SpecificationFactory.eINSTANCE.createPSFuzzyMetricConstraint();
            ((PSFuzzyMetricConstraint)constraint).setMetricAcronym(acronym);
        }
        if (constraint == null) {
            return false;
        }
        constraint.setMathFunctionID(mathFunction.getClass().getCanonicalName());
        Iterator iter = mathFunction.iteratorOfParams();
        while (iter.hasNext()) {
            FunctionParameter parameter = (FunctionParameter)iter.next();
            PSFunctionParameter param = SpecificationFactory.eINSTANCE.createPSFunctionParameter();
            param.setConstraint((PSFuzzyConstraint)constraint);
            param.setName(parameter.getName());
            param.setValue(parameter.getValue());
        }
        this.product = constraint;
        return true;
    }

    public PSFuzzyConstraint getProduct() {
        return this.product;
    }
}

