/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.fujaba.commons.wizards.NewResourceWizardPage;
import org.reclipse.structure.specification.PSAnnotation;
import org.reclipse.structure.specification.PSCatalog;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.ui.PSCatalogUtil;
import org.reclipse.structure.specification.ui.PSPlugin;
import org.reclipse.structure.specification.ui.wizards.CreateCatalogPage;

public class NewPSCatalogWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected NewResourceWizardPage diagramModelFilePage;
    protected NewResourceWizardPage domainModelFilePage;
    protected CreateCatalogPage selectMetaModelPage;
    protected Resource diagram;
    private IWorkbench workbench;
    private boolean openNewlyCreatedDiagramEditor = true;
    private PSCatalog catalog;
    private PSPatternSpecification pattern;
    private PSAnnotation annotation;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New Pattern Catalog");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.domainModelFilePage = new NewResourceWizardPage("DomainModelFile", this.getSelection(), "psc");
        this.domainModelFilePage.setTitle("Domain Model File");
        this.domainModelFilePage.setDescription("Select the file that will contain the domain model.");
        this.addPage((IWizardPage)this.domainModelFilePage);
        this.diagramModelFilePage = new NewResourceWizardPage("DiagramModelFile", this.getSelection(), "pscdiagram");
        this.diagramModelFilePage.setTitle("Diagram File");
        this.diagramModelFilePage.setDescription("Select the file that will contain the diagram.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.selectMetaModelPage = new CreateCatalogPage("CreateCatalog");
        this.selectMetaModelPage.setTitle("Pattern Specification Catalog");
        this.selectMetaModelPage.setDescription("Select the options for the new pattern catalog.");
        this.addPage((IWizardPage)this.selectMetaModelPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                NewPSCatalogWizard.this.diagram = PSCatalogUtil.createDiagram(NewPSCatalogWizard.this.diagramModelFilePage.getURI(), NewPSCatalogWizard.this.domainModelFilePage.getURI(), NewPSCatalogWizard.this.getCatalog(), "UTF-8", monitor);
                if (NewPSCatalogWizard.this.isOpenNewlyCreatedDiagramEditor() && NewPSCatalogWizard.this.diagram != null) {
                    try {
                        PSCatalogUtil.openDiagram(NewPSCatalogWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)NewPSCatalogWizard.this.getContainer().getShell(), (String)"Creation Wizard Open Editor Error", null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Wizard Creation Error", null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                PSPlugin.getDefault().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    protected PSCatalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = SpecificationFactory.eINSTANCE.createPSCatalog();
        }
        this.catalog.setName(this.selectMetaModelPage.getCatalogName());
        this.catalog.setMetamodel(this.selectMetaModelPage.getSelectedMetaModel().getId());
        if (this.pattern == null) {
            this.pattern = SpecificationFactory.eINSTANCE.createPSPatternSpecification();
            this.pattern.setCatalog(this.catalog);
            this.annotation = SpecificationFactory.eINSTANCE.createPSAnnotation();
            this.annotation.setType(this.pattern);
            this.annotation.setWeight(1.0);
            this.annotation.setPatternSpecification(this.pattern);
        }
        this.pattern.setName("Pattern1");
        return this.catalog;
    }
}

