/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.wizards;

import java.util.Iterator;
import org.eclipse.swt.widgets.Composite;
import org.reclipse.math.functions.FunctionParameter;
import org.reclipse.math.functions.MathematicalFunction;
import org.reclipse.structure.specification.PSFunctionParameter;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.utils.MathFunctionHelper;
import org.reclipse.structure.specification.ui.wizards.AbstractPSFuzzyExpressionWizard;

public class EditPSFuzzyExpressionWizard
extends AbstractPSFuzzyExpressionWizard {
    private PSFuzzyConstraint constraint;

    public EditPSFuzzyExpressionWizard(PSFuzzyConstraint constraint) {
        super(!SpecificationPackage.eINSTANCE.getPSFuzzySetRatingConstraint().equals(constraint.eClass()));
        this.setWindowTitle("Edit Fuzzy Expression");
        this.constraint = constraint;
    }

    @Override
    public boolean canFinish() {
        MathematicalFunction mathFunction = this.page.getSelectedMathFunction();
        if (mathFunction == null) {
            return false;
        }
        return super.canFinish();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.constraint instanceof PSFuzzyMetricConstraint) {
            this.page.setMetricAcronym(((PSFuzzyMetricConstraint)this.constraint).getMetricAcronym());
        }
        MathematicalFunction mFct = MathFunctionHelper.getMathematicalFunction(this.constraint);
        this.page.setSelectedMathFunction(mFct);
    }

    public boolean performFinish() {
        MathematicalFunction mathFunction = this.page.getSelectedMathFunction();
        String acronym = this.page.getMetricAcronym();
        this.constraint.setMathFunctionID(mathFunction.getClass().getCanonicalName());
        this.constraint.getParameters().clear();
        Iterator iter = mathFunction.iteratorOfParams();
        while (iter.hasNext()) {
            FunctionParameter parameter = (FunctionParameter)iter.next();
            PSFunctionParameter emfParameter = SpecificationFactory.eINSTANCE.createPSFunctionParameter();
            emfParameter.setName(parameter.getName());
            emfParameter.setValue(parameter.getValue());
            this.constraint.getParameters().add((Object)emfParameter);
        }
        if (this.constraint instanceof PSFuzzyMetricConstraint && acronym != null && !acronym.equals(((PSFuzzyMetricConstraint)this.constraint).getMetricAcronym())) {
            ((PSFuzzyMetricConstraint)this.constraint).setMetricAcronym(acronym);
        }
        return true;
    }
}

