/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.reclipse.metamodel.MetaModel;
import org.reclipse.structure.specification.util.ModelHelper;

public class CreateCatalogPage
extends WizardPage {
    private Text catalogNameText;
    private TableViewer modelsViewer;
    private Label modelDescriptionIcon;
    private Label modelDescriptionLabel;
    protected MetaModel selectedMetaModel;

    protected CreateCatalogPage(String name) {
        super(name);
        this.setPageComplete(this.isValid());
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createCatalogNameText(top);
        this.createModelsViewer(top);
        this.selectFirstModel();
        this.setControl((Control)top);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.catalogNameText.setFocus();
            this.catalogNameText.selectAll();
        }
    }

    private void selectFirstModel() {
        if (this.modelsViewer != null && this.modelsViewer.getTable().getItemCount() > 0) {
            this.modelsViewer.getTable().setSelection(0);
            this.modelsViewer.setSelection(this.modelsViewer.getSelection());
        }
    }

    protected void selectMetaModel(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof MetaModel) {
            this.selectedMetaModel = (MetaModel)selection.getFirstElement();
            this.modelDescriptionIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
            this.modelDescriptionLabel.setText(this.selectedMetaModel.getDescription());
            this.modelDescriptionLabel.getParent().getParent().layout();
        }
    }

    protected boolean isValid() {
        return this.getCatalogName() != null && this.getSelectedMetaModel() != null;
    }

    private void createCatalogNameText(Composite parent) {
        Composite name = new Composite(parent, 0);
        name.setLayout((Layout)new GridLayout(2, false));
        name.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label(name, 0);
        label.setText("Catalog &name:");
        this.catalogNameText = new Text(name, 2048);
        this.catalogNameText.setText("New Catalog");
        this.catalogNameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.catalogNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateCatalogPage.this.setPageComplete(CreateCatalogPage.this.isValid());
            }
        });
    }

    private void createModelsViewer(Composite parent) {
        Group models = new Group(parent, 0);
        models.setText("ASG Meta &Model");
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo((Composite)models);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)models);
        this.modelsViewer = new TableViewer((Composite)models, 68100);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo(this.modelsViewer.getControl());
        this.modelsViewer.getTable().setHeaderVisible(true);
        this.modelsViewer.getTable().setLinesVisible(true);
        this.modelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CreateCatalogPage.this.modelsViewer != null && CreateCatalogPage.this.modelsViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)CreateCatalogPage.this.modelsViewer.getSelection();
                    CreateCatalogPage.this.selectMetaModel(selection);
                }
                CreateCatalogPage.this.setPageComplete(CreateCatalogPage.this.isValid());
            }
        });
        this.createModelsColumns(this.modelsViewer);
        this.modelsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modelsViewer.setInput((Object)ModelHelper.getAllMetaModels());
        this.modelDescriptionIcon = new Label((Composite)models, 16384);
        this.modelDescriptionIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        GridDataFactory.fillDefaults().applyTo((Control)this.modelDescriptionIcon);
        this.modelDescriptionLabel = new Label((Composite)models, 64);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.modelDescriptionLabel);
    }

    private void createModelsColumns(TableViewer viewer) {
        String[] titles = new String[]{"Name", "Version", "ID"};
        int[] bounds = new int[]{200, 60, 224};
        TableViewerColumn col = this.createTableViewerColumn(viewer, titles[0], bounds[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaModel p = (MetaModel)element;
                return p.getName();
            }
        });
        col = this.createTableViewerColumn(viewer, titles[1], bounds[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaModel p = (MetaModel)element;
                return p.getVersion();
            }
        });
        col = this.createTableViewerColumn(viewer, titles[2], bounds[2]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetaModel p = (MetaModel)element;
                return p.getId();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int width) {
        TableViewerColumn col = new TableViewerColumn(viewer, 16384);
        TableColumn column = col.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
        return col;
    }

    public String getCatalogName() {
        if (this.catalogNameText != null && this.catalogNameText.getText().trim().length() > 0) {
            return this.catalogNameText.getText().trim();
        }
        return null;
    }

    public MetaModel getSelectedMetaModel() {
        return this.selectedMetaModel;
    }
}

