/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.properties.util;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.reclipse.metrics.extensionpoints.Metric;
import org.reclipse.structure.specification.SpecificationFactory;
import org.reclipse.structure.specification.provider.SpecificationItemProviderAdapterFactory;
import org.reclipse.structure.specification.ui.PSPlugin;

public class SingleAcronymSelectionDialog
extends Dialog {
    private String title;
    private TableViewer viewer;
    private CLabel infoboxHeader;
    private Text infoboxText;
    private Metric selected;
    private Collection<Metric> input;

    public SingleAcronymSelectionDialog() {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Label filtered = new Label(main, 16384);
        filtered.setText("&Metric:");
        this.viewer = new TableViewer(main, 68096);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PSMetricLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object one, Object two) {
                Metric mOne = (Metric)one;
                Metric mTwo = (Metric)two;
                return mOne.getAcronym().compareTo(mTwo.getAcronym());
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTable());
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn colAcronym = new TableColumn(this.viewer.getTable(), 16384);
        colAcronym.setText("Acronym");
        colAcronym.setWidth(72);
        TableColumn colDescription = new TableColumn(this.viewer.getTable(), 16384);
        colDescription.setText("Description");
        colDescription.setWidth(320);
        this.infoboxHeader = new CLabel(main, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxHeader);
        this.infoboxText = new Text(main, 16458);
        this.infoboxText.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxText);
        this.hookListeners();
        this.viewer.setInput(this.input);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.selected), true);
        return main;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = PSPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = root.addNewSection(((Object)((Object)this)).getClass().getName());
            settings.put("DIALOG_X_ORIGIN", 50);
            settings.put("DIALOG_Y_ORIGIN", 50);
            settings.put("DIALOG_WIDTH", 450);
            settings.put("DIALOG_HEIGHT", 500);
        }
        return settings;
    }

    public Metric getSelected() {
        return this.selected;
    }

    protected void handleSelection(StructuredSelection selection) {
        this.selected = (Metric)selection.getFirstElement();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                StringBuilder header = new StringBuilder();
                header.append(SingleAcronymSelectionDialog.this.selected.getAcronym());
                header.append(": ");
                header.append(SingleAcronymSelectionDialog.this.selected.getName());
                Image image = ((PSMetricLabelProvider)SingleAcronymSelectionDialog.this.viewer.getLabelProvider()).getColumnImage(SingleAcronymSelectionDialog.this.selected, 0);
                SingleAcronymSelectionDialog.this.infoboxHeader.setImage(image);
                SingleAcronymSelectionDialog.this.infoboxHeader.setText(header.toString());
                String info = SingleAcronymSelectionDialog.this.selected.getDescription();
                if (info == null || info.trim().isEmpty()) {
                    info = "No further documentation available.";
                }
                SingleAcronymSelectionDialog.this.infoboxText.setText(info);
                SingleAcronymSelectionDialog.this.infoboxText.getParent().layout();
            }
        });
        Button okay = this.getButton(0);
        if (okay != null) {
            okay.setEnabled(this.selected != null);
        }
    }

    private void hookListeners() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleAcronymSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleAcronymSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
                if (SingleAcronymSelectionDialog.this.selected != null) {
                    SingleAcronymSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInput(Collection<Metric> input, String currentAcronym) {
        this.selected = null;
        for (Metric metric : input) {
            if (!metric.getAcronym().equals(currentAcronym)) continue;
            this.selected = metric;
            break;
        }
        this.input = input;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private class PSMetricLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final Image image;

        public PSMetricLabelProvider() {
            AdapterFactoryLabelProvider provider = new AdapterFactoryLabelProvider((AdapterFactory)new SpecificationItemProviderAdapterFactory());
            this.image = provider.getImage((Object)SpecificationFactory.eINSTANCE.createPSMetricConstraint());
        }

        public Image getColumnImage(Object element, int index) {
            if (index == 0) {
                return this.image;
            }
            return null;
        }

        public String getColumnText(Object element, int index) {
            Metric metric = (Metric)element;
            switch (index) {
                case 0: {
                    return metric.getAcronym();
                }
                case 1: {
                    return metric.getName();
                }
            }
            return "";
        }
    }
}

