/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.properties.sections;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.fujaba.commons.properties.section.AbstractSection;
import org.fujaba.commons.properties.util.ColorRegistry;
import org.fujaba.commons.properties.util.TextChangeListener;
import org.reclipse.structure.specification.PSConnection;
import org.reclipse.structure.specification.PSLink;
import org.reclipse.structure.specification.PSPatternSpecification;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSLinkQualifierSection
extends AbstractSection {
    private CLabel label;
    private Text normal;
    private Combo referenced;
    private Combo inherited;
    private TextChangeListener listener;

    protected void createWidgets(Composite parent) {
        this.label = this.getWidgetFactory().createCLabel(parent, this.getLabelText(), 131072);
        this.label.setToolTipText("This qualified String will be used to qualify the annotated element.");
        this.normal = this.getWidgetFactory().createText(parent, "", 16388);
        this.normal.setVisible(false);
        this.referenced = new Combo(parent, 12);
        this.referenced.setVisible(false);
        this.inherited = new Combo(parent, 4);
        this.inherited.setVisible(false);
    }

    protected PSLink getElement() {
        return (PSLink)super.getElement();
    }

    protected EStructuralFeature getFeature() {
        return SpecificationPackage.Literals.PS_LINK__QUALIFIER;
    }

    private String[] getItems() {
        List list = ModelHelper.getAllValidQualifiers((PSLink)this.getElement());
        return list.toArray(new String[list.size()]);
    }

    protected String getLabelText() {
        return "Qualifier";
    }

    private void handleTextModified() {
        if (this.isTextValid()) {
            this.createCommand(this.getElement().getQualifier(), this.normal.getText());
        } else {
            this.refresh();
        }
    }

    protected void hookListeners() {
        this.referenced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSLinkQualifierSection.this.normal.setText(PSLinkQualifierSection.this.referenced.getText());
                PSLinkQualifierSection.this.handleTextModified();
            }
        });
        this.inherited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSLinkQualifierSection.this.normal.setText(PSLinkQualifierSection.this.inherited.getText());
                PSLinkQualifierSection.this.handleTextModified();
            }
        });
        this.inherited.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PSLinkQualifierSection.this.normal.setText(PSLinkQualifierSection.this.inherited.getText());
                PSLinkQualifierSection.this.handleTextModified();
            }
        });
        this.inherited.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    PSLinkQualifierSection.this.normal.setText(PSLinkQualifierSection.this.inherited.getText());
                    PSLinkQualifierSection.this.handleTextModified();
                }
            }
        });
        this.listener = new TextChangeListener(){

            public void textChanged(Control control) {
                PSLinkQualifierSection.this.handleTextModified();
            }
        };
        this.listener.startListeningTo((Control)this.normal);
        this.normal.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                PSLinkQualifierSection.this.verifyField(e);
            }
        });
    }

    private boolean isTextValid() {
        PSPatternSpecification pattern = this.getElement().getPatternSpecification();
        String qualifier = this.normal.getText();
        if (ModelHelper.getCreateAnnotation((PSPatternSpecification)pattern).equals(this.getElement().getSource())) {
            for (PSConnection conn : pattern.getConnections()) {
                if (!(conn instanceof PSLink) || !ModelHelper.isCreate((PSLink)((PSLink)conn)) || conn.equals(this.getElement()) || !qualifier.equals(((PSLink)conn).getQualifier())) continue;
                return false;
            }
        }
        return true;
    }

    public void refresh() {
        String qualifier = this.getElement().getQualifier();
        if (qualifier == null) {
            qualifier = "";
        }
        this.normal.setText(qualifier);
        this.referenced.select(this.referenced.indexOf(qualifier));
        this.inherited.select(this.inherited.indexOf(qualifier));
        if (ModelHelper.isCreate((PSLink)this.getElement())) {
            if (this.getElement().getPatternSpecification().getSuperPattern() == null || this.getItems().length < 1) {
                this.normal.setVisible(true);
                this.inherited.setVisible(false);
                this.referenced.setVisible(false);
            } else {
                this.normal.setVisible(false);
                this.inherited.setVisible(true);
                this.referenced.setVisible(false);
            }
        } else {
            this.normal.setVisible(false);
            this.inherited.setVisible(false);
            this.referenced.setVisible(true);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        String[] items = this.getItems();
        this.referenced.setItems(items);
        this.inherited.setItems(items);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.normal.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.referenced.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.inherited.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.normal, -5);
        data.top = new FormAttachment((Control)this.normal, 0, 128);
        this.label.setLayoutData((Object)data);
    }

    private void verifyField(Event e) {
        if (this.isTextValid()) {
            this.setErrorMessage(null);
            this.normal.setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage("The qualifier has to be unique.");
            this.normal.setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }
}

