/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.properties.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.fujaba.commons.properties.section.AbstractObjectSelectionComboSection;
import org.reclipse.metrics.extensionpoints.Metric;
import org.reclipse.metrics.extensionpoints.MetricUtil;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.PSFuzzyMetricConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.properties.util.SingleAcronymSelectionDialog;

public class PSFuzzyMetricConstraintAcronymSection
extends AbstractObjectSelectionComboSection {
    private SingleAcronymSelectionDialog dialog = new SingleAcronymSelectionDialog();

    public PSFuzzyMetricConstraintAcronymSection() {
        this.dialog.setTitle("Metric Selection");
    }

    protected Metric getCurrentValue() {
        return MetricUtil.getMetricByAcronym((String)this.getElement().getMetricAcronym());
    }

    protected PSFuzzyMetricConstraint getElement() {
        return (PSFuzzyMetricConstraint)super.getElement();
    }

    protected EStructuralFeature getFeature() {
        return SpecificationPackage.Literals.PS_FUZZY_METRIC_CONSTRAINT__METRIC_ACRONYM;
    }

    protected String getLabelText() {
        return "Acronym";
    }

    protected List<Metric> getPossibilities() {
        boolean removeSize = true;
        if (ModifierType.SET.equals((Object)this.getElement().getNode().getModifier())) {
            removeSize = false;
        }
        ArrayList<Metric> available = new ArrayList<Metric>();
        for (Metric metric : MetricUtil.getMetricsFor((EClass)((PSObject)this.getElement().getNode()).getInstanceOf())) {
            if (removeSize && (!removeSize || metric.getAcronym().equals("SIZE"))) continue;
            available.add(metric);
        }
        Collections.sort(available, new Comparator<Metric>(){

            @Override
            public int compare(Metric one, Metric two) {
                return one.getAcronym().compareTo(two.getAcronym());
            }
        });
        return available;
    }

    protected String getValueText(Object element) {
        Metric metric = (Metric)element;
        StringBuilder text = new StringBuilder();
        text.append(metric.getAcronym());
        text.append(" - ");
        text.append(metric.getName());
        return text.toString();
    }

    protected void handleAdvancedButtonClicked() {
        this.dialog.setInput(this.getPossibilities(), this.getElement().getMetricAcronym());
        if (this.dialog.open() == 0) {
            this.list.select(this.list.indexOf(this.getValueText(this.dialog.getSelected())));
            this.createCommand(this.getCurrentValue().getAcronym(), this.dialog.getSelected().getAcronym());
        }
    }

    protected void handleSelection(SelectionEvent e) {
        if (e.getSource().equals(this.list)) {
            Metric selected = (Metric)this.getObject(this.list.getText());
            this.createCommand(this.getCurrentValue().getAcronym(), selected.getAcronym());
        }
    }

    protected boolean showAdvancedButton() {
        return true;
    }
}

