/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.properties.sections;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.fujaba.commons.properties.section.AbstractSection;
import org.fujaba.commons.properties.util.ColorRegistry;
import org.fujaba.commons.properties.util.TextChangeListener;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSAttributeConstraintValueSection
extends AbstractSection {
    private CLabel label;
    private Text text;
    private Combo combo;
    private TextChangeListener listener;

    protected void createWidgets(Composite parent) {
        this.label = this.getWidgetFactory().createCLabel(parent, this.getLabelText(), 131072);
        this.text = this.getWidgetFactory().createText(parent, "", 16388);
        this.text.setVisible(false);
        this.combo = new Combo(parent, 12);
        this.combo.setVisible(false);
    }

    protected PSAttributeConstraint getElement() {
        return (PSAttributeConstraint)super.getElement();
    }

    protected EStructuralFeature getFeature() {
        return SpecificationPackage.Literals.PS_BOOLEAN_CONSTRAINT__VALUE_EXPRESSION;
    }

    private String[] getItems() {
        List list = ModelHelper.getAllValidValues((PSAttributeConstraint)this.getElement());
        return list.toArray(new String[list.size()]);
    }

    protected String getLabelText() {
        return "Value";
    }

    protected void handleModelChanged(Notification msg) {
        if (msg.getFeature() != null && msg.getFeature().equals(SpecificationPackage.Literals.PS_ATTRIBUTE_CONSTRAINT__ATTRIBUTE)) {
            this.combo.setItems(this.getItems());
            this.refresh();
        }
        super.handleModelChanged(msg);
    }

    private void handleTextModified() {
        this.createCommand(this.getElement().getValueExpression(), this.text.getText());
    }

    protected void hookListeners() {
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSAttributeConstraintValueSection.this.text.setText(PSAttributeConstraintValueSection.this.combo.getText());
                PSAttributeConstraintValueSection.this.handleTextModified();
            }
        });
        this.listener = new TextChangeListener(){

            public void textChanged(Control control) {
                PSAttributeConstraintValueSection.this.handleTextModified();
            }
        };
        this.listener.startListeningTo((Control)this.text);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                PSAttributeConstraintValueSection.this.verifyField(e);
            }
        });
    }

    private boolean isTextValid() {
        String value = this.text.getText();
        if (PSAttributeConstraintValueSection.isBoolean((EAttribute)this.getElement().getAttribute())) {
            return "true".equals(value) || "false".equals(value);
        }
        if (PSAttributeConstraintValueSection.isInteger((EAttribute)this.getElement().getAttribute())) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (PSAttributeConstraintValueSection.isDouble((EAttribute)this.getElement().getAttribute())) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (PSAttributeConstraintValueSection.isEnum((EAttribute)this.getElement().getAttribute())) {
            EEnum enumType = (EEnum)this.getElement().getAttribute().getEAttributeType();
            for (EEnumLiteral literal : enumType.getELiterals()) {
                if (!literal.getLiteral().equals(value) && !literal.getName().equals(value)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void verifyField(Event e) {
        if (this.isTextValid()) {
            this.setErrorMessage(null);
            this.text.setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage("The value is not valid for the attribute.");
            this.text.setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }

    public void refresh() {
        String value = this.getElement().getValueExpression();
        if (value == null) {
            value = "";
        }
        this.text.setText(value);
        this.combo.select(this.combo.indexOf(value));
        if (PSAttributeConstraintValueSection.isEnum((EAttribute)this.getElement().getAttribute()) || PSAttributeConstraintValueSection.isBoolean((EAttribute)this.getElement().getAttribute())) {
            this.text.setVisible(false);
            this.combo.setVisible(true);
        } else {
            this.text.setVisible(true);
            this.combo.setVisible(false);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.combo.setItems(this.getItems());
    }

    protected void setSectionData(Composite parent) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(parent, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(parent, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.combo.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -5);
        data.top = new FormAttachment((Control)this.text, 0, 128);
        this.label.setLayoutData((Object)data);
    }
}

