/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.properties.sections;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.fujaba.commons.properties.section.AbstractObjectSelectionComboSection;
import org.fujaba.commons.properties.util.ColorRegistry;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSAttributeConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.util.ModelHelper;
import org.storydriven.storydiagrams.expressions.common.parser.antlr.ExpressionsParser;

public class PSAttributeConstraintExpressionSection
extends AbstractObjectSelectionComboSection {
    private Combo operatorCombo;
    private Text valueText;
    private Composite area;
    private ExpressionsParser parser = new ExpressionsParser();

    public PSAttributeConstraintExpressionSection() {
        String INJECTOR_ID = "org.storydriven.modeling.expressions.common.Expressions";
    }

    protected void createWidgets(Composite composite) {
        this.area = this.getWidgetFactory().createFlatFormComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.area);
        this.list = new Combo(this.area, 12);
        GridDataFactory.fillDefaults().applyTo((Control)this.list);
        this.label = this.getWidgetFactory().createCLabel(composite, this.getLabelText(), 131072);
        this.operatorCombo = new Combo(this.area, 12);
        GridDataFactory.fillDefaults().applyTo((Control)this.operatorCombo);
        this.valueText = this.getWidgetFactory().createText(this.area, "", 18432);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.valueText);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.area.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.area, -5);
        data.top = new FormAttachment((Control)this.area, 0, 128);
        this.label.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        OperatorType[] array = OperatorType.values();
        int i = 0;
        while (i < array.length) {
            if (array[i].equals((Object)this.getElement().getOperator())) {
                this.operatorCombo.select(i);
                break;
            }
            ++i;
        }
        String text = this.getElement().getValueExpression();
        if (text == null) {
            text = "";
        }
        this.valueText.setText(text);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.operatorCombo.setItems(this.getOperators());
    }

    protected void hookListeners() {
        super.hookListeners();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSAttributeConstraintExpressionSection.this.checkExpression();
            }
        };
        this.list.addSelectionListener((SelectionListener)listener);
        this.operatorCombo.addSelectionListener((SelectionListener)listener);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PSAttributeConstraintExpressionSection.this.checkExpression();
            }
        });
    }

    protected void checkExpression() {
        String operator = ModelHelper.getReadable((OperatorType)OperatorType.values()[this.operatorCombo.getSelectionIndex()]);
        StringBuilder expression = new StringBuilder();
        expression.append(this.getElement().getNode().getName());
        expression.append(".");
        expression.append(this.getElement().getAttribute().getName());
        expression.append(operator);
        expression.append(this.valueText.getText());
        IParseResult result = null;
        try {
            result = this.parser.parse((Reader)new StringReader(expression.toString()));
        }
        catch (Exception ex) {
            result = null;
        }
        if (result != null && !result.hasSyntaxErrors()) {
            CompoundCommand command = new CompoundCommand();
            String value = this.valueText.getText();
            EAttribute feature = SpecificationPackage.Literals.PS_BOOLEAN_CONSTRAINT__VALUE_EXPRESSION;
            command.append(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
            value = OperatorType.values()[this.operatorCombo.getSelectionIndex()];
            feature = SpecificationPackage.Literals.PS_BOOLEAN_CONSTRAINT__OPERATOR;
            command.append(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
            value = expression.toString();
            feature = SpecificationPackage.Literals.PS_NODE_CONSTRAINT__EXPRESSION;
            command.append(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
            this.getEditingDomain().getCommandStack().execute((Command)command);
            this.setErrorMessage(null);
            this.valueText.setBackground(null);
        } else if (result == null) {
            this.setErrorMessage("Parsing of expression failed");
        } else {
            for (INode err : result.getSyntaxErrors()) {
                this.setErrorMessage("Syntax Error: " + err.getText());
                this.valueText.setBackground(ColorRegistry.COLOR_ERROR);
            }
        }
    }

    private String[] getOperators() {
        String[] names = new String[OperatorType.values().length];
        int i = 0;
        OperatorType[] operatorTypeArray = OperatorType.values();
        int n = operatorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperatorType op = operatorTypeArray[n2];
            names[i] = ModelHelper.getReadable((OperatorType)op);
            ++i;
            ++n2;
        }
        return names;
    }

    protected EAttribute getCurrentValue() {
        return this.getElement().getAttribute();
    }

    protected PSAttributeConstraint getElement() {
        return (PSAttributeConstraint)super.getElement();
    }

    protected EStructuralFeature getFeature() {
        return SpecificationPackage.Literals.PS_ATTRIBUTE_CONSTRAINT__ATTRIBUTE;
    }

    protected String getLabelText() {
        return "Expression";
    }

    protected List<EAttribute> getPossibilities() {
        return ModelHelper.getAllValidAttributes((PSObject)((PSObject)this.getElement().getNode()));
    }

    protected String getValueText(Object element) {
        EAttribute attribute = (EAttribute)element;
        StringBuilder name = new StringBuilder();
        name.append(attribute.getName());
        if (attribute.getEAttributeType() != null) {
            name.append(": ");
            name.append(attribute.getEAttributeType().getName());
        }
        return name.toString();
    }
}

