/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.palette;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.editor.palette.PaletteEntryFactory;
import org.fujaba.commons.extensionpoints.util.ExtensionpointTools;
import org.osgi.framework.Bundle;
import org.reclipse.structure.specification.ModifierType;
import org.reclipse.structure.specification.ui.palette.PSCombinedFragmentCreationFactory;

public class PSPaletteEntryFactory
extends PaletteEntryFactory {
    private IConfigurationElement config;

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        this.config = configElement;
    }

    public PaletteEntry createPaletteEntry() {
        Class product;
        Bundle bundle = Platform.getBundle((String)this.config.getContributor().getName());
        if (bundle == null) {
            return null;
        }
        try {
            product = bundle.loadClass(this.config.getAttribute("product"));
        }
        catch (ClassNotFoundException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), (Throwable)e);
            return null;
        }
        ImageDescriptor icon16 = ExtensionpointTools.getImage((IConfigurationElement)this.config, (String)"icon16");
        ImageDescriptor icon24 = ExtensionpointTools.getImage((IConfigurationElement)this.config, (String)"icon24", (boolean)true);
        if (icon24 == null) {
            icon24 = icon16;
        }
        String label = this.config.getAttribute("label");
        String tooltip = this.config.getAttribute("tooltip");
        if (tooltip == null && label != null && label.length() > 0) {
            tooltip = "aAoOuUiI".contains(label.substring(0, 1)) ? "Create an " + label : "Create a " + label;
        }
        ModifierType kind = ModifierType.NONE;
        if (label.startsWith("Additional")) {
            kind = ModifierType.ADDITIONAL;
        } else if (label.startsWith("Negative")) {
            kind = ModifierType.NEGATIVE;
        } else if (label.startsWith("Set")) {
            kind = ModifierType.SET;
        }
        PSCombinedFragmentCreationFactory factory = new PSCombinedFragmentCreationFactory(product, kind);
        if ("element".equals(this.config.getAttribute("type"))) {
            return new CreationToolEntry(label, tooltip, (CreationFactory)factory, icon16, icon24);
        }
        return null;
    }
}

