/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fujaba.commons.edit.commands.SetConstraintCommand;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSCombinedFragmentEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSPatternSpecificationEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSSpecificationConstraintEditPart;

public class ResizeHandler
extends AbstractHandler {
    protected String TO_MINIMUM = "org.reclipse.structure.specification.ui.commands.ResizeToMinimumSize";
    protected String TO_PREFERRED = "org.reclipse.structure.specification.ui.commands.ResizeToPreferredSize";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ResizeFigureAction action = new ResizeFigureAction(event, event.getCommand().getId());
        action.run();
        return null;
    }

    public Command createResizeCommand(AbstractNodeEditPart part, boolean minimum) {
        Dimension dim = !minimum ? part.getPreferredSize() : part.getMinimumSize();
        int x = part.getModel().getX();
        int y = part.getModel().getY();
        return new SetConstraintCommand((AbstractNodeViewEditPart)part, new Rectangle(x, y, dim.width, dim.height));
    }

    private class ResizeFigureAction
    extends SelectionAction {
        private boolean minimum;
        private ExecutionEvent event;

        public ResizeFigureAction(ExecutionEvent event, String commandId) {
            super(HandlerUtil.getActivePart((ExecutionEvent)event));
            this.event = event;
            if (commandId.equals(ResizeHandler.this.TO_MINIMUM)) {
                this.minimum = true;
            }
        }

        public void run() {
            CompoundCommand cc = new CompoundCommand();
            if (HandlerUtil.getCurrentSelection((ExecutionEvent)this.event) instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
                for (Object o : selection.toList()) {
                    if (!(o instanceof PSPatternSpecificationEditPart)) continue;
                    PSPatternSpecificationEditPart root = (PSPatternSpecificationEditPart)((Object)o);
                    for (Object child : root.getChildren()) {
                        this.addCommands(cc, (AbstractNodeEditPart)child);
                    }
                }
                this.execute(cc.unwrap());
            }
        }

        private CompoundCommand addCommands(CompoundCommand cc, AbstractNodeEditPart ep) {
            if (ep instanceof PSCombinedFragmentEditPart) {
                for (Object child : ep.getChildren()) {
                    this.addCommands(cc, (AbstractNodeEditPart)child);
                }
            } else if (!(ep instanceof PSSpecificationConstraintEditPart)) {
                cc.add(ResizeHandler.this.createResizeCommand(ep, this.minimum));
            }
            return cc;
        }

        protected boolean calculateEnabled() {
            return true;
        }
    }
}

