/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.edit.commands.SetConstraintCommand;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeViewEditPart;
import org.reclipse.metrics.extensionpoints.Metric;
import org.reclipse.metrics.extensionpoints.MetricUtil;
import org.reclipse.structure.specification.OperatorType;
import org.reclipse.structure.specification.PSFuzzyConstraint;
import org.reclipse.structure.specification.PSObject;
import org.reclipse.structure.specification.SpecificationPackage;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSFuzzyConstraintCommand;
import org.reclipse.structure.specification.ui.edit.commands.CreatePSNodeConstraintCommand;
import org.reclipse.structure.specification.ui.edit.commands.EditPSFuzzyExpressionCommand;
import org.reclipse.structure.specification.ui.edit.parts.AbstractPSNodeConstraintEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSAnnotationEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSCombinedFragmentEditPart;
import org.reclipse.structure.specification.ui.edit.parts.PSObjectEditPart;
import org.reclipse.structure.specification.util.ModelHelper;

public class PSConstraintHandler
extends AbstractHandler {
    protected static final String METRIC = "org.reclipse.structure.specification.ui.commands.AddMetricConstraint";
    protected static final String ATTRIBUTE = "org.reclipse.structure.specification.ui.commands.AddAttributeConstraint";
    protected static final String SET_SIZE = "org.reclipse.structure.specification.ui.commands.AddSetSizeConstraint";
    protected static final String FUZZY_METRIC = "org.reclipse.structure.specification.ui.commands.AddFuzzyConstraint";
    protected static final String FUZZY_SIZE = "org.reclipse.structure.specification.ui.commands.AddFuzzySetConstraint";
    protected static final String FUZZY_SET_RATING = "org.reclipse.structure.specification.ui.commands.AddSetRatingFunction";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object o : strucSelection.toList()) {
                SelectionAction action;
                if (o instanceof PSObjectEditPart || o instanceof PSAnnotationEditPart || o instanceof PSCombinedFragmentEditPart) {
                    action = new CreateNodeConstraintAction(HandlerUtil.getActivePart((ExecutionEvent)event), (AbstractDiagramEditPart)o, event.getCommand().getId());
                    action.run();
                    continue;
                }
                if (!(o instanceof AbstractPSNodeConstraintEditPart)) continue;
                action = new EditNodeConstraintAction(HandlerUtil.getActivePart((ExecutionEvent)event), (AbstractPSNodeConstraintEditPart)((Object)o));
                action.run();
            }
        }
        return null;
    }

    private static class CreateNodeConstraintAction
    extends SelectionAction {
        private String id;
        private AbstractDiagramEditPart host;

        public CreateNodeConstraintAction(IWorkbenchPart part, AbstractDiagramEditPart host, String id) {
            super(part);
            this.id = id;
            this.host = host;
        }

        public void run() {
            String acronym;
            CompoundCommand command = new CompoundCommand();
            EClass type = null;
            String text = "";
            if (this.id.equals(PSConstraintHandler.FUZZY_METRIC) || this.id.equals(PSConstraintHandler.FUZZY_SIZE) || this.id.equals(PSConstraintHandler.FUZZY_SET_RATING)) {
                acronym = null;
                if (this.id.equals(PSConstraintHandler.FUZZY_METRIC)) {
                    type = SpecificationPackage.eINSTANCE.getPSFuzzyMetricConstraint();
                    if (!MetricUtil.getAllMetrics().isEmpty()) {
                        acronym = ((Metric)MetricUtil.getAllMetrics().iterator().next()).getAcronym();
                    }
                } else if (this.id.equals(PSConstraintHandler.FUZZY_SIZE)) {
                    type = SpecificationPackage.eINSTANCE.getPSFuzzyMetricConstraint();
                    acronym = "SIZE";
                } else if (this.id.equals(PSConstraintHandler.FUZZY_SET_RATING)) {
                    type = SpecificationPackage.eINSTANCE.getPSFuzzySetRatingConstraint();
                }
                text = "fuzzy constraint: " + acronym;
                command.add((Command)new CreatePSFuzzyConstraintCommand(this.host.getModel(), type, acronym));
            } else if (this.id.equals(PSConstraintHandler.METRIC) || this.id.equals(PSConstraintHandler.SET_SIZE)) {
                acronym = null;
                type = SpecificationPackage.eINSTANCE.getPSMetricConstraint();
                if (this.id.equals(PSConstraintHandler.METRIC) && !MetricUtil.getAllMetrics().isEmpty()) {
                    acronym = ((Metric)MetricUtil.getAllMetrics().iterator().next()).getAcronym();
                }
                if (this.id.equals(PSConstraintHandler.SET_SIZE)) {
                    acronym = "SIZE";
                }
                text = String.valueOf(acronym) + " " + ModelHelper.getReadable((OperatorType)OperatorType.EQUAL) + " null";
                command.add((Command)new CreatePSNodeConstraintCommand(this.host.getModel(), type, acronym));
            } else if (this.id.equals(PSConstraintHandler.ATTRIBUTE)) {
                text = String.valueOf(ModelHelper.getAttributeText((EAttribute)ModelHelper.getFirstAttribute((PSObject)((PSObject)this.host.getRealModel())))) + " " + ModelHelper.getReadable((OperatorType)OperatorType.EQUAL) + " null";
                command.add((Command)new CreatePSNodeConstraintCommand(this.host.getModel(), SpecificationPackage.eINSTANCE.getPSAttributeConstraint(), null));
            }
            if (!command.isEmpty()) {
                if (!(this.host instanceof PSCombinedFragmentEditPart)) {
                    Font font = Commons4EclipseFonts.getFont((String)"org.eclipse.jface.defaultfont");
                    Dimension size = TextUtilities.INSTANCE.getStringExtents(text, font);
                    Rectangle rect = new Rectangle();
                    rect.x = this.host.getModel().getX();
                    rect.y = this.host.getModel().getY();
                    rect.width = Math.max(this.host.getModel().getWidth(), size.width + 14);
                    rect.height = this.host.getModel().getHeight() + size.height + 5;
                    command.add((Command)new SetConstraintCommand((AbstractNodeViewEditPart)this.host, rect));
                }
                this.execute(command.unwrap());
            }
        }

        protected boolean calculateEnabled() {
            return this.host != null;
        }
    }

    private static class EditNodeConstraintAction
    extends SelectionAction {
        private PSFuzzyConstraint constraint;

        public EditNodeConstraintAction(IWorkbenchPart activePart, AbstractPSNodeConstraintEditPart constraintPart) {
            super(activePart);
            this.constraint = (PSFuzzyConstraint)constraintPart.getRealModel();
        }

        public void run() {
            if (this.calculateEnabled()) {
                EditPSFuzzyExpressionCommand command = new EditPSFuzzyExpressionCommand(this.constraint);
                this.execute(command);
            }
        }

        protected boolean calculateEnabled() {
            return this.constraint != null;
        }
    }
}

