/*
 * Decompiled with CFR 0.152.
 */
package org.reclipse.structure.specification.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.figures.LabelFigure;
import org.fujaba.commons.figures.LineBorderedRectangleWithCompartmentsFigure;
import org.fujaba.commons.figures.RectangleBorder;
import org.fujaba.commons.figures.ShadowDecoratorFigure;

public class PSObjectFigure
extends LineBorderedRectangleWithCompartmentsFigure {
    public static final String COMPARTMENT_NAME = "name";
    public static final String COMPARTMENT_MATCHED = "matched";
    public static final String COMPARTMENT_ATTR_EXPR = "attributes";
    public static final String COMPARTMENT_METRIC_EXPR = "metrics";
    public static final String COMPARTMENT_SET_EXPR = "set";
    private LabelFigure myLabel;
    private LabelFigure weightLabel;
    private LabelFigure matchedLabel;
    private boolean negative;
    private ShadowDecoratorFigure shadowDecorator;

    public PSObjectFigure() {
        this.setBorder((Border)new RectangleBorder(ColorConstants.black, 1));
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.black);
        this.addCompartment(COMPARTMENT_NAME, 1, 1);
        this.addCompartment(COMPARTMENT_MATCHED, 1, 1);
        this.addCompartment(COMPARTMENT_SET_EXPR, 1, 2);
        this.addCompartment(COMPARTMENT_ATTR_EXPR, 1, 1);
        this.addCompartment(COMPARTMENT_METRIC_EXPR, 0, 0);
        this.myLabel = new LabelFigure("", Commons4EclipseFonts.getFont((String)"org.fujaba.commons.FONT_BOLD"));
        this.myLabel.setUnderlined(true);
        MarginBorder border = new MarginBorder(2, 5, 2, 5);
        this.myLabel.setBorder((Border)border);
        this.matchedLabel = new LabelFigure("", Commons4EclipseFonts.getFont((String)"org.eclipse.jface.defaultfont"));
        this.matchedLabel.setLabelAlignment(1);
        this.matchedLabel.setBorder((Border)new MarginBorder(2, 5, 2, 5));
        this.weightLabel = new LabelFigure("", Commons4EclipseFonts.getFont((String)"org.eclipse.jface.defaultfont"));
        this.addFigureToCompartment(COMPARTMENT_NAME, (IFigure)this.myLabel);
    }

    public void addToAttributeConstraints(LabelFigure attrExprLabel) {
        this.addFigureToCompartment(COMPARTMENT_ATTR_EXPR, (IFigure)attrExprLabel);
    }

    public void addToMetricConstraints(LabelFigure metricExprLabel) {
        this.addFigureToCompartment(COMPARTMENT_METRIC_EXPR, (IFigure)metricExprLabel);
    }

    public void addToSetConstraints(LabelFigure setSizeExprLabel) {
        this.addFigureToCompartment(COMPARTMENT_SET_EXPR, (IFigure)setSizeExprLabel);
    }

    public String getName() {
        return this.myLabel.getText();
    }

    public boolean isDashedLine() {
        return this.getBorderLineStyle() == 2;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isNegative()) {
            Rectangle bounds = this.getBounds();
            graphics.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y);
            graphics.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
        }
    }

    public void removeFromAttributeConstraints(LabelFigure attrExprLabel) {
        this.removeFigureFromCompartment(COMPARTMENT_ATTR_EXPR, (IFigure)attrExprLabel);
    }

    public void removeFromMetricConstraints(LabelFigure metricExprLabel) {
        this.removeFigureFromCompartment(COMPARTMENT_METRIC_EXPR, (IFigure)metricExprLabel);
    }

    public void removeFromSetConstraints(LabelFigure setSizeExprLabel) {
        this.removeFigureFromCompartment(COMPARTMENT_SET_EXPR, (IFigure)setSizeExprLabel);
    }

    public void setDashedLine(boolean dashedLine) {
        if (dashedLine) {
            this.setBorderLineStyle(2);
        } else {
            this.setBorderLineStyle(1);
        }
    }

    public void setName(String name) {
        this.myLabel.setText(name);
    }

    public void setNegative(boolean negative) {
        if (this.negative != negative) {
            this.negative = negative;
            this.repaint();
        }
    }

    public void setShadowed(boolean shadowed) {
        if (shadowed) {
            this.shadowDecorator = new ShadowDecoratorFigure((IFigure)this, 5, -5);
            this.shadowDecorator.setOpaque(true);
        } else if (this.shadowDecorator != null) {
            this.shadowDecorator.removeDecorator();
            this.shadowDecorator = null;
        }
    }

    public void setTrigger(boolean trigger) {
        if (trigger && this.getBorderWidth() != 2) {
            this.setBorderWidth(2);
            this.repaint();
        } else if (!trigger && this.getBorderWidth() != 1) {
            this.setBorderWidth(1);
            this.repaint();
        }
    }

    public void setWeightText(String text) {
        if (text != null && text.length() > 0) {
            this.addFigureToCompartment(COMPARTMENT_NAME, (IFigure)this.weightLabel);
        } else {
            this.removeFigureFromCompartment(COMPARTMENT_NAME, (IFigure)this.weightLabel);
        }
        this.weightLabel.setText(text);
    }

    public void setMatchingName(String text) {
        if (text != null && !text.trim().isEmpty()) {
            this.addFigureToCompartment(COMPARTMENT_MATCHED, (IFigure)this.matchedLabel);
        } else {
            this.removeFigureFromCompartment(COMPARTMENT_MATCHED, (IFigure)this.matchedLabel);
        }
        this.matchedLabel.setText(text);
    }
}

